/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.javatime.JavaDurationColumnType;
import org.jetbrains.exposed.sql.javatime.JavaInstantColumnType;
import org.jetbrains.exposed.sql.javatime.JavaLocalDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaLocalDateTimeColumnType;
import org.jetbrains.exposed.sql.javatime.JavaLocalTimeColumnType;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d\u001a\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d\u001a\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d\u001a\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d\u001a\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"#\u0010\u0007\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\b\u0010\u0004\"#\u0010\n\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\u0006\u001a\u0004\b\u000b\u0010\u0004\"#\u0010\r\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0006\u001a\u0004\b\u000e\u0010\u0004\"#\u0010\u0010\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0006\u001a\u0004\b\u0011\u0010\u0004\"\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"DEFAULT_DATE_STRING_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDEFAULT_DATE_STRING_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "DEFAULT_DATE_STRING_FORMATTER$delegate", "Lkotlin/Lazy;", "DEFAULT_DATE_TIME_STRING_FORMATTER", "getDEFAULT_DATE_TIME_STRING_FORMATTER", "DEFAULT_DATE_TIME_STRING_FORMATTER$delegate", "DEFAULT_TIME_STRING_FORMATTER", "getDEFAULT_TIME_STRING_FORMATTER", "DEFAULT_TIME_STRING_FORMATTER$delegate", "ORACLE_TIME_STRING_FORMATTER", "getORACLE_TIME_STRING_FORMATTER", "ORACLE_TIME_STRING_FORMATTER$delegate", "SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER", "getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER", "SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate", "millis", "", "Ljava/time/LocalDate;", "getMillis", "(Ljava/time/LocalDate;)J", "dateTimeWithFractionFormat", "fraction", "", "formatterForDateString", "date", "", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/Table;", "name", "datetime", "Ljava/time/LocalDateTime;", "duration", "Ljava/time/Duration;", "time", "Ljava/time/LocalTime;", "timestamp", "Ljava/time/Instant;", "exposed-java-time"})
public final class JavaDateColumnTypeKt {
    @NotNull
    private static final Lazy DEFAULT_DATE_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_DATE_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy DEFAULT_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_DATE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy ORACLE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)ORACLE_TIME_STRING_FORMATTER.2.INSTANCE);
    @NotNull
    private static final Lazy DEFAULT_TIME_STRING_FORMATTER$delegate = LazyKt.lazy((Function0)DEFAULT_TIME_STRING_FORMATTER.2.INSTANCE);

    public static final DateTimeFormatter getDEFAULT_DATE_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    public static final DateTimeFormatter getDEFAULT_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    public static final DateTimeFormatter getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    public static final DateTimeFormatter getORACLE_TIME_STRING_FORMATTER() {
        Lazy lazy = ORACLE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    public static final DateTimeFormatter getDEFAULT_TIME_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    @NotNull
    public static final DateTimeFormatter formatterForDateString(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return JavaDateColumnTypeKt.dateTimeWithFractionFormat(StringsKt.substringAfterLast((String)date, (char)'.', (String)"").length());
    }

    @NotNull
    public static final DateTimeFormatter dateTimeWithFractionFormat(int fraction) {
        String string;
        String baseFormat = "yyyy-MM-d HH:mm:ss";
        boolean bl = 1 <= fraction ? fraction < 10 : false;
        if (bl) {
            IntRange intRange = new IntRange(1, fraction);
            String string2 = baseFormat + '.';
            string = CollectionsKt.joinToString$default((Iterable)((Iterable)intRange), (CharSequence)"", (CharSequence)string2, null, (int)0, null, (Function1)dateTimeWithFractionFormat.newFormat.1.INSTANCE, (int)28, null);
        } else {
            string = baseFormat;
        }
        String newFormat2 = string;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(newFormat2).withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(newFormat).wit\u2026e(ZoneId.systemDefault())");
        return dateTimeFormatter;
    }

    public static final long getMillis(@NotNull LocalDate $this$millis) {
        Intrinsics.checkNotNullParameter((Object)$this$millis, (String)"<this>");
        return $this$millis.atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * (long)1000;
    }

    @NotNull
    public static final Column<LocalDate> date(@NotNull Table $this$date, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$date, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$date.registerColumn(name, (IColumnType)new JavaLocalDateColumnType());
    }

    @NotNull
    public static final Column<LocalDateTime> datetime(@NotNull Table $this$datetime, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$datetime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$datetime.registerColumn(name, (IColumnType)new JavaLocalDateTimeColumnType());
    }

    @NotNull
    public static final Column<LocalTime> time(@NotNull Table $this$time, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$time, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$time.registerColumn(name, (IColumnType)new JavaLocalTimeColumnType());
    }

    @NotNull
    public static final Column<Instant> timestamp(@NotNull Table $this$timestamp, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$timestamp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$timestamp.registerColumn(name, (IColumnType)new JavaInstantColumnType());
    }

    @NotNull
    public static final Column<Duration> duration(@NotNull Table $this$duration, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$duration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$duration.registerColumn(name, (IColumnType)new JavaDurationColumnType());
    }
}

