/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalTime", "Ljava/time/LocalTime;", "kotlin.jvm.PlatformType", "millis", "", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Companion", "exposed-java-time"})
public final class JavaLocalTimeColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalTimeColumnType INSTANCE = new JavaLocalTimeColumnType();

    public JavaLocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof String) {
            return (String)value;
        }
        if (object2 instanceof LocalTime) {
            object = value;
        } else if (object2 instanceof Time) {
            object = Instant.ofEpochMilli(((Time)value).getTime()).atZone(ZoneId.systemDefault());
        } else if (object2 instanceof Timestamp) {
            object = Instant.ofEpochMilli(((Timestamp)value).getTime()).atZone(ZoneId.systemDefault());
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        Object instant = object;
        DateTimeFormatter formatter = DefaultKt.getCurrentDialect() instanceof OracleDialect ? JavaDateColumnTypeKt.getORACLE_TIME_STRING_FORMATTER() : JavaDateColumnTypeKt.getDEFAULT_TIME_STRING_FORMATTER();
        return '\'' + formatter.format((TemporalAccessor)instant) + '\'';
    }

    @NotNull
    public LocalTime valueFromDB(@NotNull Object value) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof LocalTime) {
            localTime = (LocalTime)value;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value).toLocalTime();
            localTime = localTime2;
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"value.toLocalTime()");
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value).toLocalDateTime().toLocalTime();
            localTime = localTime3;
            Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"value.toLocalDateTime().toLocalTime()");
        } else if (object instanceof Integer) {
            LocalTime localTime4 = this.longToLocalTime(((Number)value).intValue());
            localTime = localTime4;
            Intrinsics.checkNotNullExpressionValue((Object)localTime4, (String)"longToLocalTime(value.toLong())");
        } else if (object instanceof Long) {
            LocalTime localTime5 = this.longToLocalTime(((Number)value).longValue());
            localTime = localTime5;
            Intrinsics.checkNotNullExpressionValue((Object)localTime5, (String)"longToLocalTime(value)");
        } else if (object instanceof String) {
            DateTimeFormatter formatter = DefaultKt.getCurrentDialect() instanceof OracleDialect ? JavaDateColumnTypeKt.formatterForDateString((String)value) : JavaDateColumnTypeKt.getDEFAULT_TIME_STRING_FORMATTER();
            LocalTime localTime6 = LocalTime.parse((CharSequence)value, formatter);
            Intrinsics.checkNotNullExpressionValue((Object)localTime6, (String)"{\n            val format\u2026lue, formatter)\n        }");
            localTime = localTime6;
        } else {
            localTime = this.valueFromDB(value.toString());
        }
        return localTime;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof LocalTime) {
            Time time = Time.valueOf((LocalTime)value);
            object = time;
            Intrinsics.checkNotNullExpressionValue((Object)time, (String)"valueOf(value)");
        } else {
            object = value;
        }
        return object;
    }

    private final LocalTime longToLocalTime(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

