/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Ljava/time/OffsetDateTime;", "Companion", "exposed-java-time"})
public final class JavaOffsetDateTimeColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaOffsetDateTimeColumnType INSTANCE = new JavaOffsetDateTimeColumnType();

    public JavaOffsetDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timestampWithTimeZoneType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof OffsetDateTime) {
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? '\'' + ((OffsetDateTime)value).format(JavaDateColumnTypeKt.getSQLITE_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof MysqlDialect ? '\'' + ((OffsetDateTime)value).format(JavaDateColumnTypeKt.getMYSQL_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof OracleDialect ? '\'' + ((OffsetDateTime)value).format(JavaDateColumnTypeKt.getORACLE_OFFSET_DATE_TIME_FORMATTER()) + '\'' : '\'' + ((OffsetDateTime)value).format(JavaDateColumnTypeKt.getDEFAULT_OFFSET_DATE_TIME_FORMATTER()) + '\''));
    }

    @NotNull
    public OffsetDateTime valueFromDB(@NotNull Object value) {
        OffsetDateTime offsetDateTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof OffsetDateTime) {
            offsetDateTime = (OffsetDateTime)value;
        } else if (object instanceof String) {
            OffsetDateTime offsetDateTime2 = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? OffsetDateTime.parse((CharSequence)value, JavaDateColumnTypeKt.getSQLITE_OFFSET_DATE_TIME_FORMATTER()) : OffsetDateTime.parse((CharSequence)value);
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"{\n            if (curren\u2026)\n            }\n        }");
            offsetDateTime = offsetDateTime2;
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return offsetDateTime;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? super.readObject(rs, index) : rs.getObject(index, OffsetDateTime.class);
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof OffsetDateTime) {
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Object object = databaseDialect instanceof SQLiteDialect ? ((OffsetDateTime)value).format(JavaDateColumnTypeKt.getSQLITE_OFFSET_DATE_TIME_FORMATTER()) : (databaseDialect instanceof MysqlDialect ? ((OffsetDateTime)value).format(JavaDateColumnTypeKt.getMYSQL_OFFSET_DATE_TIME_FORMATTER()) : value);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (value) {\n        i\u2026ss.qualifiedName}\")\n    }");
        return object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaOffsetDateTimeColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaOffsetDateTimeColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

