/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcPreparedStatementImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcSavepoint;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0016\u0010'\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0)H\u0016J,\u0010\u0015\u001a\u0002H*\"\u0004\b\u0000\u0010*2\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u0002H*0,\u00a2\u0006\u0002\b.H\u0016\u00a2\u0006\u0002\u0010/J#\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\f04H\u0016\u00a2\u0006\u0002\u00105J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0006H\u0016J\u0010\u00107\u001a\u00020%2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020%H\u0016J\u0010\u0010:\u001a\u00020%2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020\fH\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011R$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006="}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcConnectionImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "Ljava/sql/Connection;", "connection", "(Ljava/sql/Connection;)V", "value", "", "autoCommit", "getAutoCommit", "()Z", "setAutoCommit", "(Z)V", "", "catalog", "getCatalog", "()Ljava/lang/String;", "setCatalog", "(Ljava/lang/String;)V", "getConnection", "()Ljava/sql/Connection;", "isClosed", "metadata", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "getMetadata", "()Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "metadata$delegate", "Lkotlin/Lazy;", "schema", "getSchema", "setSchema", "", "transactionIsolation", "getTransactionIsolation", "()I", "setTransactionIsolation", "(I)V", "close", "", "commit", "executeInBatch", "sqls", "", "T", "body", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "prepareStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "sql", "columns", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "returnKeys", "releaseSavepoint", "savepoint", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "rollback", "setSavepoint", "name", "exposed-jdbc"})
public final class JdbcConnectionImpl
implements ExposedConnection<Connection> {
    private final Lazy metadata$delegate;
    @NotNull
    private final Connection connection;

    @NotNull
    public String getCatalog() {
        String string;
        String string2;
        String string3;
        try {
            string3 = this.getConnection().getCatalog();
        }
        catch (Exception _) {
            string3 = null;
        }
        if ((string2 = string3) == null) {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"connection.metaData");
            string2 = string = databaseMetaData.getUserName();
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    public void setCatalog(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            this.getConnection().setCatalog(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public String getSchema() {
        String string;
        try {
            String string2 = this.getConnection().getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.schema");
            string = string2;
        }
        catch (Exception _) {
            string = "";
        }
        return string;
    }

    public void setSchema(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            this.getConnection().setSchema(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
        this.getConnection().commit();
    }

    public void rollback() {
        this.getConnection().rollback();
    }

    public boolean isClosed() {
        return this.getConnection().isClosed();
    }

    public void close() {
        this.getConnection().close();
    }

    public boolean getAutoCommit() {
        return this.getConnection().getAutoCommit();
    }

    public void setAutoCommit(boolean value) {
        this.getConnection().setAutoCommit(value);
    }

    public int getTransactionIsolation() {
        return this.getConnection().getTransactionIsolation();
    }

    public void setTransactionIsolation(int value) {
        this.getConnection().setTransactionIsolation(value);
    }

    private final JdbcDatabaseMetadataImpl getMetadata() {
        Lazy lazy = this.metadata$delegate;
        JdbcConnectionImpl jdbcConnectionImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (JdbcDatabaseMetadataImpl)((Object)lazy.getValue());
    }

    public <T> T metadata(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return (T)body.invoke((Object)this.getMetadata());
    }

    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, boolean returnKeys) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        int generated = returnKeys ? 1 : 2;
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, generated);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"connection.prepareStatement(sql, generated)");
        return new JdbcPreparedStatementImpl(preparedStatement, returnKeys);
    }

    @NotNull
    public PreparedStatementApi prepareStatement(@NotNull String sql, @NotNull String[] columns2) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, columns2);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"connection.prepareStatement(sql, columns)");
        return new JdbcPreparedStatementImpl(preparedStatement, true);
    }

    /*
     * WARNING - void declaration
     */
    public void executeInBatch(@NotNull List<String> sqls) {
        boolean bl;
        boolean $i$f$none;
        List types;
        block9: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(sqls, (String)"sqls");
            Iterable $this$map$iv = sqls;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                StatementType statementType;
                StatementType statementType2;
                Collection collection;
                block8: {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    StatementType[] statementTypeArray = StatementType.values();
                    boolean bl3 = false;
                    StatementType[] statementTypeArray2 = statementTypeArray;
                    boolean bl4 = false;
                    StatementType[] statementTypeArray3 = statementTypeArray2;
                    int n = statementTypeArray3.length;
                    for (int i = 0; i < n; ++i) {
                        void stmt;
                        StatementType statementType3;
                        StatementType it = statementType3 = statementTypeArray3[i];
                        boolean bl5 = false;
                        if (!StringsKt.startsWith((String)stmt, (String)it.name(), (boolean)true)) continue;
                        statementType2 = statementType3;
                        break block8;
                    }
                    statementType2 = statementType = null;
                }
                if (statementType2 == null) {
                    statementType = StatementType.OTHER;
                }
                StatementType statementType4 = statementType;
                collection.add(statementType4);
            }
            types = (List)destination$iv$iv;
            Iterable $this$none$iv = types;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    StatementType it = (StatementType)element$iv;
                    boolean bl6 = false;
                    if (!(it == StatementType.SELECT)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        boolean $this$none$iv = bl;
        $i$f$none = false;
        boolean bl7 = false;
        if (!$this$none$iv) {
            boolean bl8 = false;
            String string = "SELECT statements are unsupported in batch execution";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        StatementType statementType = (StatementType)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)types));
        if (statementType == null) {
            statementType = StatementType.OTHER;
        }
        StatementType type = statementType;
        Statement<Unit> prepStatement2 = new Statement<Unit>(this, sqls, type, type, CollectionsKt.emptyList()){
            final /* synthetic */ JdbcConnectionImpl this$0;
            final /* synthetic */ List $sqls;
            final /* synthetic */ StatementType $type;

            @NotNull
            public PreparedStatementApi prepared(@NotNull Transaction transaction, @NotNull String sql) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
                PreparedStatementApi originalStatement = super.prepared(transaction, StringsKt.substringBefore$default((String)sql, (char)'\n', null, (int)2, null));
                java.sql.Statement statement = this.this$0.getConnection().createStatement();
                boolean bl = false;
                boolean bl2 = false;
                java.sql.Statement $this$apply = statement;
                boolean bl3 = false;
                Iterable $this$forEach$iv = this.$sqls;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    $this$apply.addBatch(it);
                }
                java.sql.Statement batchStatement = statement;
                return new PreparedStatementApi(batchStatement, originalStatement){
                    private final /* synthetic */ PreparedStatementApi $$delegate_0;
                    final /* synthetic */ java.sql.Statement $batchStatement;
                    final /* synthetic */ PreparedStatementApi $originalStatement;

                    public void closeIfPossible() {
                        this.$batchStatement.close();
                        this.$originalStatement.closeIfPossible();
                    }

                    public int executeUpdate() {
                        this.$batchStatement.executeBatch();
                        return 0;
                    }
                    {
                        this.$batchStatement = $captured_local_variable$0;
                        this.$originalStatement = $captured_local_variable$1;
                        this.$$delegate_0 = $captured_local_variable$1;
                    }

                    @Nullable
                    public Integer getFetchSize() {
                        return this.$$delegate_0.getFetchSize();
                    }

                    public void setFetchSize(@Nullable Integer n) {
                        this.$$delegate_0.setFetchSize(n);
                    }

                    @Nullable
                    public ResultSet getResultSet() {
                        return this.$$delegate_0.getResultSet();
                    }

                    public void addBatch() {
                        this.$$delegate_0.addBatch();
                    }

                    @NotNull
                    public List<Integer> executeBatch() {
                        return this.$$delegate_0.executeBatch();
                    }

                    @NotNull
                    public ResultSet executeQuery() {
                        return this.$$delegate_0.executeQuery();
                    }

                    public int fillParameters(@NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args) {
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$$delegate_0.fillParameters(args);
                    }

                    public void set(int index, @NotNull Object value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        this.$$delegate_0.set(index, value);
                    }

                    public void setInputStream(int index, @NotNull InputStream inputStream) {
                        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                        this.$$delegate_0.setInputStream(index, inputStream);
                    }

                    public void setNull(int index, @NotNull IColumnType columnType) {
                        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
                        this.$$delegate_0.setNull(index, columnType);
                    }
                };
            }

            public void executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"$this$executeInternal");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                $this$executeInternal.executeUpdate();
            }

            @NotNull
            public String prepareSQL(@NotNull Transaction transaction) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                return CollectionsKt.joinToString$default((Iterable)this.$sqls, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            }

            @NotNull
            public Iterable<Iterable<Pair<ColumnType, Object>>> arguments() {
                return CollectionsKt.emptyList();
            }
            {
                this.this$0 = this$0;
                this.$sqls = $captured_local_variable$1;
                this.$type = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
        prepStatement2.execute(TransactionManager.Companion.current());
    }

    @NotNull
    public ExposedSavepoint setSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Savepoint savepoint = this.getConnection().setSavepoint(name);
        Intrinsics.checkNotNullExpressionValue((Object)savepoint, (String)"connection.setSavepoint(name)");
        return new JdbcSavepoint(name, savepoint);
    }

    public void releaseSavepoint(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().releaseSavepoint(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    public void rollback(@NotNull ExposedSavepoint savepoint) {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.getConnection().rollback(((JdbcSavepoint)savepoint).getSavepoint$exposed_jdbc());
    }

    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    public JdbcConnectionImpl(@NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        this.metadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JdbcDatabaseMetadataImpl>(this){
            final /* synthetic */ JdbcConnectionImpl this$0;

            @NotNull
            public final JdbcDatabaseMetadataImpl invoke() {
                String string = this.this$0.getCatalog();
                DatabaseMetaData databaseMetaData = this.this$0.getConnection().getMetaData();
                Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"connection.metaData");
                return new JdbcDatabaseMetadataImpl(string, databaseMetaData);
            }
            {
                this.this$0 = jdbcConnectionImpl;
                super(0);
            }
        }));
    }
}

