/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImplKt;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcIdentifierManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ^2\u00020\u0001:\u0002]^B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010A\u001a\u00020BH\u0016J3\u0010C\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u001d062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ3\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ/\u0010I\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010J062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ-\u0010K\u001a\b\u0012\u0004\u0012\u0002HM0L\"\u0004\b\u0000\u0010M2\u0017\u0010N\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HM0O\u00a2\u0006\u0002\bPH\u0002J\b\u0010Q\u001a\u00020BH\u0016J\u0010\u0010R\u001a\u00020\u00032\u0006\u0010S\u001a\u00020\u0003H\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002J(\u0010T\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020U0\u001d062\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001dH\u0016J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010W\u001a\u00020\u0003H\u0002JS\u0010X\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u001d06*\u00020Y2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F2\u001e\u0010Z\u001a\u001a\u0012\u0004\u0012\u00020Y\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020D0[0OH\u0002\u00a2\u0006\u0002\u0010\\R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001b\u0010\f\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u001b\u0010\u0012\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0013\u0010\tR\u001b\u0010\u0015\u001a\u00020\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R6\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001bj\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001b\u0010*\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000f\u001a\u0004\b,\u0010-R\u001b\u0010/\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u000f\u001a\u0004\b0\u0010-R\u001b\u00102\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u000f\u001a\u0004\b3\u0010-R&\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001d068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001b\u00109\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u000f\u001a\u0004\b:\u0010\tR\u001b\u0010<\u001a\u00020=8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u000f\u001a\u0004\b>\u0010?\u00a8\u0006_"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "database", "", "metadata", "Ljava/sql/DatabaseMetaData;", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "_currentScheme", "get_currentScheme", "()Ljava/lang/String;", "currentScheme", "getCurrentScheme", "databaseDialectName", "getDatabaseDialectName", "databaseDialectName$delegate", "Lkotlin/Lazy;", "databaseName", "getDatabaseName", "databaseProductVersion", "getDatabaseProductVersion", "databaseProductVersion$delegate", "defaultIsolationLevel", "", "getDefaultIsolationLevel", "()I", "defaultIsolationLevel$delegate", "existingIndicesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/exposed/sql/Table;", "", "Lorg/jetbrains/exposed/sql/Index;", "Lkotlin/collections/HashMap;", "identifierManager", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "schemaNames", "getSchemaNames", "()Ljava/util/List;", "supportsAlterTableWithAddColumn", "", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn$delegate", "supportsMultipleResultSets", "getSupportsMultipleResultSets", "supportsMultipleResultSets$delegate", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "supportsSelectForUpdate$delegate", "tableNames", "", "getTableNames", "()Ljava/util/Map;", "url", "getUrl", "url$delegate", "version", "Ljava/math/BigDecimal;", "getVersion", "()Ljava/math/BigDecimal;", "version$delegate", "cleanCache", "", "columns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "existingIndices", "existingPrimaryKeys", "Lorg/jetbrains/exposed/sql/vendors/PrimaryKeyMetadata;", "lazyMetadata", "Lkotlin/Lazy;", "T", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "resetCurrentScheme", "sanitizedDefault", "defaultValue", "tableConstraints", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tableNamesFor", "scheme", "extractColumns", "Ljava/sql/ResultSet;", "extract", "Lkotlin/Pair;", "(Ljava/sql/ResultSet;[Lorg/jetbrains/exposed/sql/Table;Lkotlin/jvm/functions/Function1;)Ljava/util/Map;", "CachableMapWithDefault", "Companion", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcDatabaseMetadataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,314:1\n1#2:315\n1#2:384\n1549#3:316\n1620#3,3:317\n1194#3,2:343\n1222#3,4:345\n3190#3,10:366\n1549#3:376\n1620#3,3:377\n1549#3:380\n1620#3,3:381\n1194#3,2:397\n1222#3,4:399\n1271#3,2:403\n1285#3,2:405\n1477#3:407\n1502#3,3:408\n1505#3,3:418\n1549#3:421\n1620#3,2:422\n2661#3,7:424\n1622#3:431\n1288#3:432\n8541#4,2:320\n8801#4,4:322\n9226#4,2:391\n9376#4,4:393\n372#5,7:326\n372#5,3:333\n372#5,7:336\n551#5:349\n536#5,6:350\n375#5,4:387\n372#5,7:411\n135#6,9:356\n215#6:365\n216#6:385\n144#6:386\n*S KotlinDebug\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl\n*L\n226#1:384\n129#1:316\n129#1:317,3\n224#1:343,2\n224#1:345,4\n227#1:366,10\n228#1:376\n228#1:377,3\n234#1:380\n234#1:381,3\n261#1:397,2\n261#1:399,4\n262#1:403,2\n262#1:405,2\n288#1:407\n288#1:408,3\n288#1:418,3\n290#1:421\n290#1:422,2\n290#1:424,7\n290#1:431\n262#1:432\n136#1:320,2\n136#1:322,4\n245#1:391,2\n245#1:393,4\n142#1:326,7\n195#1:333,3\n219#1:336,7\n225#1:349\n225#1:350,6\n195#1:387,4\n288#1:411,7\n226#1:356,9\n226#1:365\n226#1:385\n226#1:386\n*E\n"})
public final class JdbcDatabaseMetadataImpl
extends ExposedDatabaseMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseMetaData metadata;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy databaseDialectName$delegate;
    @NotNull
    private final Lazy databaseProductVersion$delegate;
    @NotNull
    private final Lazy defaultIsolationLevel$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private String _currentScheme;
    @NotNull
    private final HashMap<Table, List<Index>> existingIndicesCache;
    @NotNull
    private static final ConcurrentHashMap<String, JdbcIdentifierManager> identityManagerCache = new ConcurrentHashMap();

    public JdbcDatabaseMetadataImpl(@NotNull String database, @NotNull DatabaseMetaData metadata2) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        super(database);
        this.metadata = metadata2;
        this.url$delegate = this.lazyMetadata(url.2.INSTANCE);
        this.version$delegate = this.lazyMetadata(version.2.INSTANCE);
        this.databaseDialectName$delegate = this.lazyMetadata(databaseDialectName.2.INSTANCE);
        this.databaseProductVersion$delegate = this.lazyMetadata(databaseProductVersion.2.INSTANCE);
        this.defaultIsolationLevel$delegate = this.lazyMetadata(defaultIsolationLevel.2.INSTANCE);
        this.supportsAlterTableWithAddColumn$delegate = this.lazyMetadata(supportsAlterTableWithAddColumn.2.INSTANCE);
        this.supportsMultipleResultSets$delegate = this.lazyMetadata(supportsMultipleResultSets.2.INSTANCE);
        this.supportsSelectForUpdate$delegate = this.lazyMetadata(supportsSelectForUpdate.2.INSTANCE);
        this.identifierManager$delegate = this.lazyMetadata(identifierManager.2.INSTANCE);
        this.existingIndicesCache = new HashMap();
    }

    @NotNull
    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    @NotNull
    public String getUrl() {
        Lazy lazy = this.url$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-url>(...)");
        return (String)object;
    }

    @NotNull
    public BigDecimal getVersion() {
        Lazy lazy = this.version$delegate;
        return (BigDecimal)lazy.getValue();
    }

    @NotNull
    public String getDatabaseDialectName() {
        Lazy lazy = this.databaseDialectName$delegate;
        return (String)lazy.getValue();
    }

    private final String getDatabaseName() {
        String string = this.getDatabaseDialectName();
        return (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) ? this.getCurrentScheme() : this.getDatabase();
    }

    @NotNull
    public String getDatabaseProductVersion() {
        Lazy lazy = this.databaseProductVersion$delegate;
        return (String)lazy.getValue();
    }

    public int getDefaultIsolationLevel() {
        Lazy lazy = this.defaultIsolationLevel$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean getSupportsMultipleResultSets() {
        Lazy lazy = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public IdentifierManagerApi getIdentifierManager() {
        Lazy lazy = this.identifierManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-identifierManager>(...)");
        return (IdentifierManagerApi)object;
    }

    private final String get_currentScheme() {
        if (this._currentScheme == null) {
            String string;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl2 = this;
            try {
                String string2;
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = this.getDatabaseDialectName();
                if (Intrinsics.areEqual((Object)string, (Object)MysqlDialect.Companion.getDialectName()) ? true : Intrinsics.areEqual((Object)string, (Object)MariaDBDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getCatalog();
                    if (string2 == null) {
                        string2 = "";
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)OracleDialect.Companion.getDialectName())) {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = this.getDatabaseName();
                    }
                } else {
                    string2 = this.metadata.getConnection().getSchema();
                    if (string2 == null) {
                        string2 = "";
                    }
                }
                string = string2;
            }
            catch (Throwable _) {
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = "";
            }
            jdbcDatabaseMetadataImpl._currentScheme = string;
        }
        String string = this._currentScheme;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public String getCurrentScheme() {
        String string = this.get_currentScheme();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public void resetCurrentScheme() {
        this._currentScheme = null;
    }

    @NotNull
    public Map<String, List<String>> getTableNames() {
        return new CachableMapWithDefault(this, null, (Function1)new Function1<String, List<? extends String>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull String schemeName) {
                Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
                return JdbcDatabaseMetadataImpl.access$tableNamesFor(this.this$0, schemeName);
            }
        }, 1, null);
    }

    private final List<String> tableNamesFor(String scheme) {
        String string;
        CharSequence charSequence;
        Pair pair;
        DatabaseMetaData $this$tableNamesFor_u24lambda_u242 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DefaultKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            pair = TuplesKt.to((Object)scheme, (Object)"%");
        } else if (DefaultKt.getCurrentDialect() instanceof OracleDialect) {
            CharSequence charSequence2;
            String string2 = this.getDatabaseName();
            charSequence = scheme;
            if (charSequence.length() == 0) {
                string = string2;
                boolean bl2 = false;
                charSequence2 = this.getDatabaseName();
                string2 = string;
            } else {
                charSequence2 = charSequence;
            }
            pair = TuplesKt.to((Object)string2, (Object)charSequence2);
        } else {
            CharSequence charSequence3;
            String string3 = this.getDatabaseName();
            charSequence = scheme;
            if (charSequence.length() == 0) {
                string = string3;
                boolean bl3 = false;
                charSequence3 = "%";
                string3 = string;
            } else {
                charSequence3 = charSequence;
            }
            pair = TuplesKt.to((Object)string3, (Object)charSequence3);
        }
        Pair pair2 = pair;
        String catalogName = (String)pair2.component1();
        String schemeName = (String)pair2.component2();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = $this$tableNamesFor_u24lambda_u242.getTables(catalogName, schemeName, "%", stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
        return JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, String>(useCatalogInsteadOfScheme, this){
            final /* synthetic */ boolean $useCatalogInsteadOfScheme;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$useCatalogInsteadOfScheme = $useCatalogInsteadOfScheme;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ResultSet $this$iterate) {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
                String string3 = $this$iterate.getString("TABLE_NAME");
                Intrinsics.checkNotNull((Object)string3);
                String tableName = string3;
                if (this.$useCatalogInsteadOfScheme) {
                    String string4 = $this$iterate.getString("TABLE_CAT");
                    if (string4 != null) {
                        String it = string4;
                        boolean bl = false;
                        string2 = it + '.' + tableName;
                    } else {
                        string2 = null;
                    }
                } else {
                    String string5 = $this$iterate.getString("TABLE_SCHEM");
                    if (string5 != null) {
                        String it = string5;
                        boolean bl = false;
                        string2 = it + '.' + tableName;
                    } else {
                        string2 = string = null;
                    }
                }
                if (string2 == null) {
                    string = tableName;
                }
                String fullTableName = string;
                return this.this$0.getIdentifierManager().inProperCase(fullTableName);
            }
        });
    }

    @NotNull
    public List<String> getSchemaNames() {
        return this.schemaNames();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> schemaNames() {
        void $this$mapTo$iv$iv;
        List list;
        DatabaseMetaData $this$schemaNames_u24lambda_u244 = this.metadata;
        boolean bl = false;
        boolean useCatalogInsteadOfScheme = DefaultKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            ResultSet resultSet = $this$schemaNames_u24lambda_u244.getCatalogs();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"catalogs");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.1.INSTANCE);
        } else {
            ResultSet resultSet = $this$schemaNames_u24lambda_u244.getSchemas();
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"schemas");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.2.INSTANCE);
        }
        List schemas2 = list;
        Iterable $this$map$iv = schemas2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(identifierManagerApi.inProperCase((String)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Table, List<ColumnMetadata>> extractColumns(ResultSet $this$extractColumns, Table[] tables, Function1<? super ResultSet, Pair<String, ColumnMetadata>> extract) {
        void $this$associateByTo$iv$iv;
        Table[] $this$associateBy$iv = tables;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        Table[] tableArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var14_16 = element$iv$iv = $this$associateByTo$iv$iv[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.nameInDatabaseCaseUnquoted(), element$iv$iv);
        }
        Map mapping = destination$iv$iv;
        HashMap result2 = new HashMap();
        while ($this$extractColumns.next()) {
            Object object;
            Table t;
            Pair pair = (Pair)extract.invoke((Object)$this$extractColumns);
            String tableName = (String)pair.component1();
            ColumnMetadata columnMetadata = (ColumnMetadata)pair.component2();
            if ((Table)mapping.get(tableName) == null) continue;
            boolean bl = false;
            Map $this$getOrPut$iv = result2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(t);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(t, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(columnMetadata);
        }
        return result2;
    }

    @NotNull
    public Map<Table, List<ColumnMetadata>> columns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        ResultSet rs = this.metadata.getColumns(this.getDatabaseName(), this.getCurrentScheme(), "%", "%");
        Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
        Map<Table, List<ColumnMetadata>> result2 = this.extractColumns(rs, tables, (Function1<? super ResultSet, Pair<String, ColumnMetadata>>)((Function1)new Function1<ResultSet, Pair<? extends String, ? extends ColumnMetadata>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<String, ColumnMetadata> invoke(@NotNull ResultSet it) {
                Object object;
                void it22;
                String string;
                int n;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = it.getString("COLUMN_DEF");
                if (string2 != null) {
                    String string3 = string2;
                    JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                    String it3 = string3;
                    n = 0;
                    string = JdbcDatabaseMetadataImpl.access$sanitizedDefault(jdbcDatabaseMetadataImpl, it3);
                } else {
                    string = null;
                }
                String defaultDbValue = string;
                boolean autoIncrement = Intrinsics.areEqual((Object)it.getString("IS_AUTOINCREMENT"), (Object)"YES");
                int type = it.getInt("DATA_TYPE");
                String string4 = it.getString("COLUMN_NAME");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.getString(\"COLUMN_NAME\")");
                Object object2 = it.getInt("COLUMN_SIZE");
                n = ((Number)object2).intValue();
                boolean bl = it.getBoolean("NULLABLE");
                int n2 = type;
                String string5 = string4;
                boolean bl2 = false;
                Comparable<Boolean> comparable = it22 != false;
                String string6 = string5;
                int n3 = n2;
                boolean bl3 = bl;
                Object object3 = comparable != false ? object2 : null;
                boolean bl4 = autoIncrement;
                String string7 = defaultDbValue;
                if (string7 != null) {
                    Object it22 = object2 = string7;
                    boolean bl5 = bl4;
                    comparable = object3;
                    bl = bl3;
                    n2 = n3;
                    string5 = string6;
                    boolean bl6 = false;
                    boolean bl7 = !autoIncrement;
                    string6 = string5;
                    n3 = n2;
                    bl3 = bl;
                    object3 = comparable;
                    bl4 = bl5;
                    object = bl7 ? object2 : null;
                } else {
                    object = null;
                }
                Object object4 = object;
                boolean bl8 = bl4;
                Integer n4 = object3;
                boolean bl9 = bl3;
                int n5 = n3;
                String string8 = string6;
                ColumnMetadata columnMetadata = new ColumnMetadata(string8, n5, bl9, n4, bl8, object4);
                return TuplesKt.to((Object)it.getString("TABLE_NAME"), (Object)columnMetadata);
            }
        }));
        rs.close();
        return result2;
    }

    private final String sanitizedDefault(String defaultValue) {
        String string;
        DatabaseDialect dialect = DefaultKt.getCurrentDialect();
        H2Dialect.H2CompatibilityMode h2Mode = H2Kt.getH2Mode((DatabaseDialect)dialect);
        if (dialect instanceof SQLServerDialect) {
            char[] cArray = new char[]{'(', ')', '\''};
            string = StringsKt.trim((String)defaultValue, (char[])cArray);
        } else if (dialect instanceof OracleDialect || h2Mode == H2Dialect.H2CompatibilityMode.Oracle) {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)defaultValue)).toString(), (char[])cArray);
        } else if (dialect instanceof MysqlDialect || h2Mode == H2Dialect.H2CompatibilityMode.MySQL || h2Mode == H2Dialect.H2CompatibilityMode.MariaDB) {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)StringsKt.substringAfter$default((String)defaultValue, (String)"b'", null, (int)2, null), (char[])cArray);
        } else if (dialect instanceof PostgreSQLDialect || h2Mode == H2Dialect.H2CompatibilityMode.PostgreSQL) {
            if (StringsKt.startsWith$default((CharSequence)defaultValue, (char)'\'', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)defaultValue, (char)'\'', (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{'\''};
                string = StringsKt.trim((String)defaultValue, (char[])cArray);
            } else {
                string = defaultValue;
            }
        } else {
            char[] cArray = new char[]{'\''};
            string = StringsKt.trim((String)defaultValue, (char[])cArray);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        for (Table table : tables) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterNotTo$iv$iv;
            void $this$associateByTo$iv$iv;
            Column $this$getOrPut$iv;
            Transaction transaction = TransactionManager.Companion.current();
            Map $this$getOrPut$iv2 = this.existingIndicesCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(table);
            if (value$iv != null) continue;
            boolean bl = false;
            ResultSet rs = this.metadata.getPrimaryKeys(this.getDatabaseName(), this.getCurrentScheme(), table.nameInDatabaseCaseUnquoted());
            boolean bl2 = false;
            ArrayList names = new ArrayList();
            while (rs.next()) {
                String string;
                String string2 = string = rs.getString("PK_NAME");
                if (string2 == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\"PK_NAME\")");
                String it = string;
                boolean bl3 = false;
                ((Collection)names).add(it);
            }
            rs.close();
            ArrayList pkNames = names;
            ResultSet rs2 = this.metadata.getIndexInfo(this.getDatabaseName(), this.getCurrentScheme(), table.nameInDatabaseCase(), false, false);
            HashMap tmpIndices = new HashMap();
            while (rs2.next()) {
                Object object;
                String columnName;
                String columnNameMetadata;
                String string = bl2 = rs2.getString("INDEX_NAME");
                if (string == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(\"INDEX_NAME\")");
                String indexName = bl2;
                boolean bl4 = false;
                String string3 = rs2.getString("COLUMN_NAME");
                if (string3 == null) {
                    DatabaseDialect bl3 = DefaultKt.getCurrentDialect();
                    string3 = (bl3 instanceof MysqlDialect ? true : bl3 instanceof SQLiteDialect) ? "\"\"" : null;
                }
                if ((columnNameMetadata = string3) == null) continue;
                boolean bl5 = false;
                String column = transaction.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(columnName);
                boolean isUnique = !rs2.getBoolean("NON_UNIQUE");
                Object object2 = rs2.getString("FILTER_CONDITION");
                Op.TRUE isPartial = object2 == null || object2.length() == 0 ? null : Op.TRUE.INSTANCE;
                object2 = tmpIndices;
                Triple key$iv = new Triple((Object)indexName, (Object)isUnique, (Object)isPartial);
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv.get(key$iv);
                if (value$iv2 == null) {
                    boolean bl6 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                ((List)object).add(column);
            }
            rs2.close();
            Iterable $this$associateBy$iv = table.getColumns();
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable columnName = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                $this$getOrPut$iv = (Column)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl7 = false;
                map.put(transaction.identity((Column)it), element$iv$iv);
            }
            Map tColumns = destination$iv$iv;
            Map $this$filterNot$iv = tmpIndices;
            boolean $i$f$filterNot = false;
            Map capacity$iv22 = $this$filterNot$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterNotTo = false;
            Iterator $i$f$associateByTo22 = $this$filterNotTo$iv$iv.entrySet().iterator();
            while ($i$f$associateByTo22.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = $i$f$associateByTo22.next();
                boolean bl8 = false;
                if (pkNames.contains(((Triple)it.getKey()).getFirst())) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filterNot$iv = destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Index index;
                List list;
                List list2;
                void $this$mapTo$iv$iv;
                Object element$iv2;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl9 = false;
                Map.Entry entry = element$iv$iv;
                boolean bl10 = false;
                Triple index2 = (Triple)entry.getKey();
                List columns2 = (List)entry.getValue();
                Iterable $this$partition$iv = CollectionsKt.distinct((Iterable)columns2);
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv2 : $this$partition$iv) {
                    String cn = (String)element$iv2;
                    boolean bl11 = false;
                    if (tColumns.get(cn) == null) {
                        first$iv.add(element$iv2);
                        continue;
                    }
                    second$iv.add(element$iv2);
                }
                Pair pair = new Pair(first$iv, second$iv);
                List functionBased = (List)pair.component1();
                List columnBased = (List)pair.component2();
                Iterable $this$map$iv = columnBased;
                boolean $i$f$map = false;
                element$iv2 = $this$map$iv;
                Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void cn;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl12 = false;
                    Object v = tColumns.get(cn);
                    Intrinsics.checkNotNull(v);
                    collection.add((Column)v);
                }
                List c = list2 = (List)destination$iv$iv3;
                boolean bl13 = false;
                List list3 = list = c.size() + functionBased.size() == columns2.size() ? list2 : null;
                if (list != null) {
                    Collection<LiteralOp> collection;
                    Collection<LiteralOp> collection2;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    c = list;
                    boolean bl14 = false;
                    destination$iv$iv3 = functionBased;
                    Op op = (Op)index2.getThird();
                    Iterator iterator2 = null;
                    String string = (String)index2.getFirst();
                    boolean bl15 = (Boolean)index2.getSecond();
                    List list4 = c;
                    boolean $i$f$map2 = false;
                    void var45_73 = $this$map$iv2;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        String string4 = (String)item$iv$iv;
                        collection2 = destination$iv$iv4;
                        boolean bl16 = false;
                        collection2.add(OpKt.stringLiteral((String)it));
                    }
                    collection2 = (List)destination$iv$iv4;
                    List list5 = list4;
                    boolean bl17 = bl15;
                    String string5 = string;
                    Iterator iterator3 = iterator2;
                    Op op2 = op;
                    Collection<LiteralOp> collection3 = collection2;
                    if (collection3.isEmpty()) {
                        op = op2;
                        iterator2 = iterator3;
                        string = string5;
                        bl15 = bl17;
                        list4 = list5;
                        boolean bl18 = false;
                        collection2 = null;
                        list5 = list4;
                        bl17 = bl15;
                        string5 = string;
                        iterator3 = iterator2;
                        op2 = op;
                        collection = collection2;
                    } else {
                        collection = collection3;
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 8;
                    Table table2 = !((Collection)functionBased).isEmpty() ? table : null;
                    List list6 = (List)collection;
                    Op op3 = op2;
                    Iterator iterator4 = iterator3;
                    String string6 = string5;
                    boolean bl19 = bl17;
                    List list7 = list5;
                    index = new Index(list7, bl19, string6, iterator4, op3, list6, table2, n, defaultConstructorMarker);
                } else {
                    index = null;
                }
                if (index == null) continue;
                Index it$iv$iv = index;
                boolean bl20 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv2;
            $this$getOrPut$iv2.put(table, answer$iv);
        }
        return new HashMap(this.existingIndicesCache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Table[] $this$associateWith$iv = tables;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        Table[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = $this$associateWithTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void table;
            Table element$iv$iv;
            Table table2 = element$iv$iv = $this$associateWithTo$iv$iv[i];
            Table table3 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            ResultSet rs = this.metadata.getPrimaryKeys(this.getDatabaseName(), this.getCurrentScheme(), table.nameInDatabaseCaseUnquoted());
            boolean bl2 = false;
            List columnNames = new ArrayList();
            String pkName = null;
            pkName = "";
            while (rs.next()) {
                String string;
                String string2 = string = rs.getString("PK_NAME");
                if (string2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(\"PK_NAME\")");
                    String it = string;
                    boolean bl3 = false;
                    pkName = it;
                }
                ((Collection)columnNames).add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            PrimaryKeyMetadata primaryKeyMetadata = ((CharSequence)pkName).length() == 0 ? null : new PrimaryKeyMetadata(pkName, columnNames);
            map.put(table3, primaryKeyMetadata);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public synchronized Map<String, List<ForeignKeyConstraint>> tableConstraints(@NotNull List<? extends Table> tables) {
        Map map;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv2;
            map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it.nameInDatabaseCase(), element$iv$iv2);
        }
        Map allTables = destination$iv$iv;
        Iterable $this$associateWith$iv = allTables.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list$iv$iv;
            List answer$iv$iv$iv;
            ForeignKeyConstraint it;
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv;
            void table;
            Object element$iv$iv2;
            element$iv$iv2 = (String)element$iv$iv;
            Object t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            ResultSet resultSet = this.metadata.getImportedKeys(this.getDatabaseName(), this.getCurrentScheme(), (String)table);
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"metadata.getImportedKeys\u2026me, currentScheme, table)");
            Iterable bl2 = CollectionsKt.filterNotNull((Iterable)JdbcDatabaseMetadataImplKt.access$iterate(resultSet, (Function1)new Function1<ResultSet, ForeignKeyConstraint>(this, (Map<String, ? extends Table>)allTables){
                final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
                final /* synthetic */ Map<String, Table> $allTables;
                {
                    this.this$0 = $receiver;
                    this.$allTables = $allTables;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ForeignKeyConstraint invoke(@NotNull ResultSet $this$iterate) {
                    Object object;
                    String constraintName;
                    Object fromColumn;
                    block11: {
                        block10: {
                            Object v11;
                            block7: {
                                void $this$firstOrNull$iv;
                                Object element$iv2;
                                Object object2;
                                block9: {
                                    block8: {
                                        Object v4;
                                        block6: {
                                            void $this$firstOrNull$iv2;
                                            Intrinsics.checkNotNullParameter((Object)$this$iterate, (String)"$this$iterate");
                                            String string = $this$iterate.getString("FKTABLE_NAME");
                                            Intrinsics.checkNotNull((Object)string);
                                            String fromTableName = string;
                                            IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                            String string2 = $this$iterate.getString("FKCOLUMN_NAME");
                                            Intrinsics.checkNotNull((Object)string2);
                                            String fromColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string2);
                                            object2 = this.$allTables.get(fromTableName);
                                            if (object2 == null || (object2 = object2.getColumns()) == null) break block8;
                                            Iterable iterable = (Iterable)object2;
                                            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                                            boolean $i$f$firstOrNull = false;
                                            for (Object element$iv2 : $this$firstOrNull$iv2) {
                                                Column it = (Column)element$iv2;
                                                boolean bl = false;
                                                if (!Intrinsics.areEqual((Object)jdbcDatabaseMetadataImpl.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.getName()), (Object)fromColumnName)) continue;
                                                v4 = element$iv2;
                                                break block6;
                                            }
                                            v4 = null;
                                        }
                                        if ((object2 = (Column)v4) != null) break block9;
                                    }
                                    return null;
                                }
                                fromColumn = object2;
                                String string = $this$iterate.getString("FK_NAME");
                                Intrinsics.checkNotNull((Object)string);
                                constraintName = string;
                                String string3 = $this$iterate.getString("PKTABLE_NAME");
                                Intrinsics.checkNotNull((Object)string3);
                                String targetTableName = string3;
                                IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                                IdentifierManagerApi identifierManagerApi2 = this.this$0.getIdentifierManager();
                                String string4 = $this$iterate.getString("PKCOLUMN_NAME");
                                Intrinsics.checkNotNull((Object)string4);
                                String targetColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(identifierManagerApi2.inProperCase(string4));
                                object = this.$allTables.get(targetTableName);
                                if (object == null || (object = object.getColumns()) == null) break block10;
                                element$iv2 = (Iterable)object;
                                JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                                boolean $i$f$firstOrNull = false;
                                for (T element$iv3 : $this$firstOrNull$iv) {
                                    Column it = (Column)element$iv3;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)jdbcDatabaseMetadataImpl.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase()), (Object)targetColumnName)) continue;
                                    v11 = element$iv3;
                                    break block7;
                                }
                                v11 = null;
                            }
                            if ((object = (Column)v11) != null) break block11;
                        }
                        return null;
                    }
                    Object targetColumn = object;
                    ReferenceOption constraintUpdateRule = ReferenceOption.Companion.resolveRefOptionFromJdbc($this$iterate.getInt("UPDATE_RULE"));
                    ReferenceOption constraintDeleteRule = ReferenceOption.Companion.resolveRefOptionFromJdbc($this$iterate.getInt("DELETE_RULE"));
                    return new ForeignKeyConstraint((Column)targetColumn, (Column)fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName);
                }
            }));
            boolean $i$f$groupBy = false;
            void var14_20 = $this$groupBy$iv;
            Object destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv3 : $this$groupByTo$iv$iv) {
                Object object;
                it = (ForeignKeyConstraint)element$iv$iv3;
                boolean bl3 = false;
                String key$iv$iv = it.getFkName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv3);
            }
            $this$groupBy$iv = destination$iv$iv2.values();
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (List)item$iv$iv;
                Object object = destination$iv$iv2;
                boolean bl5 = false;
                Iterable $this$reduce$iv = (Iterable)it;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    answer$iv$iv$iv = (ForeignKeyConstraint)iterator$iv.next();
                    ForeignKeyConstraint p0 = (ForeignKeyConstraint)accumulator$iv;
                    boolean bl6 = false;
                    accumulator$iv = p0.plus((ForeignKeyConstraint)p1);
                }
                object.add((ForeignKeyConstraint)accumulator$iv);
            }
            List list = (List)destination$iv$iv2;
            map.put(t, list);
        }
        return result$iv;
    }

    public synchronized void cleanCache() {
        this.existingIndicesCache.clear();
    }

    private final <T> Lazy<T> lazyMetadata(Function1<? super DatabaseMetaData, ? extends T> body) {
        return LazyKt.lazy((Function0)new Function0<T>(body, this){
            final /* synthetic */ Function1<DatabaseMetaData, T> $body;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$body = $body;
                this.this$0 = $receiver;
                super(0);
            }

            public final T invoke() {
                return (T)this.$body.invoke((Object)this.this$0.getMetadata());
            }
        });
    }

    public static final /* synthetic */ List access$tableNamesFor(JdbcDatabaseMetadataImpl $this, String scheme) {
        return $this.tableNamesFor(scheme);
    }

    public static final /* synthetic */ String access$sanitizedDefault(JdbcDatabaseMetadataImpl $this, String defaultValue) {
        return $this.sanitizedDefault(defaultValue);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIdentityManagerCache$cp() {
        return identityManagerCache;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault;", "K", "V", "", "map", "", "default", "Lkotlin/Function1;", "(Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getDefault", "()Lkotlin/jvm/functions/Function1;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "exposed-jdbc"})
    @SourceDebugExtension(value={"SMAP\nJdbcDatabaseMetadataImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,314:1\n372#2,7:315\n*S KotlinDebug\n*F\n+ 1 JdbcDatabaseMetadataImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault\n*L\n87#1:315,7\n*E\n"})
    private final class CachableMapWithDefault<K, V>
    implements Map<K, V>,
    KMappedMarker {
        @NotNull
        private final Map<K, V> map;
        @NotNull
        private final Function1<K, V> default;
        final /* synthetic */ JdbcDatabaseMetadataImpl this$0;

        public CachableMapWithDefault(@NotNull JdbcDatabaseMetadataImpl this$0, @NotNull Map<K, V> map, Function1<? super K, ? extends V> function1) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter(function1, (String)"default");
            this.this$0 = this$0;
            this.map = map;
            this.default = function1;
        }

        public /* synthetic */ CachableMapWithDefault(JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl, Map map, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(jdbcDatabaseMetadataImpl, map, function1);
        }

        @NotNull
        public final Function1<K, V> getDefault() {
            return this.default;
        }

        @NotNull
        public Set<Map.Entry<K, V>> getEntries() {
            return this.map.entrySet();
        }

        @NotNull
        public Set<K> getKeys() {
            return this.map.keySet();
        }

        public int getSize() {
            return this.map.size();
        }

        @NotNull
        public Collection<V> getValues() {
            return this.map.values();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        @Nullable
        public V get(Object key) {
            Object object;
            Map<Object, Object> $this$getOrPut$iv = this.map;
            boolean $i$f$getOrPut = false;
            V value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                Object answer$iv = this.default.invoke(key);
                $this$getOrPut$iv.put(key, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return object;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V compute(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfAbsent(K p0, Function<? super K, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfPresent(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V merge(K p0, V p1, BiFunction<? super V, ? super V, ? extends V> p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> from) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V putIfAbsent(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean replace(K p0, V p1, V p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V replace(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$Companion;", "", "()V", "identityManagerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

