/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc.statements;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.BatchInsertStatement;
import org.jetbrains.exposed.v1.core.statements.BatchUpdateStatement;
import org.jetbrains.exposed.v1.core.statements.BatchUpsertStatement;
import org.jetbrains.exposed.v1.core.statements.DeleteStatement;
import org.jetbrains.exposed.v1.core.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.v1.core.statements.InsertSelectStatement;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.statements.MergeStatement;
import org.jetbrains.exposed.v1.core.statements.ReturningStatement;
import org.jetbrains.exposed.v1.core.statements.SQLServerBatchInsertStatement;
import org.jetbrains.exposed.v1.core.statements.Statement;
import org.jetbrains.exposed.v1.core.statements.StatementContext;
import org.jetbrains.exposed.v1.core.statements.StatementInterceptor;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.core.statements.UpsertStatement;
import org.jetbrains.exposed.v1.core.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.v1.exceptions.ExposedSQLException;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.statements.BatchInsertBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.BatchUpdateBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.BatchUpsertBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.BlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.DeleteBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.InsertBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.InsertSelectBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.MergeBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.ReturningBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.SQLServerBatchInsertBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.UpdateBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.UpsertBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.api.JdbcPreparedStatementApi;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a5\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0004\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0005*\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001aJ\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0005*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"toExecutable", "Lorg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;", "T", "S", "", "Lorg/jetbrains/exposed/v1/core/statements/Statement;", "(Lorg/jetbrains/exposed/v1/core/statements/Statement;)Lorg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;", "executeIn", "Lkotlin/Pair;", "", "Lorg/jetbrains/exposed/v1/core/statements/StatementContext;", "transaction", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nBlockingExecutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockingExecutable.kt\norg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutableKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1563#2:168\n1634#2,2:169\n1869#2,2:171\n1869#2,2:173\n1636#2:175\n1869#2,2:176\n1869#2,2:178\n1878#2,3:180\n1869#2,2:183\n1869#2,2:185\n1869#2,2:187\n*S KotlinDebug\n*F\n+ 1 BlockingExecutable.kt\norg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutableKt\n*L\n124#1:168\n124#1:169,2\n126#1:171,2\n127#1:173,2\n124#1:175\n132#1:176,2\n133#1:178,2\n144#1:180,3\n154#1:183,2\n163#1:185,2\n164#1:187,2\n*E\n"})
public final class BlockingExecutableKt {
    @NotNull
    public static final <T, S extends Statement<? extends T>> BlockingExecutable<T, S> toExecutable(@NotNull S $this$toExecutable) {
        BlockingExecutable blockingExecutable;
        Intrinsics.checkNotNullParameter($this$toExecutable, (String)"<this>");
        S s = $this$toExecutable;
        if (s instanceof BatchUpsertStatement) {
            blockingExecutable = new BatchUpsertBlockingExecutable((BatchUpsertStatement)$this$toExecutable);
        } else if (s instanceof UpsertStatement) {
            blockingExecutable = new UpsertBlockingExecutable((UpsertStatement)$this$toExecutable);
        } else if (s instanceof SQLServerBatchInsertStatement) {
            blockingExecutable = new SQLServerBatchInsertBlockingExecutable((SQLServerBatchInsertStatement)$this$toExecutable);
        } else if (s instanceof BatchInsertStatement) {
            blockingExecutable = new BatchInsertBlockingExecutable<BatchInsertStatement>((BatchInsertStatement)$this$toExecutable);
        } else if (s instanceof InsertStatement) {
            blockingExecutable = new InsertBlockingExecutable((InsertStatement)$this$toExecutable);
        } else if (s instanceof BatchUpdateStatement) {
            blockingExecutable = new BatchUpdateBlockingExecutable((BatchUpdateStatement)$this$toExecutable);
        } else if (s instanceof UpdateStatement) {
            blockingExecutable = new UpdateBlockingExecutable((UpdateStatement)$this$toExecutable);
        } else if (s instanceof DeleteStatement) {
            blockingExecutable = new DeleteBlockingExecutable((DeleteStatement)$this$toExecutable);
        } else if (s instanceof InsertSelectStatement) {
            blockingExecutable = new InsertSelectBlockingExecutable((InsertSelectStatement)$this$toExecutable);
        } else if (s instanceof MergeStatement) {
            blockingExecutable = new MergeBlockingExecutable<MergeStatement>((MergeStatement)$this$toExecutable);
        } else if (s instanceof ReturningStatement) {
            blockingExecutable = new ReturningBlockingExecutable((ReturningStatement)$this$toExecutable);
        } else {
            throw new IllegalStateException(("An executable could not be associated with " + Reflection.getOrCreateKotlinClass($this$toExecutable.getClass()).getQualifiedName() + ". Pass this statement to a custom executable instance directly.").toString());
        }
        return blockingExecutable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, S extends Statement<? extends T>> Pair<T, List<StatementContext>> executeIn(@NotNull BlockingExecutable<? extends T, S> $this$executeIn, @NotNull JdbcTransaction transaction) {
        T $i$f$forEach4;
        Object $this$forEach$iv;
        GlobalStatementInterceptor it;
        List list;
        Intrinsics.checkNotNullParameter($this$executeIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Iterable arguments = $this$executeIn.getStatement().arguments();
        if (CollectionsKt.any((Iterable)arguments)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = arguments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                GlobalStatementInterceptor it2;
                void args;
                Iterable iterable2 = (Iterable)item$iv$iv;
                Iterator iterator2 = destination$iv$iv;
                boolean bl = false;
                StatementContext context = new StatementContext($this$executeIn.getStatement(), (Iterable)args);
                Iterable $this$forEach$iv2 = JdbcTransaction.Companion.getGlobalInterceptors();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it2 = (GlobalStatementInterceptor)element$iv;
                    boolean bl2 = false;
                    it2.beforeExecution((Transaction)transaction, context);
                }
                $this$forEach$iv2 = transaction.getInterceptors$exposed_jdbc();
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it2 = (StatementInterceptor)element$iv;
                    boolean bl3 = false;
                    it2.beforeExecution((Transaction)transaction, context);
                }
                iterator2.add((StatementContext)context);
            }
            list = (List)((Object)destination$iv$iv);
        } else {
            StatementContext context = new StatementContext($this$executeIn.getStatement(), (Iterable)CollectionsKt.emptyList());
            Iterable $this$forEach$iv3 = JdbcTransaction.Companion.getGlobalInterceptors();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (GlobalStatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution((Transaction)transaction, context);
            }
            $this$forEach$iv3 = transaction.getInterceptors$exposed_jdbc();
            $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                it = (StatementInterceptor)element$iv;
                boolean bl = false;
                it.beforeExecution((Transaction)transaction, context);
            }
            list = CollectionsKt.listOf((Object)context);
        }
        List contexts = list;
        try {
            $this$forEach$iv = $this$executeIn.prepared(transaction, Statement.prepareSQL$default($this$executeIn.getStatement(), (Transaction)transaction, (boolean)false, (int)2, null));
            JdbcPreparedStatementApi $this$executeIn_u24lambda_u245 = $this$forEach$iv;
            boolean bl = false;
            $this$executeIn_u24lambda_u245.setTimeout(transaction.getQueryTimeout());
        }
        catch (SQLException e) {
            throw new ExposedSQLException((Throwable)e, contexts, (Transaction)transaction);
        }
        JdbcPreparedStatementApi statement = $this$forEach$iv;
        Iterable $this$forEachIndexed$iv = contexts;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int bl;
            if ((bl = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StatementContext context = (StatementContext)item$iv;
            boolean bl4 = false;
            statement.fillParameters(context.getArgs());
            if (contexts.size() <= 1 && !$this$executeIn.isAlwaysBatch()) continue;
            statement.addBatch();
        }
        if (!transaction.getDb().getSupportsMultipleResultSets()) {
            transaction.closeExecutedStatements();
        }
        transaction.setCurrentStatement(statement);
        $this$forEach$iv = transaction.getInterceptors$exposed_jdbc();
        boolean $i$f$forEach4 = false;
        Iterator index$iv22 = $this$forEach$iv.iterator();
        while (index$iv22.hasNext()) {
            Iterator element$iv = index$iv22.next();
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterStatementPrepared((Transaction)transaction, (PreparedStatementApi)statement);
        }
        try {
            $i$f$forEach4 = $this$executeIn.executeInternal(statement, transaction);
        }
        catch (SQLException cause) {
            throw new ExposedSQLException((Throwable)cause, contexts, (Transaction)transaction);
        }
        T result = $i$f$forEach4;
        transaction.setCurrentStatement(null);
        transaction.getExecutedStatements$exposed_jdbc().add(statement);
        Iterable $this$forEach$iv4 = JdbcTransaction.Companion.getGlobalInterceptors();
        boolean $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv4) {
            GlobalStatementInterceptor it3 = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it3.afterExecution((Transaction)transaction, contexts, (PreparedStatementApi)statement);
        }
        $this$forEach$iv4 = transaction.getInterceptors$exposed_jdbc();
        $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv4) {
            StatementInterceptor it4 = (StatementInterceptor)element$iv;
            boolean bl = false;
            it4.afterExecution((Transaction)transaction, contexts, (PreparedStatementApi)statement);
        }
        return TuplesKt.to(result, (Object)contexts);
    }
}

