/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.json;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ComplexExpression;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B/\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/json/Contains;", "Lorg/jetbrains/exposed/sql/Op;", "", "Lorg/jetbrains/exposed/sql/ComplexExpression;", "target", "Lorg/jetbrains/exposed/sql/Expression;", "candidate", "path", "", "jsonType", "Lorg/jetbrains/exposed/sql/IColumnType;", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;Ljava/lang/String;Lorg/jetbrains/exposed/sql/IColumnType;)V", "getCandidate", "()Lorg/jetbrains/exposed/sql/Expression;", "getJsonType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "getPath", "()Ljava/lang/String;", "getTarget", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed-json"})
public final class Contains
extends Op<Boolean>
implements ComplexExpression {
    @NotNull
    private final Expression<?> target;
    @NotNull
    private final Expression<?> candidate;
    @Nullable
    private final String path;
    @NotNull
    private final IColumnType jsonType;

    public Contains(@NotNull Expression<?> target, @NotNull Expression<?> candidate, @Nullable String path, @NotNull IColumnType jsonType) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)jsonType, (String)"jsonType");
        this.target = target;
        this.candidate = candidate;
        this.path = path;
        this.jsonType = jsonType;
    }

    @NotNull
    public final Expression<?> getTarget() {
        return this.target;
    }

    @NotNull
    public final Expression<?> getCandidate() {
        return this.candidate;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final IColumnType getJsonType() {
        return this.jsonType;
    }

    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        DatabaseDialectKt.getCurrentDialect().getFunctionProvider().jsonContains(this.target, this.candidate, this.path, this.jsonType, queryBuilder);
    }
}

