/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.json;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/json/Extract;", "T", "Lorg/jetbrains/exposed/sql/Function;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "path", "", "", "toScalar", "", "jsonType", "Lorg/jetbrains/exposed/sql/IColumnType;", "columnType", "(Lorg/jetbrains/exposed/sql/Expression;[Ljava/lang/String;ZLorg/jetbrains/exposed/sql/IColumnType;Lorg/jetbrains/exposed/sql/IColumnType;)V", "getExpression", "()Lorg/jetbrains/exposed/sql/Expression;", "getJsonType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "getPath", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getToScalar", "()Z", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed-json"})
public final class Extract<T>
extends Function<T> {
    @NotNull
    private final Expression<?> expression;
    @NotNull
    private final String[] path;
    private final boolean toScalar;
    @NotNull
    private final IColumnType jsonType;

    public Extract(@NotNull Expression<?> expression, @NotNull String[] path, boolean toScalar, @NotNull IColumnType jsonType, @NotNull IColumnType columnType2) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)jsonType, (String)"jsonType");
        Intrinsics.checkNotNullParameter((Object)columnType2, (String)"columnType");
        super(columnType2);
        this.expression = expression;
        this.path = path;
        this.toScalar = toScalar;
        this.jsonType = jsonType;
    }

    @NotNull
    public final Expression<?> getExpression() {
        return this.expression;
    }

    @NotNull
    public final String[] getPath() {
        return this.path;
    }

    public final boolean getToScalar() {
        return this.toScalar;
    }

    @NotNull
    public final IColumnType getJsonType() {
        return this.jsonType;
    }

    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        String[] stringArray = this.path;
        DatabaseDialectKt.getCurrentDialect().getFunctionProvider().jsonExtract(this.expression, Arrays.copyOf(stringArray, stringArray.length), this.toScalar, this.jsonType, queryBuilder);
    }
}

