/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.json;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.json.JsonColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/sql/json/JsonBColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/json/JsonColumnType;", "serialize", "Lkotlin/Function1;", "", "deserialize", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "usesBinaryFormat", "", "getUsesBinaryFormat", "()Z", "sqlType", "exposed-json"})
public final class JsonBColumnType<T>
extends JsonColumnType<T> {
    private final boolean usesBinaryFormat;

    public JsonBColumnType(@NotNull Function1<? super T, String> serialize, @NotNull Function1<? super String, ? extends T> deserialize) {
        Intrinsics.checkNotNullParameter(serialize, (String)"serialize");
        Intrinsics.checkNotNullParameter(deserialize, (String)"deserialize");
        super(serialize, deserialize);
        this.usesBinaryFormat = true;
    }

    @Override
    public boolean getUsesBinaryFormat() {
        return this.usesBinaryFormat;
    }

    @Override
    @NotNull
    public String sqlType() {
        String string;
        if (DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect) {
            DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
            Intrinsics.checkNotNull((Object)databaseDialect, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.vendors.H2Dialect");
            string = ((H2Dialect)databaseDialect).getOriginalDataTypeProvider().jsonBType();
        } else {
            string = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().jsonBType();
        }
        return string;
    }
}

