/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.json;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.postgresql.util.PGobject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B-\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0012\u0010\u001c\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/json/JsonColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/JsonColumnMarker;", "serialize", "Lkotlin/Function1;", "", "deserialize", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getDeserialize", "()Lkotlin/jvm/functions/Function1;", "getSerialize", "usesBinaryFormat", "", "getUsesBinaryFormat", "()Z", "nonNullValueToString", "value", "notNullValueToDB", "setParameter", "", "stmt", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "index", "", "sqlType", "valueFromDB", "valueToString", "exposed-json"})
public class JsonColumnType<T>
extends ColumnType
implements JsonColumnMarker {
    @NotNull
    private final Function1<T, String> serialize;
    @NotNull
    private final Function1<String, T> deserialize;
    private final boolean usesBinaryFormat;

    public JsonColumnType(@NotNull Function1<? super T, String> serialize, @NotNull Function1<? super String, ? extends T> deserialize) {
        Intrinsics.checkNotNullParameter(serialize, (String)"serialize");
        Intrinsics.checkNotNullParameter(deserialize, (String)"deserialize");
        super(false, 1, null);
        this.serialize = serialize;
        this.deserialize = deserialize;
    }

    @NotNull
    public final Function1<T, String> getSerialize() {
        return this.serialize;
    }

    @NotNull
    public final Function1<String, T> getDeserialize() {
        return this.deserialize;
    }

    public boolean getUsesBinaryFormat() {
        return this.usesBinaryFormat;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().jsonType();
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect && value instanceof PGobject) {
            String string = ((PGobject)value).getValue();
            Intrinsics.checkNotNull((Object)string);
            object = this.deserialize.invoke((Object)string);
        } else {
            object = value instanceof String ? this.deserialize.invoke(value) : (value instanceof byte[] ? this.deserialize.invoke((Object)StringsKt.decodeToString((byte[])((byte[])value))) : value);
        }
        return object;
    }

    @NotNull
    public String notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (String)this.serialize.invoke(value);
    }

    @NotNull
    public String valueToString(@Nullable Object value) {
        return value instanceof Iterable ? this.nonNullValueToString(value) : super.valueToString(value);
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect ? "JSON '" + this.notNullValueToDB(value) + '\'' : super.nonNullValueToString(value);
    }

    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        if (databaseDialect instanceof PostgreSQLDialect) {
            PGobject pGobject;
            PGobject $this$setParameter_u24lambda_u240 = pGobject = new PGobject();
            boolean bl = false;
            $this$setParameter_u24lambda_u240.setType(this.sqlType());
            $this$setParameter_u24lambda_u240.setValue((String)value);
            object = pGobject;
        } else if (databaseDialect instanceof H2Dialect) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            object = StringsKt.encodeToByteArray((String)((String)value));
        } else {
            object = value;
        }
        Object parameterValue = object;
        super.setParameter(stmt, index, parameterValue);
    }
}

