/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.json;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.Function;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.QueryBuilder;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BN\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/v1/json/Extract;", "T", "Lorg/jetbrains/exposed/v1/core/Function;", "expression", "Lorg/jetbrains/exposed/v1/core/Expression;", "path", "", "", "toScalar", "", "jsonType", "Lorg/jetbrains/exposed/v1/core/IColumnType;", "columnType", "<init>", "(Lorg/jetbrains/exposed/v1/core/Expression;[Ljava/lang/String;ZLorg/jetbrains/exposed/v1/core/IColumnType;Lorg/jetbrains/exposed/v1/core/IColumnType;)V", "getExpression", "()Lorg/jetbrains/exposed/v1/core/Expression;", "getPath", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getToScalar", "()Z", "getJsonType", "()Lorg/jetbrains/exposed/v1/core/IColumnType;", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "exposed-json"})
public final class Extract<T>
extends Function<T> {
    @NotNull
    private final Expression<?> expression;
    @NotNull
    private final String[] path;
    private final boolean toScalar;
    @NotNull
    private final IColumnType<?> jsonType;

    public Extract(@NotNull Expression<?> expression, @NotNull String[] path, boolean toScalar, @NotNull IColumnType<?> jsonType, @NotNull IColumnType<T> columnType2) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(jsonType, (String)"jsonType");
        Intrinsics.checkNotNullParameter(columnType2, (String)"columnType");
        super(columnType2);
        this.expression = expression;
        this.path = path;
        this.toScalar = toScalar;
        this.jsonType = jsonType;
    }

    @NotNull
    public final Expression<?> getExpression() {
        return this.expression;
    }

    @NotNull
    public final String[] getPath() {
        return this.path;
    }

    public final boolean getToScalar() {
        return this.toScalar;
    }

    @NotNull
    public final IColumnType<?> getJsonType() {
        return this.jsonType;
    }

    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        String[] stringArray = this.path;
        DatabaseDialectKt.getCurrentDialect().getFunctionProvider().jsonExtract(this.expression, Arrays.copyOf(stringArray, stringArray.length), this.toScalar, this.jsonType, queryBuilder);
    }
}

