/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.json;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.JsonColumnMarker;
import org.jetbrains.exposed.v1.core.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.postgresql.util.PGobject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B/\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u0015\u0010!\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/v1/json/JsonColumnType;", "T", "", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Lorg/jetbrains/exposed/v1/core/JsonColumnMarker;", "serialize", "Lkotlin/Function1;", "", "deserialize", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getSerialize", "()Lkotlin/jvm/functions/Function1;", "getDeserialize", "usesBinaryFormat", "", "getUsesBinaryFormat", "()Z", "sqlType", "valueFromDB", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "parameterMarker", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "valueToString", "nonNullValueToString", "setParameter", "", "stmt", "Lorg/jetbrains/exposed/v1/core/statements/api/PreparedStatementApi;", "index", "", "nonNullValueAsDefaultString", "exposed-json"})
public class JsonColumnType<T>
extends ColumnType<T>
implements JsonColumnMarker {
    @NotNull
    private final Function1<T, String> serialize;
    @NotNull
    private final Function1<String, T> deserialize;
    private final boolean usesBinaryFormat;

    public JsonColumnType(@NotNull Function1<? super T, String> serialize, @NotNull Function1<? super String, ? extends T> deserialize) {
        Intrinsics.checkNotNullParameter(serialize, (String)"serialize");
        Intrinsics.checkNotNullParameter(deserialize, (String)"deserialize");
        super(false, 1, null);
        this.serialize = serialize;
        this.deserialize = deserialize;
    }

    @NotNull
    public final Function1<T, String> getSerialize() {
        return this.serialize;
    }

    @NotNull
    public final Function1<String, T> getDeserialize() {
        return this.deserialize;
    }

    public boolean getUsesBinaryFormat() {
        return this.usesBinaryFormat;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().jsonType();
    }

    @NotNull
    public T valueFromDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect && value instanceof PGobject) {
            String string = ((PGobject)value).getValue();
            Intrinsics.checkNotNull((Object)string);
            object = this.deserialize.invoke((Object)string);
        } else if (value instanceof String) {
            object = this.deserialize.invoke(value);
        } else if (value instanceof byte[]) {
            object = this.deserialize.invoke((Object)StringsKt.decodeToString((byte[])((byte[])value)));
        } else {
            object = value;
            if (object == null) {
                throw new IllegalStateException(("Unexpected value " + value + " of type " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
            }
        }
        return (T)object;
    }

    @NotNull
    public String parameterMarker(@Nullable T value) {
        return DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect && value != null ? "? FORMAT JSON" : super.parameterMarker(value);
    }

    @NotNull
    public Object notNullValueToDB(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.serialize.invoke(value);
    }

    @NotNull
    public String valueToString(@Nullable T value) {
        return value instanceof Iterable ? this.nonNullValueToString(value) : super.valueToString(value);
    }

    @NotNull
    public String nonNullValueToString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect ? "JSON '" + this.notNullValueToDB(value) + '\'' : super.nonNullValueToString(value);
    }

    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        if (databaseDialect instanceof PostgreSQLDialect) {
            Object object2 = value;
            if (object2 != null) {
                PGobject pGobject;
                Object it = object2;
                boolean bl = false;
                PGobject $this$setParameter_u24lambda_u241_u24lambda_u240 = pGobject = new PGobject();
                boolean bl2 = false;
                $this$setParameter_u24lambda_u241_u24lambda_u240.setType(this.sqlType());
                $this$setParameter_u24lambda_u241_u24lambda_u240.setValue(value instanceof String ? (String)value : null);
                object = pGobject;
            } else {
                object = null;
            }
        } else if (databaseDialect instanceof H2Dialect) {
            String string = value instanceof String ? (String)value : null;
            object = string != null ? (Object)StringsKt.encodeToByteArray((String)string) : null;
        } else {
            object = value;
        }
        Object parameterValue = object;
        super.setParameter(stmt, index, parameterValue);
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect ? "JSON '" + this.notNullValueToDB(value) + '\'' : "" + '\'' + this.notNullValueToDB(value) + '\'';
    }
}

