/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDurationColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinInstantColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinLocalDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinLocalDateTimeColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinLocalTimeColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinOffsetDateTimeColumnType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000207H\u0002\u001a\u0010\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\u0001H\u0002\u001a\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002\u001a\u0010\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020?H\u0002\u001a\u0010\u0010@\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002\u001a\u0018\u00106\u001a\b\u0012\u0004\u0012\u00020C0F*\u00020G2\u0006\u0010H\u001a\u000207\u001a\u0018\u0010I\u001a\b\u0012\u0004\u0012\u00020J0F*\u00020G2\u0006\u0010H\u001a\u000207\u001a\u0018\u0010K\u001a\b\u0012\u0004\u0012\u00020L0F*\u00020G2\u0006\u0010H\u001a\u000207\u001a\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020<0F*\u00020G2\u0006\u0010H\u001a\u000207\u001a\u0018\u0010N\u001a\b\u0012\u0004\u0012\u00020?0F*\u00020G2\u0006\u0010H\u001a\u000207\u001a\u0018\u0010O\u001a\b\u0012\u0004\u0012\u00020P0F*\u00020G2\u0006\u0010H\u001a\u000207\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\"#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u0007\u001a\u0004\b\u000b\u0010\f\"#\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0007\u001a\u0004\b\u000f\u0010\f\"#\u0010\u0011\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0007\u001a\u0004\b\u0012\u0010\f\"#\u0010\u0014\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0007\u001a\u0004\b\u0015\u0010\f\"#\u0010\u0017\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0007\u001a\u0004\b\u0018\u0010\f\"#\u0010\u001a\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0007\u001a\u0004\b\u001b\u0010\f\"#\u0010\u001d\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0007\u001a\u0004\b\u001e\u0010\f\"#\u0010 \u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0007\u001a\u0004\b!\u0010\f\"#\u0010#\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0007\u001a\u0004\b$\u0010\f\"#\u0010&\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0007\u001a\u0004\b'\u0010\f\"#\u0010)\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0007\u001a\u0004\b*\u0010\f\"#\u0010,\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0007\u001a\u0004\b-\u0010\f\"#\u0010/\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u0007\u001a\u0004\b0\u0010\f\"#\u00102\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0007\u001a\u0004\b3\u0010\f\"\u0018\u0010A\u001a\u00020B*\u00020C8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006Q"}, d2={"MILLIS_IN_SECOND", "", "DEFAULT_TIME_ZONE", "Lkotlinx/datetime/TimeZone;", "getDEFAULT_TIME_ZONE", "()Lkotlinx/datetime/TimeZone;", "DEFAULT_TIME_ZONE$delegate", "Lkotlin/Lazy;", "DEFAULT_DATE_STRING_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDEFAULT_DATE_STRING_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "DEFAULT_DATE_STRING_FORMATTER$delegate", "DEFAULT_DATE_TIME_STRING_FORMATTER", "getDEFAULT_DATE_TIME_STRING_FORMATTER", "DEFAULT_DATE_TIME_STRING_FORMATTER$delegate", "SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER", "getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER", "SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate", "MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER", "getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER", "MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER$delegate", "MYSQL_DATE_TIME_STRING_FORMATTER", "getMYSQL_DATE_TIME_STRING_FORMATTER", "MYSQL_DATE_TIME_STRING_FORMATTER$delegate", "ORACLE_TIME_STRING_FORMATTER", "getORACLE_TIME_STRING_FORMATTER", "ORACLE_TIME_STRING_FORMATTER$delegate", "DEFAULT_TIME_STRING_FORMATTER", "getDEFAULT_TIME_STRING_FORMATTER", "DEFAULT_TIME_STRING_FORMATTER$delegate", "SQLITE_OFFSET_DATE_TIME_FORMATTER", "getSQLITE_OFFSET_DATE_TIME_FORMATTER", "SQLITE_OFFSET_DATE_TIME_FORMATTER$delegate", "MYSQL_OFFSET_DATE_TIME_FORMATTER", "getMYSQL_OFFSET_DATE_TIME_FORMATTER", "MYSQL_OFFSET_DATE_TIME_FORMATTER$delegate", "ORACLE_OFFSET_DATE_TIME_FORMATTER", "getORACLE_OFFSET_DATE_TIME_FORMATTER", "ORACLE_OFFSET_DATE_TIME_FORMATTER$delegate", "DEFAULT_OFFSET_DATE_TIME_FORMATTER", "getDEFAULT_OFFSET_DATE_TIME_FORMATTER", "DEFAULT_OFFSET_DATE_TIME_FORMATTER$delegate", "MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER", "getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER", "MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER$delegate", "POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate", "MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER", "MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate", "formatterForDateString", "date", "", "dateTimeWithFractionFormat", "fraction", "oracleDateTimeLiteral", "instant", "Lkotlinx/datetime/Instant;", "oracleDateTimeWithTimezoneLiteral", "dateTime", "Ljava/time/OffsetDateTime;", "oracleDateLiteral", "millis", "", "Lkotlinx/datetime/LocalDate;", "getMillis", "(Lkotlinx/datetime/LocalDate;)J", "Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/Table;", "name", "datetime", "Lkotlinx/datetime/LocalDateTime;", "time", "Lkotlinx/datetime/LocalTime;", "timestamp", "timestampWithTimeZone", "duration", "Lkotlin/time/Duration;", "exposed-kotlin-datetime"})
public final class KotlinDateColumnTypeKt {
    private static final int MILLIS_IN_SECOND = 1000;
    @NotNull
    private static final Lazy DEFAULT_TIME_ZONE$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::DEFAULT_TIME_ZONE_delegate$lambda$0);
    @NotNull
    private static final Lazy DEFAULT_DATE_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::DEFAULT_DATE_STRING_FORMATTER_delegate$lambda$1);
    @NotNull
    private static final Lazy DEFAULT_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::DEFAULT_DATE_TIME_STRING_FORMATTER_delegate$lambda$2);
    @NotNull
    private static final Lazy SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER_delegate$lambda$3);
    @NotNull
    private static final Lazy MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER_delegate$lambda$4);
    @NotNull
    private static final Lazy MYSQL_DATE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::MYSQL_DATE_TIME_STRING_FORMATTER_delegate$lambda$5);
    @NotNull
    private static final Lazy ORACLE_TIME_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::ORACLE_TIME_STRING_FORMATTER_delegate$lambda$6);
    @NotNull
    private static final Lazy DEFAULT_TIME_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::DEFAULT_TIME_STRING_FORMATTER_delegate$lambda$7);
    @NotNull
    private static final Lazy SQLITE_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::SQLITE_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$8);
    @NotNull
    private static final Lazy MYSQL_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::MYSQL_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$9);
    @NotNull
    private static final Lazy ORACLE_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::ORACLE_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$10);
    @NotNull
    private static final Lazy DEFAULT_OFFSET_DATE_TIME_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::DEFAULT_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$11);
    @NotNull
    private static final Lazy MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER_delegate$lambda$12);
    @NotNull
    private static final Lazy POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER_delegate$lambda$13);
    @NotNull
    private static final Lazy MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate = LazyKt.lazy(KotlinDateColumnTypeKt::MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER_delegate$lambda$14);

    private static final TimeZone getDEFAULT_TIME_ZONE() {
        Lazy lazy = DEFAULT_TIME_ZONE$delegate;
        return (TimeZone)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_DATE_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_DATE_TIME_STRING_FORMATTER() {
        Lazy lazy = MYSQL_DATE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getORACLE_TIME_STRING_FORMATTER() {
        Lazy lazy = ORACLE_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_TIME_STRING_FORMATTER() {
        Lazy lazy = DEFAULT_TIME_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getSQLITE_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = SQLITE_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = MYSQL_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getORACLE_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = ORACLE_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getDEFAULT_OFFSET_DATE_TIME_FORMATTER() {
        Lazy lazy = DEFAULT_OFFSET_DATE_TIME_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER() {
        Lazy lazy = MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        Lazy lazy = POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        Lazy lazy = MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter formatterForDateString(String date) {
        return KotlinDateColumnTypeKt.dateTimeWithFractionFormat(StringsKt.substringAfterLast((String)date, (char)'.', (String)"").length());
    }

    private static final DateTimeFormatter dateTimeWithFractionFormat(int fraction) {
        String string;
        String baseFormat = "yyyy-MM-dd HH:mm:ss";
        boolean bl = 1 <= fraction ? fraction < 10 : false;
        if (bl) {
            IntRange intRange = new IntRange(1, fraction);
            String string2 = baseFormat + '.';
            string = CollectionsKt.joinToString$default((Iterable)((Iterable)intRange), (CharSequence)"", (CharSequence)string2, null, (int)0, null, KotlinDateColumnTypeKt::dateTimeWithFractionFormat$lambda$15, (int)28, null);
        } else {
            string = baseFormat;
        }
        String newFormat = string;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(newFormat).withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        return dateTimeFormatter;
    }

    private static final String oracleDateTimeLiteral(Instant instant) {
        return "TO_TIMESTAMP('" + KotlinDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((Instant)instant)) + "', 'YYYY-MM-DD HH24:MI:SS.FF3')";
    }

    private static final String oracleDateTimeWithTimezoneLiteral(OffsetDateTime dateTime) {
        return "TO_TIMESTAMP_TZ('" + dateTime.format(KotlinDateColumnTypeKt.getORACLE_OFFSET_DATE_TIME_FORMATTER()) + "', 'YYYY-MM-DD HH24:MI:SS.FF6 TZH:TZM')";
    }

    private static final String oracleDateLiteral(Instant instant) {
        return "TO_DATE('" + KotlinDateColumnTypeKt.getDEFAULT_DATE_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((Instant)instant)) + "', 'YYYY-MM-DD')";
    }

    private static final long getMillis(LocalDate $this$millis) {
        return TimeZoneKt.atStartOfDayIn((LocalDate)$this$millis, (TimeZone)TimeZone.Companion.currentSystemDefault()).getEpochSeconds() * (long)1000;
    }

    @NotNull
    public static final Column<LocalDate> date(@NotNull Table $this$date, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$date, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$date.registerColumn(name, (IColumnType)new KotlinLocalDateColumnType());
    }

    @NotNull
    public static final Column<LocalDateTime> datetime(@NotNull Table $this$datetime, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$datetime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$datetime.registerColumn(name, (IColumnType)new KotlinLocalDateTimeColumnType());
    }

    @NotNull
    public static final Column<LocalTime> time(@NotNull Table $this$time, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$time, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$time.registerColumn(name, (IColumnType)new KotlinLocalTimeColumnType());
    }

    @NotNull
    public static final Column<Instant> timestamp(@NotNull Table $this$timestamp, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$timestamp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$timestamp.registerColumn(name, (IColumnType)new KotlinInstantColumnType());
    }

    @NotNull
    public static final Column<OffsetDateTime> timestampWithTimeZone(@NotNull Table $this$timestampWithTimeZone, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$timestampWithTimeZone, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$timestampWithTimeZone.registerColumn(name, (IColumnType)new KotlinOffsetDateTimeColumnType());
    }

    @NotNull
    public static final Column<Duration> duration(@NotNull Table $this$duration, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$duration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$duration.registerColumn(name, (IColumnType)new KotlinDurationColumnType());
    }

    private static final TimeZone DEFAULT_TIME_ZONE_delegate$lambda$0() {
        return TimeZone.Companion.currentSystemDefault();
    }

    private static final DateTimeFormatter DEFAULT_DATE_STRING_FORMATTER_delegate$lambda$1() {
        return DateTimeFormatter.ISO_LOCAL_DATE.withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
    }

    private static final DateTimeFormatter DEFAULT_DATE_TIME_STRING_FORMATTER_delegate$lambda$2() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
    }

    private static final DateTimeFormatter SQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER_delegate$lambda$3() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT).withZone(ZoneId.systemDefault());
    }

    private static final DateTimeFormatter MYSQL_FRACTION_DATE_TIME_STRING_FORMATTER_delegate$lambda$4() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS", Locale.ROOT).withZone(ZoneId.systemDefault());
    }

    private static final DateTimeFormatter MYSQL_DATE_TIME_STRING_FORMATTER_delegate$lambda$5() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT).withZone(ZoneId.systemDefault());
    }

    private static final DateTimeFormatter ORACLE_TIME_STRING_FORMATTER_delegate$lambda$6() {
        return DateTimeFormatter.ofPattern("1970-01-01 HH:mm:ss", Locale.ROOT).withZone(ZoneId.of("UTC"));
    }

    private static final DateTimeFormatter DEFAULT_TIME_STRING_FORMATTER_delegate$lambda$7() {
        return DateTimeFormatter.ISO_LOCAL_TIME.withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
    }

    private static final DateTimeFormatter SQLITE_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$8() {
        return new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".SSS").optionalEnd().optionalStart().appendPattern("XXX").optionalEnd().toFormatter().withLocale(Locale.ROOT);
    }

    private static final DateTimeFormatter MYSQL_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$9() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS[xxx]", Locale.ROOT);
    }

    private static final DateTimeFormatter ORACLE_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$10() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS [xxx]", Locale.ROOT);
    }

    private static final DateTimeFormatter DEFAULT_OFFSET_DATE_TIME_FORMATTER_delegate$lambda$11() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(Locale.ROOT);
    }

    private static final DateTimeFormatter MYSQL_TIME_AS_DEFAULT_STRING_FORMATTER_delegate$lambda$12() {
        return DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT).withZone(ZoneId.systemDefault());
    }

    private static final DateTimeFormatter POSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER_delegate$lambda$13() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter(Locale.ROOT);
    }

    private static final DateTimeFormatter MYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER_delegate$lambda$14() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS", Locale.ROOT).withZone(ZoneId.of("UTC"));
    }

    private static final CharSequence dateTimeWithFractionFormat$lambda$15(int it) {
        return "S";
    }

    public static final /* synthetic */ TimeZone access$getDEFAULT_TIME_ZONE() {
        return KotlinDateColumnTypeKt.getDEFAULT_TIME_ZONE();
    }

    public static final /* synthetic */ String access$oracleDateLiteral(Instant instant) {
        return KotlinDateColumnTypeKt.oracleDateLiteral(instant);
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_DATE_STRING_FORMATTER();
    }

    public static final /* synthetic */ long access$getMillis(LocalDate $receiver) {
        return KotlinDateColumnTypeKt.getMillis($receiver);
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ String access$oracleDateTimeLiteral(Instant instant) {
        return KotlinDateColumnTypeKt.oracleDateTimeLiteral(instant);
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_DATE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_DATE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$formatterForDateString(String date) {
        return KotlinDateColumnTypeKt.formatterForDateString(date);
    }

    public static final /* synthetic */ DateTimeFormatter access$getORACLE_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getORACLE_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_TIME_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_TIME_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getSQLITE_OFFSET_DATE_TIME_FORMATTER() {
        return KotlinDateColumnTypeKt.getSQLITE_OFFSET_DATE_TIME_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_OFFSET_DATE_TIME_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_OFFSET_DATE_TIME_FORMATTER();
    }

    public static final /* synthetic */ String access$oracleDateTimeWithTimezoneLiteral(OffsetDateTime dateTime) {
        return KotlinDateColumnTypeKt.oracleDateTimeWithTimezoneLiteral(dateTime);
    }

    public static final /* synthetic */ DateTimeFormatter access$getDEFAULT_OFFSET_DATE_TIME_FORMATTER() {
        return KotlinDateColumnTypeKt.getDEFAULT_OFFSET_DATE_TIME_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        return KotlinDateColumnTypeKt.getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER();
    }

    public static final /* synthetic */ DateTimeFormatter access$getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER() {
        return KotlinDateColumnTypeKt.getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER();
    }
}

