/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lkotlinx/datetime/LocalDateTime;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "nonNullValueAsDefaultString", "longToLocalDateTime", "millis", "", "seconds", "nanos", "Companion", "exposed-kotlin-datetime"})
@SourceDebugExtension(value={"SMAP\nKotlinDateColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDateColumnType.kt\norg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
public final class KotlinLocalDateTimeColumnType
extends ColumnType<kotlinx.datetime.LocalDateTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinLocalDateTimeColumnType INSTANCE = new KotlinLocalDateTimeColumnType();

    public KotlinLocalDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull kotlinx.datetime.LocalDateTime value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        kotlinx.datetime.Instant instant = TimeZoneKt.toInstant((kotlinx.datetime.LocalDateTime)value, (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE());
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof SQLiteDialect) {
            string = '\'' + KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)instant)) + '\'';
        } else if (dialect instanceof OracleDialect) {
            string = KotlinDateColumnTypeKt.access$oracleDateTimeLiteral(instant);
        } else if (dialect instanceof MysqlDialect) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? KotlinDateColumnTypeKt.access$getMYSQL_FRACTION_DATE_TIME_STRING_FORMATTER() : KotlinDateColumnTypeKt.access$getMYSQL_DATE_TIME_STRING_FORMATTER();
            string = '\'' + formatter.format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)instant)) + '\'';
        } else {
            string = '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)instant)) + '\'';
        }
        return string;
    }

    @NotNull
    public kotlinx.datetime.LocalDateTime valueFromDB(@NotNull Object value) {
        kotlinx.datetime.LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof kotlinx.datetime.LocalDateTime) {
            localDateTime = (kotlinx.datetime.LocalDateTime)value;
        } else if (object instanceof Date) {
            localDateTime = this.longToLocalDateTime(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            localDateTime = this.longToLocalDateTime(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
        } else if (object instanceof Integer) {
            localDateTime = this.longToLocalDateTime(((Number)value).intValue());
        } else if (object instanceof Long) {
            localDateTime = this.longToLocalDateTime(((Number)value).longValue());
        } else if (object instanceof LocalDateTime) {
            localDateTime = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)((LocalDateTime)value));
        } else if (object instanceof String) {
            LocalDateTime localDateTime2 = LocalDateTime.parse((CharSequence)value, KotlinDateColumnTypeKt.access$formatterForDateString((String)value));
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"parse(...)");
            localDateTime = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime2);
        } else if (object instanceof OffsetDateTime) {
            LocalDateTime localDateTime3 = ((OffsetDateTime)value).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"toLocalDateTime(...)");
            localDateTime = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime3);
        } else {
            localDateTime = this.valueFromDB(value.toString());
        }
        return localDateTime;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull kotlinx.datetime.LocalDateTime value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect) {
            object = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)value).atZone(ZoneId.systemDefault()));
        } else {
            Timestamp timestamp;
            Instant instant = ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant();
            Timestamp $this$notNullValueToDB_u24lambda_u240 = timestamp = new Timestamp(instant.toEpochMilli());
            boolean bl = false;
            $this$notNullValueToDB_u24lambda_u240.setNanos(instant.getNano());
            object = timestamp;
        }
        return object;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? rs.getObject(index, Timestamp.class) : super.readObject(rs, index);
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull kotlinx.datetime.LocalDateTime value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Instant instant = ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)TimeZoneKt.toInstant((kotlinx.datetime.LocalDateTime)value, (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE()));
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof PostgreSQLDialect) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string2 = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd((String)string2, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string3, (char[])cArray)).append("'::timestamp without time zone").toString();
        } else if (H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string4 = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            char[] cArray = new char[]{'0'};
            String string5 = StringsKt.trimEnd((String)string4, (char[])cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd((String)string5, (char[])cArray)).append('\'').toString();
        } else {
            string = super.nonNullValueAsDefaultString((Object)value);
        }
        return string;
    }

    private final kotlinx.datetime.LocalDateTime longToLocalDateTime(long millis) {
        return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(millis), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE());
    }

    private final kotlinx.datetime.LocalDateTime longToLocalDateTime(long seconds, long nanos) {
        return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochSeconds(seconds, nanos), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinLocalDateTimeColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

