/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lkotlinx/datetime/LocalTime;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "notNullValueToDB", "nonNullValueAsDefaultString", "longToLocalTime", "millis", "", "Companion", "exposed-kotlin-datetime"})
public final class KotlinLocalTimeColumnType
extends ColumnType<kotlinx.datetime.LocalTime>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinLocalTimeColumnType INSTANCE = new KotlinLocalTimeColumnType();

    public KotlinLocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull kotlinx.datetime.LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        LocalTime instant = ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)value);
        if (dialect instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            return "TIMESTAMP '" + KotlinDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(instant) + '\'';
        }
        return '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(instant) + '\'';
    }

    @NotNull
    public kotlinx.datetime.LocalTime valueFromDB(@NotNull Object value) {
        kotlinx.datetime.LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof kotlinx.datetime.LocalTime) {
            localTime = (kotlinx.datetime.LocalTime)value;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value).toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"toLocalTime(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime2);
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value).toLocalDateTime().toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"toLocalTime(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime3);
        } else if (object instanceof Integer) {
            localTime = this.longToLocalTime(((Number)value).intValue());
        } else if (object instanceof Long) {
            localTime = this.longToLocalTime(((Number)value).longValue());
        } else if (object instanceof String) {
            DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
            DateTimeFormatter formatter = dialect instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle ? KotlinDateColumnTypeKt.access$formatterForDateString((String)value) : KotlinDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER();
            LocalTime localTime4 = LocalTime.parse((CharSequence)value, formatter);
            Intrinsics.checkNotNullExpressionValue((Object)localTime4, (String)"parse(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime4);
        } else {
            localTime = this.valueFromDB(value.toString());
        }
        return localTime;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull kotlinx.datetime.LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? KotlinDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)value)) : (H2Kt.getH2Mode((DatabaseDialect)DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? KotlinDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)value)) : Time.valueOf(ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)value)));
    }

    @NotNull
    public String nonNullValueAsDefaultString(@NotNull kotlinx.datetime.LocalTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::time without time zone" : (databaseDialect instanceof MysqlDialect ? '\'' + KotlinDateColumnTypeKt.access$getMYSQL_TIME_AS_DEFAULT_STRING_FORMATTER().format(ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)value)) + '\'' : super.nonNullValueAsDefaultString((Object)value));
    }

    private final kotlinx.datetime.LocalTime longToLocalTime(long millis) {
        return TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(millis), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE()).getTime();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinLocalTimeColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

