/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.spring.autoconfigure;

import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.spring.DatabaseInitializer;
import org.jetbrains.exposed.spring.SpringTransactionManager;
import org.jetbrains.exposed.spring.autoconfigure.ExposedAutoConfiguration;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@EnableTransactionManagement
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/spring/autoconfigure/ExposedAutoConfiguration;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "excludedPackages", "", "", "showSql", "", "databaseConfig", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "databaseInitializer", "Lorg/jetbrains/exposed/spring/DatabaseInitializer;", "springTransactionManager", "Lorg/jetbrains/exposed/spring/SpringTransactionManager;", "datasource", "Ljavax/sql/DataSource;", "exposed-spring-boot-starter"})
public class ExposedAutoConfiguration {
    @NotNull
    private final ApplicationContext applicationContext;
    @Value(value="${spring.exposed.excluded-packages:}#{T(java.util.Collections).emptyList()}")
    private List<String> excludedPackages;
    @Value(value="${spring.exposed.show-sql:false}")
    private boolean showSql;

    public ExposedAutoConfiguration(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }

    @Bean
    @NotNull
    public SpringTransactionManager springTransactionManager(@NotNull DataSource datasource, @NotNull DatabaseConfig databaseConfig2) {
        Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
        Intrinsics.checkNotNullParameter((Object)databaseConfig2, (String)"databaseConfig");
        return new SpringTransactionManager(datasource, databaseConfig2, this.showSql);
    }

    @Bean
    @ConditionalOnMissingBean(value={DatabaseConfig.class})
    @NotNull
    public DatabaseConfig databaseConfig() {
        return DatabaseConfig.Companion.invoke((Function1)databaseConfig.1.INSTANCE);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.exposed.generate-ddl"}, havingValue="true", matchIfMissing=false)
    @NotNull
    public DatabaseInitializer databaseInitializer() {
        List<String> list = this.excludedPackages;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludedPackages");
            list = null;
        }
        return new DatabaseInitializer(this.applicationContext, list);
    }
}

