/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.spring;

import java.sql.Connection;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.StdOutSqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcConnectionImpl;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001+B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0012\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0018H\u0014J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0014J\b\u0010'\u001a\u00020\u001cH\u0002J\u001a\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\b2\b\u0010*\u001a\u0004\u0018\u00010\u001cH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\b8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/exposed/spring/SpringTransactionManager;", "Lorg/springframework/jdbc/datasource/DataSourceTransactionManager;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "_dataSource", "Ljavax/sql/DataSource;", "showSql", "", "defaultRepetitionAttempts", "", "(Ljavax/sql/DataSource;ZI)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "defaultIsolationLevel", "getDefaultIsolationLevel", "()I", "setDefaultIsolationLevel", "(I)V", "getDefaultRepetitionAttempts", "setDefaultRepetitionAttempts", "springTxKey", "", "bindResourceForSure", "", "key", "", "value", "bindTransactionToThread", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "currentOrNull", "doBegin", "definition", "Lorg/springframework/transaction/TransactionDefinition;", "doCleanupAfterCompletion", "doCommit", "status", "Lorg/springframework/transaction/support/DefaultTransactionStatus;", "doRollback", "doSuspend", "initTransaction", "newTransaction", "isolation", "outerTransaction", "SpringTransaction", "spring-transaction"})
public final class SpringTransactionManager
extends DataSourceTransactionManager
implements TransactionManager {
    private final boolean showSql;
    private volatile int defaultRepetitionAttempts;
    @NotNull
    private final Database db;
    private volatile int defaultIsolationLevel;
    @NotNull
    private final String springTxKey;

    public SpringTransactionManager(@NotNull DataSource _dataSource, boolean showSql, int defaultRepetitionAttempts) {
        Intrinsics.checkNotNullParameter((Object)_dataSource, (String)"_dataSource");
        super(_dataSource);
        this.showSql = showSql;
        this.defaultRepetitionAttempts = defaultRepetitionAttempts;
        this.setRollbackOnCommitFailure(true);
        this.db = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)_dataSource, null, null, (Function1)((Function1)new Function1<Database, TransactionManager>(this){
            final /* synthetic */ SpringTransactionManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final TransactionManager invoke(@NotNull Database it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0;
            }
        }), (int)6, null);
        this.defaultIsolationLevel = -1;
        this.springTxKey = "SPRING_TX_KEY";
    }

    public /* synthetic */ SpringTransactionManager(DataSource dataSource, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 3;
        }
        this(dataSource, bl, n);
    }

    public int getDefaultRepetitionAttempts() {
        return this.defaultRepetitionAttempts;
    }

    public void setDefaultRepetitionAttempts(int n) {
        this.defaultRepetitionAttempts = n;
    }

    public int getDefaultIsolationLevel() {
        if (this.defaultIsolationLevel == -1) {
            this.defaultIsolationLevel = Database.Companion.getDefaultIsolationLevel(this.db);
        }
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    protected void doBegin(@NotNull Object transaction, @NotNull TransactionDefinition definition) {
        Transaction transaction2;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        super.doBegin(transaction, definition);
        if (TransactionSynchronizationManager.hasResource((Object)this.obtainDataSource()) && (transaction2 = this.currentOrNull()) == null) {
            transaction2 = this.initTransaction();
        }
        if (!TransactionSynchronizationManager.hasResource((Object)this.springTxKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.springTxKey, (Object)transaction);
        }
    }

    protected void doCleanupAfterCompletion(@NotNull Object transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        super.doCleanupAfterCompletion(transaction);
        if (!TransactionSynchronizationManager.hasResource((Object)this.obtainDataSource())) {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this));
            TransactionSynchronizationManager.unbindResource((Object)this.springTxKey);
        }
        if (TransactionSynchronizationManager.isSynchronizationActive() && TransactionSynchronizationManager.getSynchronizations().isEmpty()) {
            TransactionSynchronizationManager.clearSynchronization();
        }
        TransactionManager.Companion.resetCurrent(null);
    }

    @NotNull
    protected Object doSuspend(@NotNull Object transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this));
        Object object = super.doSuspend(transaction);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"super.doSuspend(transaction)");
        return object;
    }

    protected void doCommit(@NotNull DefaultTransactionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        try {
            Transaction transaction = this.currentOrNull();
            if (transaction != null) {
                transaction.commit();
            }
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new TransactionSystemException(string, (Throwable)e);
        }
    }

    protected void doRollback(@NotNull DefaultTransactionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        try {
            Transaction transaction = this.currentOrNull();
            if (transaction != null) {
                transaction.rollback();
            }
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new TransactionSystemException(string, (Throwable)e);
        }
    }

    @NotNull
    public Transaction newTransaction(int isolation, @Nullable Transaction outerTransaction) {
        DefaultTransactionDefinition defaultTransactionDefinition;
        DefaultTransactionDefinition $this$newTransaction_u24lambda_u2d0 = defaultTransactionDefinition = new DefaultTransactionDefinition();
        boolean bl = false;
        $this$newTransaction_u24lambda_u2d0.setIsolationLevel(isolation);
        DefaultTransactionDefinition tDefinition = defaultTransactionDefinition;
        this.getTransaction((TransactionDefinition)tDefinition);
        Transaction transaction = this.currentOrNull();
        if (transaction == null) {
            transaction = this.initTransaction();
        }
        return transaction;
    }

    private final Transaction initTransaction() {
        SpringTransaction springTransaction;
        Object object = TransactionSynchronizationManager.getResource((Object)this.obtainDataSource());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.springframework.jdbc.datasource.ConnectionHolder");
        }
        Connection connection = ((ConnectionHolder)object).getConnection();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
            springTransaction = new SpringTransaction((ExposedConnection)new JdbcConnectionImpl(connection), this.db, this.getDefaultIsolationLevel(), this.currentOrNull());
        }
        catch (Exception e) {
            SQLLogKt.getExposedLogger().error("Failed to start transaction. Connection will be closed.", (Throwable)e);
            connection.close();
            throw e;
        }
        SpringTransaction transactionImpl = springTransaction;
        TransactionManager.Companion.resetCurrent((TransactionManager)this);
        SpringTransaction $this$initTransaction_u24lambda_u2d1 = springTransaction = new Transaction((TransactionInterface)transactionImpl);
        boolean bl = false;
        TransactionSynchronizationManager.bindResource((Object)((Object)this), (Object)$this$initTransaction_u24lambda_u2d1);
        if (this.showSql) {
            SqlLogger[] sqlLoggerArray = new SqlLogger[]{(SqlLogger)StdOutSqlLogger.INSTANCE};
            SQLLogKt.addLogger((Transaction)$this$initTransaction_u24lambda_u2d1, (SqlLogger[])sqlLoggerArray);
        }
        return springTransaction;
    }

    @Nullable
    public Transaction currentOrNull() {
        return (Transaction)TransactionSynchronizationManager.getResource((Object)((Object)this));
    }

    public void bindTransactionToThread(@Nullable Transaction transaction) {
        if (transaction != null) {
            this.bindResourceForSure((Object)this, transaction);
        } else {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this));
        }
    }

    private final void bindResourceForSure(Object key, Object value) {
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)key);
        TransactionSynchronizationManager.bindResource((Object)key, (Object)value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/spring/SpringTransactionManager$SpringTransaction;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "connection", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "db", "Lorg/jetbrains/exposed/sql/Database;", "transactionIsolation", "", "outerTransaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(Lorg/jetbrains/exposed/spring/SpringTransactionManager;Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;Lorg/jetbrains/exposed/sql/Database;ILorg/jetbrains/exposed/sql/Transaction;)V", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "getTransactionIsolation", "()I", "close", "", "commit", "rollback", "spring-transaction"})
    private final class SpringTransaction
    implements TransactionInterface {
        @NotNull
        private final ExposedConnection<?> connection;
        @NotNull
        private final Database db;
        private final int transactionIsolation;
        @Nullable
        private final Transaction outerTransaction;

        public SpringTransaction(@NotNull ExposedConnection<?> connection, Database db2, @Nullable int transactionIsolation, Transaction outerTransaction) {
            Intrinsics.checkNotNullParameter((Object)((Object)SpringTransactionManager.this), (String)"this$0");
            Intrinsics.checkNotNullParameter(connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
            this.connection = connection;
            this.db = db2;
            this.transactionIsolation = transactionIsolation;
            this.outerTransaction = outerTransaction;
        }

        @NotNull
        public ExposedConnection<?> getConnection() {
            return this.connection;
        }

        @NotNull
        public Database getDb() {
            return this.db;
        }

        public int getTransactionIsolation() {
            return this.transactionIsolation;
        }

        @Nullable
        public Transaction getOuterTransaction() {
            return this.outerTransaction;
        }

        public void commit() {
            this.getConnection().commit();
        }

        public void rollback() {
            this.getConnection().rollback();
        }

        public void close() {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                Object object = TransactionSynchronizationManager.getResource((Object)SpringTransactionManager.this.springTxKey);
                if (object != null) {
                    Object object2 = object;
                    SpringTransactionManager springTransactionManager = SpringTransactionManager.this;
                    Object springTx = object2;
                    boolean bl = false;
                    springTransactionManager.doCleanupAfterCompletion(springTx);
                }
            }
        }
    }
}

