/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.spring;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.StdOutSqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcConnectionImpl;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001CBI\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\u0012\u0010*\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010,H\u0016J\u0018\u0010.\u001a\u00020&2\u0006\u0010+\u001a\u00020(2\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u00020&2\u0006\u0010+\u001a\u00020(H\u0014J\u0010\u00102\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0014J\u0010\u00106\u001a\u00020(2\u0006\u0010+\u001a\u00020(H\u0014J\n\u00107\u001a\u0004\u0018\u00010\u0002H\u0002J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0002J\u0010\u0010:\u001a\u00020,2\u0006\u0010+\u001a\u00020(H\u0002J\"\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\b2\b\u0010>\u001a\u0004\u0018\u00010,H\u0016J\b\u0010?\u001a\u00020&H\u0002J\u0010\u0010@\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0002H\u0002J\u0016\u0010A\u001a\u00020&2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u00020\u000b8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u000e\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\t\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lorg/jetbrains/exposed/spring/SpringTransactionManager;", "Lorg/springframework/jdbc/datasource/DataSourceTransactionManager;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "dataSource", "Ljavax/sql/DataSource;", "databaseConfig", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "showSql", "", "defaultReadOnly", "defaultRepetitionAttempts", "", "defaultMinRepetitionDelay", "", "defaultMaxRepetitionDelay", "(Ljavax/sql/DataSource;Lorg/jetbrains/exposed/sql/DatabaseConfig;ZZIJJ)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "defaultIsolationLevel", "getDefaultIsolationLevel", "()I", "setDefaultIsolationLevel", "(I)V", "getDefaultMaxRepetitionDelay", "()J", "setDefaultMaxRepetitionDelay", "(J)V", "getDefaultMinRepetitionDelay", "setDefaultMinRepetitionDelay", "getDefaultReadOnly", "()Z", "setDefaultReadOnly", "(Z)V", "getDefaultRepetitionAttempts", "setDefaultRepetitionAttempts", "transactionStackKey", "", "bindResourceForSure", "", "key", "", "value", "bindTransactionToThread", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "currentOrNull", "doBegin", "definition", "Lorg/springframework/transaction/TransactionDefinition;", "doCleanupAfterCompletion", "doCommit", "status", "Lorg/springframework/transaction/support/DefaultTransactionStatus;", "doRollback", "doSuspend", "getLastTransactionStack", "getTransactionStack", "", "initTransaction", "newTransaction", "isolation", "readOnly", "outerTransaction", "popTransactionStack", "pushTransactionStack", "setTransactionStack", "list", "SpringTransaction", "spring-transaction"})
@SourceDebugExtension(value={"SMAP\nSpringTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringTransactionManager.kt\norg/jetbrains/exposed/spring/SpringTransactionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class SpringTransactionManager
extends DataSourceTransactionManager
implements TransactionManager {
    private final boolean showSql;
    private volatile boolean defaultReadOnly;
    private volatile int defaultRepetitionAttempts;
    private volatile long defaultMinRepetitionDelay;
    private volatile long defaultMaxRepetitionDelay;
    @NotNull
    private final Database db;
    private volatile int defaultIsolationLevel;
    @NotNull
    private final String transactionStackKey;

    public SpringTransactionManager(@NotNull DataSource dataSource, @NotNull DatabaseConfig databaseConfig, boolean showSql, boolean defaultReadOnly, int defaultRepetitionAttempts, long defaultMinRepetitionDelay, long defaultMaxRepetitionDelay) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)databaseConfig, (String)"databaseConfig");
        super(dataSource);
        this.showSql = showSql;
        this.defaultReadOnly = defaultReadOnly;
        this.defaultRepetitionAttempts = defaultRepetitionAttempts;
        this.defaultMinRepetitionDelay = defaultMinRepetitionDelay;
        this.defaultMaxRepetitionDelay = defaultMaxRepetitionDelay;
        this.setRollbackOnCommitFailure(true);
        this.db = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, (DatabaseConfig)databaseConfig, (Function1)((Function1)new Function1<Database, TransactionManager>(this){
            final /* synthetic */ SpringTransactionManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final TransactionManager invoke(@NotNull Database it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0;
            }
        }), (int)2, null);
        this.defaultIsolationLevel = -1;
        this.transactionStackKey = "SPRING_TRANSACTION_STACK_KEY";
    }

    public /* synthetic */ SpringTransactionManager(DataSource dataSource, DatabaseConfig databaseConfig, boolean bl, boolean bl2, int n, long l, long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            databaseConfig = DatabaseConfig.Companion.invoke((Function1)1.INSTANCE);
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = databaseConfig.getDefaultReadOnly();
        }
        if ((n2 & 0x10) != 0) {
            n = databaseConfig.getDefaultRepetitionAttempts();
        }
        if ((n2 & 0x20) != 0) {
            l = databaseConfig.getDefaultMinRepetitionDelay();
        }
        if ((n2 & 0x40) != 0) {
            l2 = databaseConfig.getDefaultMaxRepetitionDelay();
        }
        this(dataSource, databaseConfig, bl, bl2, n, l, l2);
    }

    public boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl;
    }

    public int getDefaultRepetitionAttempts() {
        return this.defaultRepetitionAttempts;
    }

    public void setDefaultRepetitionAttempts(int n) {
        this.defaultRepetitionAttempts = n;
    }

    public long getDefaultMinRepetitionDelay() {
        return this.defaultMinRepetitionDelay;
    }

    public void setDefaultMinRepetitionDelay(long l) {
        this.defaultMinRepetitionDelay = l;
    }

    public long getDefaultMaxRepetitionDelay() {
        return this.defaultMaxRepetitionDelay;
    }

    public void setDefaultMaxRepetitionDelay(long l) {
        this.defaultMaxRepetitionDelay = l;
    }

    public int getDefaultIsolationLevel() {
        if (this.defaultIsolationLevel == -1) {
            this.defaultIsolationLevel = Database.Companion.getDefaultIsolationLevel(this.db);
        }
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    private final List<TransactionManager> getTransactionStack() {
        List list;
        Object object = TransactionSynchronizationManager.getResource((Object)this.transactionStackKey);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            list = (List)it;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void setTransactionStack(List<? extends TransactionManager> list) {
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.transactionStackKey);
        TransactionSynchronizationManager.bindResource((Object)this.transactionStackKey, list);
    }

    private final void pushTransactionStack(TransactionManager transaction) {
        List<TransactionManager> transactionList = this.getTransactionStack();
        this.setTransactionStack(CollectionsKt.plus((Collection)transactionList, (Object)transaction));
    }

    private final void popTransactionStack() {
        this.setTransactionStack(CollectionsKt.dropLast(this.getTransactionStack(), (int)1));
    }

    private final TransactionManager getLastTransactionStack() {
        return (TransactionManager)CollectionsKt.lastOrNull(this.getTransactionStack());
    }

    protected void doBegin(@NotNull Object transaction, @NotNull TransactionDefinition definition) {
        Transaction transaction2;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        super.doBegin(transaction, definition);
        if (TransactionSynchronizationManager.hasResource((Object)this.obtainDataSource()) && (transaction2 = this.currentOrNull()) == null) {
            transaction2 = this.initTransaction(transaction);
        }
        this.pushTransactionStack(this);
    }

    protected void doCleanupAfterCompletion(@NotNull Object transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        super.doCleanupAfterCompletion(transaction);
        if (!TransactionSynchronizationManager.hasResource((Object)this.obtainDataSource())) {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this));
        }
        this.popTransactionStack();
        TransactionManager.Companion.resetCurrent(this.getLastTransactionStack());
        if (TransactionSynchronizationManager.isSynchronizationActive() && TransactionSynchronizationManager.getSynchronizations().isEmpty()) {
            TransactionSynchronizationManager.clearSynchronization();
        }
    }

    @NotNull
    protected Object doSuspend(@NotNull Object transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this));
        Object object = super.doSuspend(transaction);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"super.doSuspend(transaction)");
        return object;
    }

    protected void doCommit(@NotNull DefaultTransactionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        try {
            Transaction transaction = this.currentOrNull();
            if (transaction != null) {
                transaction.commit();
            }
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new TransactionSystemException(string, (Throwable)e);
        }
    }

    protected void doRollback(@NotNull DefaultTransactionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        try {
            Transaction transaction = this.currentOrNull();
            if (transaction != null) {
                transaction.rollback();
            }
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new TransactionSystemException(string, (Throwable)e);
        }
    }

    @NotNull
    public Transaction newTransaction(int isolation, boolean readOnly, @Nullable Transaction outerTransaction) {
        DefaultTransactionDefinition defaultTransactionDefinition;
        DefaultTransactionDefinition $this$newTransaction_u24lambda_u241 = defaultTransactionDefinition = new DefaultTransactionDefinition();
        boolean bl = false;
        $this$newTransaction_u24lambda_u241.setReadOnly(readOnly);
        $this$newTransaction_u24lambda_u241.setIsolationLevel(isolation);
        DefaultTransactionDefinition tDefinition = defaultTransactionDefinition;
        TransactionStatus transactionStatus = this.getTransaction((TransactionDefinition)tDefinition);
        Intrinsics.checkNotNull((Object)transactionStatus, (String)"null cannot be cast to non-null type org.springframework.transaction.support.DefaultTransactionStatus");
        DefaultTransactionStatus transactionStatus2 = (DefaultTransactionStatus)transactionStatus;
        Transaction transaction = this.currentOrNull();
        if (transaction == null) {
            Object object = transactionStatus2.getTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"transactionStatus.transaction");
            transaction = this.initTransaction(object);
        }
        return transaction;
    }

    private final Transaction initTransaction(Object transaction) {
        SpringTransaction springTransaction;
        Object object = TransactionSynchronizationManager.getResource((Object)this.obtainDataSource());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springframework.jdbc.datasource.ConnectionHolder");
        Connection connection = ((ConnectionHolder)object).getConnection();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
            springTransaction = new SpringTransaction((ExposedConnection)new JdbcConnectionImpl(connection), this.db, this.getDefaultIsolationLevel(), this.getDefaultReadOnly(), this.currentOrNull(), transaction);
        }
        catch (Exception e) {
            SQLLogKt.getExposedLogger().error("Failed to start transaction. Connection will be closed.", (Throwable)e);
            connection.close();
            throw e;
        }
        SpringTransaction transactionImpl = springTransaction;
        TransactionManager.Companion.resetCurrent((TransactionManager)this);
        SpringTransaction $this$initTransaction_u24lambda_u242 = springTransaction = new Transaction((TransactionInterface)transactionImpl);
        boolean bl = false;
        TransactionSynchronizationManager.bindResource((Object)((Object)this), (Object)$this$initTransaction_u24lambda_u242);
        if (this.showSql) {
            SqlLogger[] sqlLoggerArray = new SqlLogger[]{StdOutSqlLogger.INSTANCE};
            SQLLogKt.addLogger((Transaction)$this$initTransaction_u24lambda_u242, (SqlLogger[])sqlLoggerArray);
        }
        return springTransaction;
    }

    @Nullable
    public Transaction currentOrNull() {
        return (Transaction)TransactionSynchronizationManager.getResource((Object)((Object)this));
    }

    public void bindTransactionToThread(@Nullable Transaction transaction) {
        if (transaction != null) {
            this.bindResourceForSure((Object)this, transaction);
        } else {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this));
        }
    }

    private final void bindResourceForSure(Object key, Object value) {
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)key);
        TransactionSynchronizationManager.bindResource((Object)key, (Object)value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B;\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/spring/SpringTransactionManager$SpringTransaction;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "connection", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "db", "Lorg/jetbrains/exposed/sql/Database;", "transactionIsolation", "", "readOnly", "", "outerTransaction", "Lorg/jetbrains/exposed/sql/Transaction;", "currentTransaction", "", "(Lorg/jetbrains/exposed/spring/SpringTransactionManager;Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;Lorg/jetbrains/exposed/sql/Database;IZLorg/jetbrains/exposed/sql/Transaction;Ljava/lang/Object;)V", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "getReadOnly", "()Z", "getTransactionIsolation", "()I", "close", "", "commit", "rollback", "spring-transaction"})
    private final class SpringTransaction
    implements TransactionInterface {
        @NotNull
        private final ExposedConnection<?> connection;
        @NotNull
        private final Database db;
        private final int transactionIsolation;
        private final boolean readOnly;
        @Nullable
        private final Transaction outerTransaction;
        @NotNull
        private final Object currentTransaction;

        public SpringTransaction(@NotNull ExposedConnection<?> connection, Database db2, int transactionIsolation, @Nullable boolean readOnly, @NotNull Transaction outerTransaction, Object currentTransaction) {
            Intrinsics.checkNotNullParameter(connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)db2, (String)"db");
            Intrinsics.checkNotNullParameter((Object)currentTransaction, (String)"currentTransaction");
            this.connection = connection;
            this.db = db2;
            this.transactionIsolation = transactionIsolation;
            this.readOnly = readOnly;
            this.outerTransaction = outerTransaction;
            this.currentTransaction = currentTransaction;
        }

        @NotNull
        public ExposedConnection<?> getConnection() {
            return this.connection;
        }

        @NotNull
        public Database getDb() {
            return this.db;
        }

        public int getTransactionIsolation() {
            return this.transactionIsolation;
        }

        public boolean getReadOnly() {
            return this.readOnly;
        }

        @Nullable
        public Transaction getOuterTransaction() {
            return this.outerTransaction;
        }

        public void commit() {
            this.getConnection().commit();
        }

        public void rollback() {
            this.getConnection().rollback();
        }

        public void close() {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                SpringTransactionManager.this.doCleanupAfterCompletion(this.currentTransaction);
            }
        }
    }
}

