/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.spring;

import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.StdOutSqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002%&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0007H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0014J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0014J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0013H\u0014J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0013H\u0014J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/spring/SpringTransactionManager;", "Lorg/springframework/transaction/support/AbstractPlatformTransactionManager;", "dataSource", "Ljavax/sql/DataSource;", "databaseConfig", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "showSql", "", "<init>", "(Ljavax/sql/DataSource;Lorg/jetbrains/exposed/sql/DatabaseConfig;Z)V", "_database", "Lorg/jetbrains/exposed/sql/Database;", "_transactionManager", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "threadLocalTransactionManager", "getThreadLocalTransactionManager", "()Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "useSavepointForNestedTransaction", "doGetTransaction", "", "doSuspend", "transaction", "doResume", "", "suspendedResources", "isExistingTransaction", "doBegin", "definition", "Lorg/springframework/transaction/TransactionDefinition;", "doCommit", "status", "Lorg/springframework/transaction/support/DefaultTransactionStatus;", "doRollback", "doCleanupAfterCompletion", "closeStatementsAndConnections", "Lorg/jetbrains/exposed/sql/Transaction;", "doSetRollbackOnly", "SuspendedObject", "ExposedTransactionObject", "spring-transaction"})
public final class SpringTransactionManager
extends AbstractPlatformTransactionManager {
    private final boolean showSql;
    @NotNull
    private Database _database;
    @NotNull
    private TransactionManager _transactionManager;

    /*
     * WARNING - void declaration
     */
    public SpringTransactionManager(@NotNull DataSource dataSource, @NotNull DatabaseConfig databaseConfig, boolean showSql) {
        void $this$_init__u24lambda_u241;
        Database database;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)databaseConfig, (String)"databaseConfig");
        this.showSql = showSql;
        Database database2 = database = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, (DatabaseConfig)databaseConfig, null, (int)10, null);
        SpringTransactionManager springTransactionManager = this;
        boolean bl = false;
        this._transactionManager = TransactionApiKt.getTransactionManager((Database)$this$_init__u24lambda_u241);
        springTransactionManager._database = database;
        this.setNestedTransactionAllowed(databaseConfig.getUseNestedTransactions());
    }

    public /* synthetic */ SpringTransactionManager(DataSource dataSource, DatabaseConfig databaseConfig, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            databaseConfig = DatabaseConfig.Companion.invoke(SpringTransactionManager::_init_$lambda$0);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(dataSource, databaseConfig, bl);
    }

    private final TransactionManager getThreadLocalTransactionManager() {
        return this._transactionManager;
    }

    protected boolean useSavepointForNestedTransaction() {
        return false;
    }

    @NotNull
    protected Object doGetTransaction() {
        TransactionManager outerManager = TransactionManager.Companion.getManager();
        Transaction outer = this.getThreadLocalTransactionManager().currentOrNull();
        return new ExposedTransactionObject(this.getThreadLocalTransactionManager(), outerManager, outer);
    }

    @NotNull
    protected Object doSuspend(@NotNull Object transaction) {
        SuspendedObject suspendedObject;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ExposedTransactionObject trxObject = (ExposedTransactionObject)transaction;
        TransactionManager currentManager = trxObject.getManager();
        Transaction transaction2 = currentManager.currentOrNull();
        Intrinsics.checkNotNull((Object)transaction2, (String)"null cannot be cast to non-null type org.jetbrains.exposed.sql.Transaction");
        SuspendedObject $this$doSuspend_u24lambda_u242 = suspendedObject = new SuspendedObject(transaction2, currentManager);
        boolean bl = false;
        currentManager.bindTransactionToThread(null);
        TransactionManager.Companion.resetCurrent(null);
        return suspendedObject;
    }

    protected void doResume(@Nullable Object transaction, @NotNull Object suspendedResources) {
        Intrinsics.checkNotNullParameter((Object)suspendedResources, (String)"suspendedResources");
        SuspendedObject suspendedObject = (SuspendedObject)suspendedResources;
        TransactionManager.Companion.resetCurrent(suspendedObject.getManager());
        this.getThreadLocalTransactionManager().bindTransactionToThread(suspendedObject.getTransaction());
    }

    protected boolean isExistingTransaction(@NotNull Object transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ExposedTransactionObject trxObject = (ExposedTransactionObject)transaction;
        return trxObject.getCurrentTransaction() != null;
    }

    protected void doBegin(@NotNull Object transaction, @NotNull TransactionDefinition definition) {
        Transaction transaction2;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        ExposedTransactionObject trxObject = (ExposedTransactionObject)transaction;
        TransactionManager currentTransactionManager = trxObject.getManager();
        TransactionManager.Companion.resetCurrent(this.getThreadLocalTransactionManager());
        Transaction $this$doBegin_u24lambda_u243 = transaction2 = currentTransactionManager.newTransaction(definition.getIsolationLevel(), definition.isReadOnly(), currentTransactionManager.currentOrNull());
        boolean bl = false;
        if (definition.getTimeout() != -1) {
            $this$doBegin_u24lambda_u243.setQueryTimeout(Integer.valueOf(definition.getTimeout()));
        }
        if (this.showSql) {
            SqlLogger[] sqlLoggerArray = new SqlLogger[]{StdOutSqlLogger.INSTANCE};
            SQLLogKt.addLogger((Transaction)$this$doBegin_u24lambda_u243, (SqlLogger[])sqlLoggerArray);
        }
    }

    protected void doCommit(@NotNull DefaultTransactionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Object object = status.getTransaction();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.exposed.spring.SpringTransactionManager.ExposedTransactionObject");
        ExposedTransactionObject trxObject = (ExposedTransactionObject)object;
        TransactionManager.Companion.resetCurrent(trxObject.getManager());
        trxObject.commit();
    }

    protected void doRollback(@NotNull DefaultTransactionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Object object = status.getTransaction();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.exposed.spring.SpringTransactionManager.ExposedTransactionObject");
        ExposedTransactionObject trxObject = (ExposedTransactionObject)object;
        TransactionManager.Companion.resetCurrent(trxObject.getManager());
        trxObject.rollback();
    }

    protected void doCleanupAfterCompletion(@NotNull Object transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ExposedTransactionObject trxObject = (ExposedTransactionObject)transaction;
        trxObject.cleanUpTransactionIfIsPossible((Function1<? super Transaction, Unit>)((Function1)arg_0 -> SpringTransactionManager.doCleanupAfterCompletion$lambda$4(this, arg_0)));
        trxObject.setCurrentToOuter();
    }

    private final void closeStatementsAndConnections(Transaction transaction) {
        PreparedStatementApi currentStatement = transaction.getCurrentStatement();
        try {
            PreparedStatementApi preparedStatementApi = currentStatement;
            if (preparedStatementApi != null) {
                PreparedStatementApi it = preparedStatementApi;
                boolean bl = false;
                it.closeIfPossible();
                transaction.setCurrentStatement(null);
            }
            transaction.closeExecutedStatements();
        }
        catch (Exception error) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", (Throwable)error);
        }
        try {
            transaction.close();
        }
        catch (Exception error) {
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + error.getMessage() + ". Statement: " + currentStatement, (Throwable)error);
        }
    }

    protected void doSetRollbackOnly(@NotNull DefaultTransactionStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Object object = status.getTransaction();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.exposed.spring.SpringTransactionManager.ExposedTransactionObject");
        ExposedTransactionObject trxObject = (ExposedTransactionObject)object;
        trxObject.setRollbackOnly();
    }

    private static final Unit _init_$lambda$0(DatabaseConfig.Builder $this$DatabaseConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$DatabaseConfig, (String)"$this$DatabaseConfig");
        return Unit.INSTANCE;
    }

    private static final Unit doCleanupAfterCompletion$lambda$4(SpringTransactionManager this$0, Transaction it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.closeStatementsAndConnections(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\u000f2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000f0\u0011J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\rH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J)\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010 \u001a\u00020\r2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/spring/SpringTransactionManager$ExposedTransactionObject;", "Lorg/springframework/transaction/support/SmartTransactionObject;", "manager", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "outerManager", "outerTransaction", "Lorg/jetbrains/exposed/sql/Transaction;", "<init>", "(Lorg/jetbrains/exposed/sql/transactions/TransactionManager;Lorg/jetbrains/exposed/sql/transactions/TransactionManager;Lorg/jetbrains/exposed/sql/Transaction;)V", "getManager", "()Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "getOuterManager", "isRollback", "", "cleanUpTransactionIfIsPossible", "", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "transaction", "setCurrentToOuter", "commit", "rollback", "getCurrentTransaction", "setRollbackOnly", "isRollbackOnly", "flush", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "spring-transaction"})
    private static final class ExposedTransactionObject
    implements SmartTransactionObject {
        @NotNull
        private final TransactionManager manager;
        @NotNull
        private final TransactionManager outerManager;
        @Nullable
        private final Transaction outerTransaction;
        private boolean isRollback;

        public ExposedTransactionObject(@NotNull TransactionManager manager, @NotNull TransactionManager outerManager, @Nullable Transaction outerTransaction) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)outerManager, (String)"outerManager");
            this.manager = manager;
            this.outerManager = outerManager;
            this.outerTransaction = outerTransaction;
        }

        @NotNull
        public final TransactionManager getManager() {
            return this.manager;
        }

        @NotNull
        public final TransactionManager getOuterManager() {
            return this.outerManager;
        }

        public final void cleanUpTransactionIfIsPossible(@NotNull Function1<? super Transaction, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Transaction currentTransaction = this.getCurrentTransaction();
            if (currentTransaction != null) {
                block.invoke((Object)currentTransaction);
            }
        }

        public final void setCurrentToOuter() {
            this.manager.bindTransactionToThread(this.outerTransaction);
            TransactionManager.Companion.resetCurrent(this.outerManager);
        }

        public final void commit() {
            try {
                Transaction transaction = this.manager.currentOrNull();
                if (transaction != null) {
                    transaction.commit();
                }
            }
            catch (Exception error) {
                String string = error.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new TransactionSystemException(string, (Throwable)error);
            }
        }

        public final void rollback() {
            try {
                Transaction transaction = this.manager.currentOrNull();
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (Exception error) {
                String string = error.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new TransactionSystemException(string, (Throwable)error);
            }
        }

        @Nullable
        public final Transaction getCurrentTransaction() {
            return this.manager.currentOrNull();
        }

        public final void setRollbackOnly() {
            this.isRollback = true;
        }

        public boolean isRollbackOnly() {
            return this.isRollback;
        }

        public void flush() {
        }

        @NotNull
        public final TransactionManager component1() {
            return this.manager;
        }

        @NotNull
        public final TransactionManager component2() {
            return this.outerManager;
        }

        private final Transaction component3() {
            return this.outerTransaction;
        }

        @NotNull
        public final ExposedTransactionObject copy(@NotNull TransactionManager manager, @NotNull TransactionManager outerManager, @Nullable Transaction outerTransaction) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)outerManager, (String)"outerManager");
            return new ExposedTransactionObject(manager, outerManager, outerTransaction);
        }

        public static /* synthetic */ ExposedTransactionObject copy$default(ExposedTransactionObject exposedTransactionObject, TransactionManager transactionManager, TransactionManager transactionManager2, Transaction transaction, int n, Object object) {
            if ((n & 1) != 0) {
                transactionManager = exposedTransactionObject.manager;
            }
            if ((n & 2) != 0) {
                transactionManager2 = exposedTransactionObject.outerManager;
            }
            if ((n & 4) != 0) {
                transaction = exposedTransactionObject.outerTransaction;
            }
            return exposedTransactionObject.copy(transactionManager, transactionManager2, transaction);
        }

        @NotNull
        public String toString() {
            return "ExposedTransactionObject(manager=" + this.manager + ", outerManager=" + this.outerManager + ", outerTransaction=" + this.outerTransaction + ")";
        }

        public int hashCode() {
            int result = this.manager.hashCode();
            result = result * 31 + this.outerManager.hashCode();
            result = result * 31 + (this.outerTransaction == null ? 0 : this.outerTransaction.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExposedTransactionObject)) {
                return false;
            }
            ExposedTransactionObject exposedTransactionObject = (ExposedTransactionObject)other;
            if (!Intrinsics.areEqual((Object)this.manager, (Object)exposedTransactionObject.manager)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outerManager, (Object)exposedTransactionObject.outerManager)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.outerTransaction, (Object)exposedTransactionObject.outerTransaction);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/spring/SpringTransactionManager$SuspendedObject;", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "manager", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "<init>", "(Lorg/jetbrains/exposed/sql/Transaction;Lorg/jetbrains/exposed/sql/transactions/TransactionManager;)V", "getTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "getManager", "()Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "spring-transaction"})
    private static final class SuspendedObject {
        @NotNull
        private final Transaction transaction;
        @NotNull
        private final TransactionManager manager;

        public SuspendedObject(@NotNull Transaction transaction, @NotNull TransactionManager manager) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            this.transaction = transaction;
            this.manager = manager;
        }

        @NotNull
        public final Transaction getTransaction() {
            return this.transaction;
        }

        @NotNull
        public final TransactionManager getManager() {
            return this.manager;
        }

        @NotNull
        public final Transaction component1() {
            return this.transaction;
        }

        @NotNull
        public final TransactionManager component2() {
            return this.manager;
        }

        @NotNull
        public final SuspendedObject copy(@NotNull Transaction transaction, @NotNull TransactionManager manager) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            return new SuspendedObject(transaction, manager);
        }

        public static /* synthetic */ SuspendedObject copy$default(SuspendedObject suspendedObject, Transaction transaction, TransactionManager transactionManager, int n, Object object) {
            if ((n & 1) != 0) {
                transaction = suspendedObject.transaction;
            }
            if ((n & 2) != 0) {
                transactionManager = suspendedObject.manager;
            }
            return suspendedObject.copy(transaction, transactionManager);
        }

        @NotNull
        public String toString() {
            return "SuspendedObject(transaction=" + this.transaction + ", manager=" + this.manager + ")";
        }

        public int hashCode() {
            int result = this.transaction.hashCode();
            result = result * 31 + this.manager.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuspendedObject)) {
                return false;
            }
            SuspendedObject suspendedObject = (SuspendedObject)other;
            if (!Intrinsics.areEqual((Object)this.transaction, (Object)suspendedObject.transaction)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.manager, (Object)suspendedObject.manager);
        }
    }
}

