/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.intellij.grammar.BnfParserDefinition;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfValueList;
import org.jetbrains.annotations.NotNull;

public class BnfFoldingBuilder
extends CustomFoldingBuilder {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> result, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (!(root instanceof BnfFile)) {
            return;
        }
        BnfFile file = (BnfFile)root;
        for (BnfAttrs attrs : file.getAttributes()) {
            TextRange textRange = attrs.getTextRange();
            if (textRange.getLength() <= 2) continue;
            result.add(new FoldingDescriptor((PsiElement)attrs, textRange));
            for (BnfAttr attr : attrs.getAttrList()) {
                BnfExpression attrValue = attr.getExpression();
                if (!(attrValue instanceof BnfValueList) || attrValue.getTextLength() <= 2) continue;
                result.add(new FoldingDescriptor((PsiElement)attrValue, attrValue.getTextRange()));
            }
        }
        for (BnfRule rule : file.getRules()) {
            BnfAttrs attrs = rule.getAttrs();
            if (attrs == null) continue;
            result.add(new FoldingDescriptor((PsiElement)attrs, attrs.getTextRange()));
        }
        if (!quick) {
            PsiTreeUtil.processElements((PsiElement)file, element -> {
                if (element.getNode().getElementType() == BnfParserDefinition.BNF_BLOCK_COMMENT) {
                    result.add(new FoldingDescriptor(element, element.getTextRange()));
                }
                return true;
            });
        }
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psi = node.getPsi();
        if (psi instanceof BnfAttrs) {
            return "{..}";
        }
        if (psi instanceof BnfRule) {
            return ((BnfRule)psi).getName() + " ::= ...";
        }
        if (psi instanceof BnfValueList) {
            return "[..]";
        }
        if (node.getElementType() == BnfParserDefinition.BNF_BLOCK_COMMENT) {
            return "/*..*/";
        }
        return null;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        PsiElement psi = node.getPsi();
        return psi instanceof BnfValueList || psi instanceof BnfAttrs && !(psi.getParent() instanceof BnfRule);
    }
}

