/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.grammar.BnfLanguage;
import org.intellij.grammar.parser.BnfLexer;
import org.intellij.grammar.parser.GrammarParser;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.BnfFileImpl;
import org.jetbrains.annotations.NotNull;

public class BnfParserDefinition
implements ParserDefinition {
    public static final IFileElementType BNF_FILE_ELEMENT_TYPE = new IFileElementType("BNF_FILE", (Language)BnfLanguage.INSTANCE);
    public static final TokenSet WS = TokenSet.WHITE_SPACE;
    public static final IElementType BNF_LINE_COMMENT = BnfTypes.BNF_LINE_COMMENT;
    public static final IElementType BNF_BLOCK_COMMENT = BnfTypes.BNF_BLOCK_COMMENT;
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{BNF_LINE_COMMENT, BNF_BLOCK_COMMENT});
    public static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{BnfTypes.BNF_STRING});
    public static final TokenSet PARENS_L = TokenSet.create((IElementType[])new IElementType[]{BnfTypes.BNF_LEFT_PAREN, BnfTypes.BNF_LEFT_BRACE, BnfTypes.BNF_LEFT_BRACKET, BnfTypes.BNF_EXTERNAL_START});
    public static final TokenSet PARENS_R = TokenSet.create((IElementType[])new IElementType[]{BnfTypes.BNF_RIGHT_PAREN, BnfTypes.BNF_RIGHT_BRACE, BnfTypes.BNF_RIGHT_BRACKET, BnfTypes.BNF_EXTERNAL_END});
    public static final TokenSet OPERATORS = TokenSet.create((IElementType[])new IElementType[]{BnfTypes.BNF_OP_AND, BnfTypes.BNF_OP_EQ, BnfTypes.BNF_OP_NOT, BnfTypes.BNF_OP_ONEMORE, BnfTypes.BNF_OP_OPT, BnfTypes.BNF_OP_OR, BnfTypes.BNF_OP_ZEROMORE});

    @NotNull
    public Lexer createLexer(Project project) {
        return new BnfLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new GrammarParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return BNF_FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WS;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return LITERALS;
    }

    @NotNull
    public PsiElement createElement(ASTNode astNode) {
        throw new UnsupportedOperationException(astNode.getElementType().toString());
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        return new BnfFileImpl(fileViewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode node1, ASTNode node2) {
        IElementType t1 = node1.getElementType();
        if (t1 == BnfTypes.BNF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

