/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreProjectEnvironment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.search.CachesBasedRefSearcher;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.intellij.grammar.java.JavaHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightPsi {
    private static final MyParsing ourParsing;

    public static void init() {
    }

    @Nullable
    public static PsiFile parseFile(@NotNull File file, @NotNull ParserDefinition parserDefinition) throws IOException {
        String name = file.getName();
        String text = FileUtil.loadFile((File)file);
        return LightPsi.parseFile(name, text, parserDefinition);
    }

    @Nullable
    public static PsiFile parseFile(@NotNull String name, @NotNull String text, @NotNull ParserDefinition parserDefinition) {
        return ourParsing.createFile(name, text, parserDefinition);
    }

    @NotNull
    public static ASTNode parseText(@NotNull String text, @NotNull ParserDefinition parserDefinition) {
        return ourParsing.createAST(text, parserDefinition);
    }

    @NotNull
    public static SyntaxTraverser<LighterASTNode> parseLight(@NotNull String text, @NotNull ParserDefinition parserDefinition) {
        return ourParsing.parseLight(text, parserDefinition);
    }

    public static void main(String[] args) throws Throwable {
        if (args.length < 2) {
            System.out.println("Usage: Main <output-dir> <classes.log.txt>");
            return;
        }
        File dir = new File(args[0]);
        File file = new File(args[1]);
        File out = new File(dir, "light-psi-all.jar");
        int count = LightPsi.mainImpl(file, out);
        System.out.println(StringUtil.formatFileSize((long)out.length()) + " and " + count + " classes written to " + out.getName());
    }

    private static int mainImpl(File classesFile, File outJarFile) throws Throwable {
        String s;
        BufferedReader reader = new BufferedReader(new FileReader(classesFile, StandardCharsets.UTF_8));
        Pattern pattern = Pattern.compile(".*\\[class,load] (?<c>.*) source: (?:file:)?(?<f>.*)");
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(outJarFile));
        int count = 0;
        LightPsi.addJarEntry(jar, "misc/registry.properties");
        while ((s = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            String className = matcher.group("c");
            String path = matcher.group("f");
            if (!LightPsi.shouldAddEntry(path)) continue;
            LightPsi.addJarEntry(jar, className.replace(".", "/") + ".class");
            ++count;
        }
        jar.close();
        return count;
    }

    private static boolean shouldAddEntry(String path) {
        if (!path.startsWith("/")) {
            return false;
        }
        if (path.contains("/grammar-kit/")) {
            return false;
        }
        return path.contains("/out/classes/production/") || path.contains("idea.jar") || path.contains("platform-api.jar") || path.contains("platform-impl.jar") || path.contains("util.jar") || path.contains("extensions.jar");
    }

    private static void addJarEntry(JarOutputStream jarFile, String resourceName) throws IOException {
        InputStream stream = LightPsi.class.getClassLoader().getResourceAsStream(resourceName);
        if (stream == null) {
            System.err.println("Skipping missing " + resourceName);
        } else {
            jarFile.putNextEntry(new JarEntry(resourceName));
            FileUtil.copy((InputStream)stream, (OutputStream)jarFile);
            jarFile.closeEntry();
        }
    }

    static {
        try {
            ourParsing = new MyParsing();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class MyParsing
    implements Disposable {
        final CoreApplicationEnvironment app = new CoreApplicationEnvironment((Disposable)this);
        final CoreProjectEnvironment proj = new CoreProjectEnvironment((Disposable)this, this.app);

        MyParsing() {
            Init.initExtensions(this.app.getApplication(), this.getProject());
        }

        @Nullable
        protected PsiFile createFile(@NotNull String name, @NotNull String text, @NotNull ParserDefinition definition) {
            Language language = definition.getFileNodeType().getLanguage();
            Init.addKeyedExtension(LanguageParserDefinitions.INSTANCE, language, definition, this);
            MockLanguageFileType fileType = new MockLanguageFileType(language, FileUtilRt.getExtension((String)name));
            this.app.registerFileType((FileType)fileType, fileType.getDefaultExtension());
            LightVirtualFile file = new LightVirtualFile(name, (FileType)fileType, (CharSequence)text);
            return ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)this.getProject())).trySetupPsiForFile(file, language, true, false);
        }

        @NotNull
        protected ASTNode createAST(@NotNull String text, @NotNull ParserDefinition definition) {
            PsiParser parser = definition.createParser((Project)this.getProject());
            Lexer lexer = definition.createLexer((Project)this.getProject());
            PsiBuilderImpl psiBuilder = new PsiBuilderImpl((Project)this.getProject(), null, definition, lexer, (CharTable)new CharTableImpl(), (CharSequence)text, null, null);
            return parser.parse((IElementType)definition.getFileNodeType(), (PsiBuilder)psiBuilder);
        }

        @NotNull
        protected SyntaxTraverser<LighterASTNode> parseLight(@NotNull String text, @NotNull ParserDefinition definition) {
            LightPsiParser parser = (LightPsiParser)definition.createParser((Project)this.getProject());
            Lexer lexer = definition.createLexer((Project)this.getProject());
            PsiBuilderImpl psiBuilder = new PsiBuilderImpl((Project)this.getProject(), null, definition, lexer, (CharTable)new CharTableImpl(), (CharSequence)text, null, null);
            parser.parseLight((IElementType)definition.getFileNodeType(), (PsiBuilder)psiBuilder);
            return SyntaxTraverser.lightTraverser((PsiBuilder)psiBuilder);
        }

        private MockProject getProject() {
            return this.proj.getProject();
        }

        public void dispose() {
        }
    }

    public static class MockLanguageFileType
    extends LanguageFileType {
        private final String myExtension;

        public MockLanguageFileType(@NotNull Language language, String extension) {
            super(language);
            this.myExtension = extension;
        }

        @NotNull
        public String getName() {
            return this.getLanguage().getID();
        }

        @NotNull
        public String getDescription() {
            return "";
        }

        @NotNull
        public String getDefaultExtension() {
            return this.myExtension;
        }

        public Icon getIcon() {
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LanguageFileType)) {
                return false;
            }
            return this.getLanguage().equals(((LanguageFileType)obj).getLanguage());
        }
    }

    public static class Init {
        public static void initExtensions(MockApplication application, @NotNull MockProject project) {
            ExtensionsAreaImpl ra = application.getExtensionArea();
            ra.registerExtensionPoint("com.intellij.referencesSearch", "com.intellij.util.QueryExecutor", ExtensionPoint.Kind.INTERFACE, false);
            ra.getExtensionPoint("com.intellij.referencesSearch").registerExtension((Object)new CachesBasedRefSearcher(), (Disposable)project);
            ra.registerExtensionPoint("com.intellij.useScopeEnlarger", "com.intellij.psi.search.UseScopeEnlarger", ExtensionPoint.Kind.INTERFACE, false);
            ra.registerExtensionPoint("com.intellij.useScopeOptimizer", "com.intellij.psi.search.ScopeOptimizer", ExtensionPoint.Kind.INTERFACE, false);
            ra.registerExtensionPoint("com.intellij.codeInsight.containerProvider", "com.intellij.codeInsight.ContainerProvider", ExtensionPoint.Kind.INTERFACE, false);
            ra.registerExtensionPoint("com.intellij.languageInjector", "com.intellij.psi.LanguageInjector", ExtensionPoint.Kind.INTERFACE, false);
            project.registerService(PsiSearchHelper.class, PsiSearchHelperImpl.class);
            project.getExtensionArea().registerExtensionPoint("com.intellij.multiHostInjector", "com.intellij.lang.injection.MultiHostInjector", ExtensionPoint.Kind.INTERFACE, false);
            try {
                project.registerService(JavaHelper.class, (Object)new JavaHelper.AsmHelper());
            }
            catch (LinkageError e) {
                System.out.println("ASM not available, using reflection helper: " + e);
                project.registerService(JavaHelper.class, (Object)new JavaHelper.ReflectionHelper());
            }
        }

        public static <T, KeyT> void addKeyedExtension(@NotNull KeyedExtensionCollector<T, KeyT> instance, @NotNull KeyT key, @NotNull T object, @Nullable Disposable disposable) {
            instance.addExplicitExtension(key, object);
            if (disposable != null) {
                Disposer.register((Disposable)disposable, () -> instance.removeExplicitExtension(key, object));
            }
        }
    }
}

