/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.actions;

import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Consumer;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfGenerateParserUtilAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (!(file instanceof BnfFile)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            boolean enabled = ((BnfFile)file).findAttribute(null, KnownAttribute.PARSER_UTIL_CLASS, null) == null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        String text;
        int anchorOffset;
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (!(file instanceof BnfFile)) {
            return;
        }
        Project project = file.getProject();
        BnfFile bnfFile = (BnfFile)file;
        String qualifiedName = BnfGenerateParserUtilAction.createClass(bnfFile, "Create Parser Util Class", "com.intellij.lang.parser.GeneratedParserUtilBase", BnfGenerateParserUtilAction.getGrammarName(bnfFile) + "ParserUtil", BnfGenerateParserUtilAction.getGrammarPackage(bnfFile));
        if (qualifiedName == null) {
            return;
        }
        String definition = "\n  " + KnownAttribute.PARSER_UTIL_CLASS.getName() + "=\"" + qualifiedName + "\"";
        BnfAttr attrParser = bnfFile.findAttribute(null, KnownAttribute.PARSER_CLASS, null);
        if (attrParser == null) {
            BnfAttrs rootAttrs = (BnfAttrs)ContainerUtil.getFirstItem(bnfFile.getAttributes());
            if (rootAttrs == null) {
                anchorOffset = 0;
                text = "{" + definition + "\n}";
            } else {
                anchorOffset = rootAttrs.getFirstChild().getTextOffset();
                text = definition;
            }
        } else {
            anchorOffset = attrParser.getTextRange().getEndOffset();
            text = definition;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)bnfFile);
        if (document == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> {
            int position = document.getLineEndOffset(document.getLineNumber(anchorOffset));
            document.insertString(position, (CharSequence)text);
        });
    }

    static String getGrammarPackage(BnfFile bnfFile) {
        String value = bnfFile.findAttributeValue(null, KnownAttribute.PARSER_CLASS, null);
        return value == null ? "" : StringUtil.getPackageName((String)value);
    }

    static String getGrammarName(BnfFile bnfFile) {
        String parser = bnfFile.findAttributeValue(null, KnownAttribute.PARSER_CLASS, null);
        if (!KnownAttribute.PARSER_CLASS.getDefaultValue().equals(parser)) {
            String result;
            String shortName = parser == null ? "" : StringUtil.getShortName((String)parser);
            int len = "Parser".length();
            String string = result = shortName.endsWith("Parser") ? shortName.substring(0, shortName.length() - len) : shortName;
            if (StringUtil.isNotEmpty((String)result)) {
                return result;
            }
        }
        return StringUtil.capitalize((String)FileUtil.getNameWithoutExtension((String)bnfFile.getName()));
    }

    public static String createClass(@NotNull PsiFile origin, @NlsContexts.DialogTitle @NotNull String title, @Nullable String baseClass, @NotNull String suggestedName, @NotNull String suggestedPackage) {
        Module module;
        Project project = origin.getProject();
        CreateClassDialog dialog = new CreateClassDialog(project, title, suggestedName, suggestedPackage, (ClassKind)CreateClassKind.CLASS, true, module = ModuleUtilCore.findModuleForPsiElement((PsiElement)origin));
        if (!dialog.showAndGet()) {
            return null;
        }
        String className = dialog.getClassName();
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        return BnfGenerateParserUtilAction.createClass(className, targetDirectory, baseClass, title, null);
    }

    static String createClass(String className, PsiDirectory targetDirectory, String baseClass, @NlsContexts.Command String title, Consumer<? super PsiClass> consumer) {
        Project project = targetDirectory.getProject();
        Ref resultRef = Ref.create();
        WriteCommandAction.writeCommandAction((Project)project).withName(title).run(() -> {
            IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiJavaCodeReferenceElement ref = baseClass == null ? null : elementFactory.createReferenceElementByFQClassName(baseClass, GlobalSearchScope.allScope((Project)project));
            try {
                PsiClass resultClass = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
                resultRef.set((Object)resultClass);
                if (ref != null) {
                    PsiReferenceList targetReferenceList;
                    PsiElement clazz = ref.resolve();
                    boolean isInterface = clazz instanceof PsiClass && ((PsiClass)clazz).isInterface();
                    PsiReferenceList psiReferenceList = targetReferenceList = isInterface ? resultClass.getImplementsList() : resultClass.getExtendsList();
                    assert (targetReferenceList != null);
                    targetReferenceList.add((PsiElement)ref);
                }
                if (consumer != null) {
                    consumer.accept(resultClass);
                }
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Unable to create class " + className + "\n" + e.getLocalizedMessage()), (String)title));
            }
        });
        return resultRef.isNull() ? null : ((PsiClass)resultRef.get()).getQualifiedName();
    }
}

