/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.intellij.grammar.actions.FileGeneratorUtil;
import org.intellij.grammar.config.Options;
import org.intellij.jflex.parser.JFlexFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfRunJFlexAction
extends DumbAwareAction {
    private static final String[] JETBRAINS_JFLEX_URLS = new String[]{System.getProperty("grammar.kit.jflex.jar", "https://cache-redirector.jetbrains.com/intellij-dependencies/org/jetbrains/intellij/deps/jflex/jflex/1.7.0-2/jflex-1.7.0-2.jar"), System.getProperty("grammar.kit.jflex.skeleton", "https://raw.github.com/JetBrains/intellij-community/master/tools/lexer/idea-flex.skeleton")};
    private static final Key<Pair<String, OSProcessHandler>> BATCH_ID_KEY = Key.create((String)"BnfRunJFlexAction.batchId");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        List<VirtualFile> files = BnfRunJFlexAction.getFiles(e);
        e.getPresentation().setEnabledAndVisible(project != null && !files.isEmpty());
    }

    private static List<VirtualFile> getFiles(@NotNull AnActionEvent e) {
        return JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file -> {
            FileType fileType = file.getFileType();
            return fileType == JFlexFileType.INSTANCE || !fileType.isBinary() && file.getName().endsWith(".flex");
        }).toList();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = BnfRunJFlexAction.getEventProject((AnActionEvent)e);
        final List<VirtualFile> files = BnfRunJFlexAction.getFiles(e);
        if (project == null || files.isEmpty()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        final List<File> flexFiles = BnfRunJFlexAction.getOrDownload(project, JETBRAINS_JFLEX_URLS);
        if (flexFiles.isEmpty()) {
            FileGeneratorUtil.fail(project, "JFlex jar not found", "Create global library with jflex-xxx.jar and idea-flex.skeleton file to fix.");
            return;
        }
        if (StringUtil.endsWithIgnoreCase((String)flexFiles.get(0).getName(), (String)"JFlex.jar")) {
            String DOC_URL = "http://jflex.de/changelog.html";
            Notification notification = new Notification("Grammar Generator", "An old JFlex.jar is detected", flexFiles.get(0).getAbsolutePath() + "<br>See <a href=\"" + DOC_URL + "\">" + DOC_URL + "</a>.<br><b>Compatibility note</b>: . (dot) semantics is changed, use [^] instead of .|\\n.<br><b>To update</b>: remove the old version and the global library if present.", NotificationType.INFORMATION).setListener(NotificationListener.URL_OPENING_LISTENER);
            Notifications.Bus.notify((Notification)notification, (Project)project);
        }
        final String batchId = "jflex@" + System.nanoTime();
        new Runnable(){
            final Iterator<VirtualFile> it;
            {
                this.it = files.iterator();
            }

            @Override
            public void run() {
                if (this.it.hasNext()) {
                    BnfRunJFlexAction.doGenerate(project, this.it.next(), flexFiles, batchId).doWhenProcessed((Runnable)this);
                }
            }
        }.run();
    }

    public static ActionCallback doGenerate(final @NotNull Project project, @NotNull VirtualFile flexFile, @NotNull List<File> jflex, @NotNull String batchId) {
        String lexerPackage;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Document document = fileDocumentManager.getDocument(flexFile);
        if (document == null) {
            return ActionCallback.REJECTED;
        }
        String text = document.getText();
        Matcher matcherClass = Pattern.compile("%class\\s+(\\w+)").matcher(text);
        String lexerClassName = matcherClass.find() ? matcherClass.group(1) : null;
        Matcher matcherPackage = Pattern.compile("package\\s+([^;]+);|(%%)").matcher(text);
        String string = lexerPackage = matcherPackage.find() ? StringUtil.trim((String)matcherPackage.group(1)) : null;
        if (lexerClassName == null) {
            String content = "Lexer class name option not found, use <pre>%class LexerClassName</pre>";
            FileGeneratorUtil.fail(project, flexFile, content);
            return ActionCallback.REJECTED;
        }
        try {
            final VirtualFile virtualDir = FileGeneratorUtil.getTargetDirectoryFor(project, flexFile, lexerClassName + ".java", lexerPackage, false);
            File workingDir = VfsUtilCore.virtualToIoFile((VirtualFile)flexFile).getParentFile().getAbsoluteFile();
            Sdk sdk = new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome());
            SimpleJavaParameters javaParameters = new SimpleJavaParameters();
            javaParameters.setCharset(flexFile.getCharset());
            javaParameters.setWorkingDirectory(workingDir);
            javaParameters.setJdk(sdk);
            javaParameters.setJarPath(jflex.get(0).getAbsolutePath());
            javaParameters.getVMParametersList().add("-Xmx512m");
            javaParameters.getProgramParametersList().addParametersString(StringUtil.nullize((String)((String)Options.GEN_JFLEX_ARGS.get())));
            javaParameters.getProgramParametersList().add("-skel", jflex.get(1).getAbsolutePath());
            javaParameters.getProgramParametersList().add("-d", VfsUtilCore.virtualToIoFile((VirtualFile)virtualDir).getAbsolutePath());
            javaParameters.getProgramParametersList().add(flexFile.getName());
            OSProcessHandler processHandler = javaParameters.createOSProcessHandler();
            BnfRunJFlexAction.showConsole(project, "JFlex", batchId, processHandler);
            final ActionCallback callback = new ActionCallback();
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    Runnable runnable = event.getExitCode() == 0 ? () -> ((ActionCallback)callback).setDone() : () -> ((ActionCallback)callback).setRejected();
                    ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed());
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualDir});
                }
            });
            processHandler.startNotify();
            return callback;
        }
        catch (ExecutionException ex) {
            Messages.showErrorDialog((Project)project, (String)("Unable to run JFlex\n" + ex.getLocalizedMessage()), (String)"JFlex");
            return ActionCallback.REJECTED;
        }
    }

    public static void showConsole(@NotNull Project project, @NotNull String title, @NotNull String batchId, @NotNull OSProcessHandler processHandler) {
        ConsoleView consoleView;
        MessageView messageView = MessageView.getInstance((Project)project);
        Content batchContent = null;
        Content stoppedContent = null;
        for (Content c : messageView.getContentManager().getContents()) {
            AnAction[] data = (AnAction[])c.getUserData(BATCH_ID_KEY);
            if (data == null) continue;
            if (((String)data.first).equals(batchId)) {
                batchContent = c;
                continue;
            }
            if (!((OSProcessHandler)data.second).isProcessTerminated() && !((OSProcessHandler)data.second).isProcessTerminating() || c.isPinned()) continue;
            stoppedContent = c;
        }
        Content content = (Content)ObjectUtils.chooseNotNull(batchContent, stoppedContent);
        ConsoleView consoleView2 = consoleView = content == null ? null : (ConsoleView)UIUtil.uiTraverser((Component)content.getComponent()).filter(ConsoleView.class).first();
        if (content != null && consoleView != null) {
            if (content == batchContent) {
                consoleView.print("\n\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                consoleView.clear();
            }
            BnfRunJFlexAction.attachAndActivate(project, batchId, processHandler, content, consoleView);
            return;
        }
        consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleView.getComponent(), "Center");
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        for (AnAction action : consoleView.createConsoleActions()) {
            toolbarActions.add(action);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel.add((Component)toolbar.getComponent(), "West");
        content = ContentFactory.getInstance().createContent((JComponent)panel, title, true);
        messageView.getContentManager().addContent(content);
        Disposer.register((Disposable)content, (Disposable)consoleView);
        BnfRunJFlexAction.attachAndActivate(project, batchId, processHandler, content, consoleView);
    }

    private static void attachAndActivate(@NotNull Project project, @NotNull String batchId, @NotNull OSProcessHandler processHandler, @NotNull Content content, @NotNull ConsoleView consoleView) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Messages");
        content.putUserData(BATCH_ID_KEY, (Object)Pair.create((Object)batchId, (Object)processHandler));
        consoleView.attachToProcess((ProcessHandler)processHandler);
        if (toolWindow != null) {
            toolWindow.activate(() -> toolWindow.getContentManager().setSelectedContent(content), false, false);
        }
    }

    private static List<File> getOrDownload(@NotNull Project project, String ... urls) {
        ArrayList<File> result = new ArrayList<File>();
        if (BnfRunJFlexAction.findCommunitySources(project, result, urls)) {
            return result;
        }
        if (BnfRunJFlexAction.findInProject(project, true, result, urls)) {
            return result;
        }
        if (BnfRunJFlexAction.findExistingLibrary(result, urls)) {
            return result;
        }
        if (BnfRunJFlexAction.findInProject(project, false, result, urls)) {
            return result;
        }
        String libraryName = "JFlex & idea-flex.skeleton";
        List<Pair<VirtualFile, DownloadableFileDescription>> pairs = BnfRunJFlexAction.downloadFiles(project, libraryName, urls);
        if (pairs == null) {
            return Collections.emptyList();
        }
        ApplicationManager.getApplication().runWriteAction(() -> BnfRunJFlexAction.createOrUpdateLibrary(libraryName, pairs));
        block0: for (String url : urls) {
            for (Pair<VirtualFile, DownloadableFileDescription> pair : pairs) {
                if (!Objects.equals(url, ((DownloadableFileDescription)pair.second).getDownloadUrl())) continue;
                result.add(VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)pair.first)));
                continue block0;
            }
        }
        return result;
    }

    private static boolean findCommunitySources(@NotNull Project project, List<File> result, String ... urls) {
        String communitySrc = BnfRunJFlexAction.getCommunitySrcUrl(project);
        if (communitySrc == null) {
            return false;
        }
        ArrayList<String> roots = new ArrayList<String>();
        for (String url : urls) {
            int idx = url.indexOf("/master/");
            if (idx > -1) {
                roots.add(StringUtil.trimEnd((String)communitySrc, (String)"/") + "/" + url.substring(idx + "/master/".length()));
                continue;
            }
            String file = PathUtil.getFileName((String)url);
            roots.add(PathUtil.getParentPath((String)communitySrc) + "/tools/lexer/lib/" + file);
        }
        return BnfRunJFlexAction.collectFiles(result, roots, urls);
    }

    private static boolean findInProject(@NotNull Project project, boolean forceDir, List<File> result, String ... urls) {
        ArrayList<String> roots = new ArrayList<String>();
        for (String url : urls) {
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            for (VirtualFile file : FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)ProjectScope.getAllScope((Project)project))) {
                int idx;
                String fileUrl = file.getUrl();
                if (forceDir && ((idx = url.indexOf("/master/")) <= -1 || !StringUtil.endsWithIgnoreCase((String)fileUrl, (String)url.substring(idx + "/master/".length())))) continue;
                roots.add(fileUrl);
            }
        }
        return BnfRunJFlexAction.collectFiles(result, roots, urls);
    }

    private static boolean findExistingLibrary(@NotNull List<File> result, String ... urls) {
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        for (Library library : libraryTable.getLibraries()) {
            if (!BnfRunJFlexAction.collectFiles(result, Arrays.asList(library.getUrls(OrderRootType.CLASSES)), urls)) continue;
            return true;
        }
        return false;
    }

    private static boolean collectFiles(List<File> result, List<String> roots, String ... urls) {
        block0: for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            String name = url.substring(url.lastIndexOf("/") + 1);
            for (String root : roots) {
                File file;
                String rootName = (root = StringUtil.trimEnd((String)root, (String)"!/")).substring(root.lastIndexOf("/") + 1);
                int length = StringUtil.commonPrefix((String)rootName.toLowerCase(Locale.ENGLISH), (String)name.toLowerCase(Locale.ENGLISH)).length();
                if (length < 4 || rootName.length() != length && (rootName.length() <= length || "-_.".indexOf(rootName.charAt(length)) <= -1) || !(file = new File(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)root)))).exists() || !file.isFile()) continue;
                result.add(file);
                continue block0;
            }
            if (result.size() < i) break;
        }
        if (result.size() == urls.length) {
            return true;
        }
        result.clear();
        return false;
    }

    private static List<Pair<VirtualFile, DownloadableFileDescription>> downloadFiles(@NotNull Project project, @NotNull String libraryName, String ... urls) {
        DownloadableFileService service = DownloadableFileService.getInstance();
        ArrayList<DownloadableFileDescription> descriptions = new ArrayList<DownloadableFileDescription>();
        for (String url : urls) {
            descriptions.add(service.createFileDescription(url, url.substring(url.lastIndexOf("/") + 1)));
        }
        return service.createDownloader(descriptions, libraryName).downloadWithProgress(null, project, null);
    }

    private static void createOrUpdateLibrary(@NotNull String libraryName, @NotNull List<Pair<VirtualFile, DownloadableFileDescription>> pairs) {
        LibraryTable.ModifiableModel modifiableModel;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        Library library = libraryTable.getLibraryByName(libraryName);
        if (library == null) {
            modifiableModel = libraryTable.getModifiableModel();
            library = modifiableModel.createLibrary(libraryName);
            modifiableModel.commit();
        }
        modifiableModel = library.getModifiableModel();
        for (Pair<VirtualFile, DownloadableFileDescription> pair : pairs) {
            modifiableModel.addRoot((VirtualFile)pair.first, OrderRootType.CLASSES);
        }
        modifiableModel.commit();
    }

    @Nullable
    private static String getCommunitySrcUrl(@NotNull Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Object[] jdks = ProjectJdkTable.getInstance().getAllJdks();
        for (Sdk sdk : JBIterable.of((Object)projectSdk).append(jdks).filter(Conditions.notNull())) {
            String result = BnfRunJFlexAction.getCommunitySrcUrlInner(sdk);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static String getCommunitySrcUrlInner(@NotNull Sdk projectSdk) {
        String[] sources;
        String homePath = projectSdk.getHomePath();
        String API_SCR = "/platform/lang-api/src";
        if (homePath != null) {
            for (String prefix : Arrays.asList("community", "")) {
                File file = new File(homePath, FileUtil.toSystemDependentName((String)(prefix + API_SCR)));
                if (!file.exists() || !file.isDirectory()) continue;
                return VfsUtilCore.pathToUrl((String)FileUtil.toSystemDependentName((String)(homePath + "/" + prefix)));
            }
        }
        for (String source : sources = projectSdk.getRootProvider().getUrls(OrderRootType.SOURCES)) {
            String communityPath = StringUtil.trimEnd((String)source, (String)API_SCR);
            if (communityPath.length() >= source.length()) continue;
            return communityPath;
        }
        return null;
    }
}

