/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.actions.FileGeneratorUtil;
import org.intellij.grammar.generator.ParserGenerator;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfFile;
import org.jetbrains.annotations.NotNull;

public class GenerateAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(GenerateAction.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        JBIterable<VirtualFile> files = GenerateAction.getFiles(e);
        e.getPresentation().setEnabledAndVisible(project != null && !files.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        List files = GenerateAction.getFiles(e).toList();
        if (files.isEmpty()) {
            return;
        }
        GenerateAction.doGenerate(project, files);
    }

    @NotNull
    private static JBIterable<VirtualFile> getFiles(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)));
        if (project == null || files.isEmpty()) {
            return JBIterable.empty();
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        return files.filter(o -> manager.findFile(o) instanceof BnfFile);
    }

    public static void doGenerate(final @NotNull Project project, final @NotNull List<VirtualFile> bnfFiles) {
        final LinkedHashMap rootMap = new LinkedHashMap();
        final LinkedHashMap packageMap = new LinkedHashMap();
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        PackageIndex packageIndex = PackageIndex.getInstance((Project)project);
        WriteAction.run(() -> {
            for (VirtualFile file : bnfFiles) {
                PsiFile bnfFile;
                if (!file.isValid() || !((bnfFile = psiManager.findFile(file)) instanceof BnfFile)) continue;
                String parserClass = ParserGeneratorUtil.getRootAttribute((PsiElement)bnfFile, KnownAttribute.PARSER_CLASS);
                VirtualFile target = FileGeneratorUtil.getTargetDirectoryFor(project, file, StringUtil.getShortName((String)parserClass) + ".java", StringUtil.getPackageName((String)parserClass), true);
                rootMap.put(file, target);
                packageMap.put(target, StringUtil.notNullize((String)packageIndex.getPackageNameByDirectory(target)));
            }
        });
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Parser generation", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            final List<File> files;
            final Set<VirtualFile> targets;
            int filesProcessed;
            long totalWritten;
            {
                super(arg0, arg1, arg2, arg3);
                this.files = new ArrayList<File>();
                this.targets = new LinkedHashSet<VirtualFile>();
                this.filesProcessed = 0;
                this.totalWritten = 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                long startTime = System.currentTimeMillis();
                indicator.setIndeterminate(true);
                try {
                    this.runInner(indicator);
                }
                catch (Throwable throwable) {
                    String report = String.format("%d grammars: %d files generated (%s) in %s", this.filesProcessed, this.files.size(), StringUtil.formatFileSize((long)this.totalWritten), StringUtil.formatDuration((long)(System.currentTimeMillis() - startTime)));
                    if (bnfFiles.size() > 3) {
                        Notifications.Bus.notify((Notification)new Notification("Grammar Generator", "", report, NotificationType.INFORMATION), (Project)project);
                    }
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])this.targets.toArray(VirtualFile.EMPTY_ARRAY));
                    throw throwable;
                }
                String report = String.format("%d grammars: %d files generated (%s) in %s", this.filesProcessed, this.files.size(), StringUtil.formatFileSize((long)this.totalWritten), StringUtil.formatDuration((long)(System.currentTimeMillis() - startTime)));
                if (bnfFiles.size() > 3) {
                    Notifications.Bus.notify((Notification)new Notification("Grammar Generator", "", report, NotificationType.INFORMATION), (Project)project);
                }
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])this.targets.toArray(VirtualFile.EMPTY_ARRAY));
            }

            private void runInner(ProgressIndicator indicator) {
                int l = bnfFiles.size();
                for (int i = 0; i < l; ++i) {
                    VirtualFile file = (VirtualFile)bnfFiles.get(i);
                    indicator.setFraction((double)i / (double)l);
                    indicator.setText2(file.getPath());
                    String sourcePath = file.isInLocalFileSystem() ? FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)file.getParent().getPath())) : "";
                    VirtualFile target = (VirtualFile)rootMap.get(file);
                    if (target == null) {
                        return;
                    }
                    this.targets.add(target);
                    File genDir = new File(VfsUtilCore.virtualToIoFile((VirtualFile)target).getAbsolutePath());
                    String packagePrefix = (String)packageMap.get(target);
                    long time = System.currentTimeMillis();
                    int filesCount = this.files.size();
                    Ref exRef = Ref.create();
                    try {
                        DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                            if (!file.isValid()) {
                                return;
                            }
                            PsiFile bnfFile = psiManager.findFile(file);
                            if (!(bnfFile instanceof BnfFile)) {
                                return;
                            }
                            ParserGenerator generator = new ParserGenerator((BnfFile)bnfFile, sourcePath, genDir.getPath(), packagePrefix){

                                @Override
                                protected PrintWriter openOutputInner(String className, File file) throws IOException {
                                    files.add(file);
                                    return super.openOutputInner(className, file);
                                }
                            };
                            try {
                                generator.generate();
                            }
                            catch (Exception ex) {
                                exRef.set((Object)ex);
                            }
                        });
                        if (!exRef.isNull()) {
                            throw (Exception)exRef.get();
                        }
                        long millis = System.currentTimeMillis() - time;
                        String duration = millis < 1000L ? null : StringUtil.formatDuration((long)millis);
                        long written = 0L;
                        for (File f : this.files.subList(filesCount, this.files.size())) {
                            written += f.length();
                        }
                        ++this.filesProcessed;
                        this.totalWritten += written;
                        Notifications.Bus.notify((Notification)new Notification("Grammar Generator", String.format("%s generated (%s)", file.getName(), StringUtil.formatFileSize((long)written)), "to " + genDir + (String)(duration == null ? "" : " in " + duration), NotificationType.INFORMATION), (Project)project);
                        continue;
                    }
                    catch (ProcessCanceledException millis) {
                        continue;
                    }
                    catch (Exception ex) {
                        Notifications.Bus.notify((Notification)new Notification("Grammar Generator", file.getName() + " generation failed", ExceptionUtil.getUserStackTrace((Throwable)ex, (Logger)ParserGenerator.LOG), NotificationType.ERROR), (Project)project);
                        LOG.warn((Throwable)ex);
                    }
                }
            }
        });
    }
}

