/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.config;

import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;

abstract class Option<T>
implements Getter<T> {
    public final String id;
    public final T defValue;

    Option(String id, T defValue) {
        this.id = id;
        this.defValue = defValue;
    }

    public abstract T get();

    String innerValue() {
        return System.getProperty(this.id);
    }

    static Option<Integer> intOption(String id, int def) {
        return new Option<Integer>(id, Integer.valueOf(def)){

            @Override
            public Integer get() {
                return StringUtil.parseInt((String)this.innerValue(), (int)((Integer)this.defValue));
            }
        };
    }

    static Option<String> strOption(String id, String def) {
        return new Option<String>(id, def){

            @Override
            public String get() {
                return (String)ObjectUtils.chooseNotNull((Object)this.innerValue(), (Object)((String)this.defValue));
            }
        };
    }

    static Option<Boolean> boolOption(String id, final boolean def) {
        return new Option<Boolean>(id, Boolean.valueOf(def)){

            @Override
            public Boolean get() {
                String s = this.innerValue();
                return "yes".equals(s) || "true".equals(s) || !"no".equals(s) && !"false".equals(s) && def;
            }
        };
    }
}

