/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.diagram;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.PsiDiagramNode;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Shape;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.grammar.GrammarKitBundle;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfDiagramProvider
extends DiagramProvider<BnfRule> {
    public static final String ID = "GRAMMAR";
    private final DiagramVisibilityManager myVisibilityManager = new EmptyDiagramVisibilityManager();
    private static final DiagramCategory[] CATEGORIES = new DiagramCategory[]{new DiagramCategory(GrammarKitBundle.messagePointer("diagram.category.properties", new Object[0]), PlatformIcons.PROPERTY_ICON, true, false)};
    private final DiagramElementManager<BnfRule> myElementManager = new AbstractDiagramElementManager<BnfRule>(){

        public BnfRule findInDataContext(@NotNull DataContext context) {
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (!(file instanceof BnfFile)) {
                return null;
            }
            BnfFile bnfFile = (BnfFile)file;
            List<BnfRule> rules = bnfFile.getRules();
            return rules.get(0);
        }

        public boolean isAcceptableAsNode(Object o) {
            return o instanceof PsiNamedElement;
        }

        @Nullable
        @Nls
        public String getEditorTitle(BnfRule element, @NotNull Collection<BnfRule> additionalElements) {
            PsiFile file = element == null ? null : element.getContainingFile();
            return file == null ? null : file.getName();
        }

        public String getElementTitle(BnfRule o) {
            return o.getName();
        }

        @Nullable
        public SimpleColoredText getItemName(@Nullable BnfRule element, @Nullable Object item, @NotNull DiagramBuilder builder) {
            if (item instanceof Item) {
                Item o = (Item)item;
                item = o.rule;
            }
            if (item instanceof PsiNamedElement) {
                return new SimpleColoredText(StringUtil.notNullize((String)((PsiNamedElement)item).getName()), DEFAULT_TITLE_ATTR);
            }
            return null;
        }

        public Object @NotNull [] getNodeItems(BnfRule element) {
            Map<PsiElement, RuleGraphHelper.Cardinality> map = BnfDiagramProvider.this.myGraphHelper.getFor(element);
            List entries = ContainerUtil.mapNotNull(map.entrySet(), p -> {
                Item item;
                Object patt4181$temp = p.getKey();
                if (patt4181$temp instanceof BnfRule) {
                    BnfRule o = (BnfRule)patt4181$temp;
                    item = new Item(o, (RuleGraphHelper.Cardinality)((Object)((Object)p.getValue())));
                } else {
                    item = null;
                }
                return item;
            });
            Collections.sort(entries, (o, o1) -> Comparing.compare((Comparable)((Object)o.rule.getName()), (Comparable)((Object)o1.rule.getName())));
            return entries.toArray();
        }

        @Nullable
        public SimpleColoredText getItemType(@Nullable BnfRule element, @Nullable Object item, @Nullable DiagramBuilder builder) {
            if (item == null) {
                return null;
            }
            RuleGraphHelper.Cardinality cardinality = ((Item)item).cardinality;
            String text = RuleGraphHelper.getCardinalityText(cardinality);
            if (StringUtil.isNotEmpty((String)text)) {
                return new SimpleColoredText(" " + text + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
            return null;
        }

        @Nullable
        public Icon getItemIcon(@Nullable BnfRule element, @Nullable Object item, @Nullable DiagramBuilder builder) {
            if (item == null) {
                return null;
            }
            return ((Item)item).rule.getIcon(0);
        }

        @Nullable
        @Nls
        public String getNodeTooltip(BnfRule rule) {
            return null;
        }
    };
    private final DiagramVfsResolver<BnfRule> myVfsResolver = new DiagramVfsResolver<BnfRule>(){

        public String getQualifiedName(BnfRule element) {
            VirtualFile virtualFile;
            if (element == null) {
                return null;
            }
            PsiFile psiFile = element.getContainingFile();
            VirtualFile virtualFile2 = virtualFile = psiFile == null ? null : psiFile.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            return String.format("%s?rule=%s", virtualFile.getUrl(), element.getName());
        }

        public BnfRule resolveElementByFQN(@NotNull String s, @NotNull Project project) {
            PsiFile psiFile;
            List parts = StringUtil.split((String)s, (String)"?rule=");
            if (parts.size() < 1 || parts.size() > 2) {
                return null;
            }
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)parts.get(0));
            PsiFile psiFile2 = psiFile = virtualFile == null ? null : PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (!(psiFile instanceof BnfFile)) {
                return null;
            }
            BnfFile bnfFile = (BnfFile)psiFile;
            return parts.size() == 2 ? ((BnfFile)psiFile).getRule((String)parts.get(1)) : (BnfRule)ContainerUtil.getFirstItem(bnfFile.getRules());
        }
    };
    private final DiagramRelationshipManager<BnfRule> myRelationshipManager = new DiagramRelationshipManager<BnfRule>(){

        @Nullable
        public DiagramRelationshipInfo getDependencyInfo(BnfRule rule, BnfRule t1, DiagramCategory category) {
            return null;
        }
    };
    private final DiagramExtras<BnfRule> myExtras = new DiagramExtras();
    private RuleGraphHelper myGraphHelper;

    public BnfDiagramProvider() {
        this.myElementManager.setUmlProvider((DiagramProvider)this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    @NotNull
    public String getID() {
        return ID;
    }

    @NotNull
    public DiagramVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    @NotNull
    public DiagramNodeContentManager createNodeContentManager() {
        return new BnfNodeContentManager();
    }

    @NotNull
    public DiagramElementManager<BnfRule> getElementManager() {
        return this.myElementManager;
    }

    @NotNull
    public DiagramVfsResolver<BnfRule> getVfsResolver() {
        return this.myVfsResolver;
    }

    @NotNull
    public DiagramRelationshipManager<BnfRule> getRelationshipManager() {
        return this.myRelationshipManager;
    }

    @NotNull
    public DiagramDataModel<BnfRule> createDataModel(@NotNull Project project, @Nullable BnfRule element, @Nullable VirtualFile file, @NotNull DiagramPresentationModel presentationModel) {
        return new MyDataModel(project, element == null ? null : (BnfFile)element.getContainingFile(), this);
    }

    @NotNull
    public DiagramExtras<BnfRule> getExtras() {
        return this.myExtras;
    }

    public DiagramCategory @NotNull [] getAllContentCategories() {
        return CATEGORIES;
    }

    @NotNull
    public String getActionName(boolean isPopup) {
        return GrammarKitBundle.message("diagram.action.name", new Object[0]);
    }

    @NotNull
    public String getPresentableName() {
        return GrammarKitBundle.message("diagram.presentable.name", new Object[0]);
    }

    private static class BnfNodeContentManager
    extends AbstractDiagramNodeContentManager {
        private BnfNodeContentManager() {
        }

        public boolean isInCategory(@Nullable Object nodeElement, @Nullable Object item, @NotNull DiagramCategory category, @Nullable DiagramBuilder builder) {
            return true;
        }

        public DiagramCategory @NotNull [] getContentCategories() {
            return CATEGORIES;
        }
    }

    private static class MyDataModel
    extends DiagramDataModel<BnfRule>
    implements ModificationTracker {
        private final BnfFile myFile;
        private final Collection<DiagramNode<BnfRule>> myNodes = new HashSet<DiagramNode<BnfRule>>();
        private final Collection<DiagramEdge<BnfRule>> myEdges = new HashSet<DiagramEdge<BnfRule>>();

        MyDataModel(Project project, BnfFile file, BnfDiagramProvider provider) {
            super(project, (DiagramProvider)provider);
            this.myFile = file;
        }

        @NotNull
        public Collection<DiagramNode<BnfRule>> getNodes() {
            return this.myNodes;
        }

        @NotNull
        public Collection<DiagramEdge<BnfRule>> getEdges() {
            return this.myEdges;
        }

        @NotNull
        public String getNodeName(DiagramNode<BnfRule> node) {
            return StringUtil.notNullize((String)node.getTooltip());
        }

        public DiagramNode<BnfRule> addElement(BnfRule psiElement) {
            return null;
        }

        public void refreshDataModel() {
            RuleGraphHelper ruleGraphHelper;
            this.myNodes.clear();
            this.myEdges.clear();
            ((BnfDiagramProvider)this.getProvider()).myGraphHelper = ruleGraphHelper = RuleGraphHelper.getCached(this.myFile);
            HashMap<BnfRule, 1> nodeMap = new HashMap<BnfRule, 1>();
            List<BnfRule> rules = this.myFile.getRules();
            BnfRule root = (BnfRule)ContainerUtil.getFirstItem(rules);
            for (BnfRule rule : rules) {
                if (rule != root && !RuleGraphHelper.hasPsiClass(rule)) continue;
                PsiDiagramNode<BnfRule> diagramNode = new PsiDiagramNode<BnfRule>(rule, this.getProvider()){

                    public String getTooltip() {
                        return ((BnfRule)this.getIdentifyingElement()).getName();
                    }
                };
                nodeMap.put(rule, diagramNode);
                this.myNodes.add((DiagramNode<BnfRule>)diagramNode);
            }
            for (BnfRule rule : rules) {
                if (rule != root && !RuleGraphHelper.hasPsiClass(rule)) continue;
                Map<PsiElement, RuleGraphHelper.Cardinality> map = ruleGraphHelper.getFor(rule);
                BnfRule superRule = this.myFile.getRule(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTENDS));
                if (superRule != null) {
                    DiagramNode source = (DiagramNode)nodeMap.get(rule);
                    DiagramNode target = (DiagramNode)nodeMap.get(superRule);
                    if (source == null || target == null) continue;
                    this.myEdges.add((DiagramEdge<BnfRule>)new DiagramEdgeBase<BnfRule>(source, target, (DiagramRelationshipInfo)new DiagramRelationshipInfoAdapter("EXTENDS", DiagramLineType.DASHED, "extends"){

                        public Shape getStartArrow() {
                            return DELTA;
                        }
                    }){

                        @NotNull
                        public String getName() {
                            return "";
                        }
                    });
                }
                for (final PsiElement element : map.keySet()) {
                    if (!(element instanceof BnfRule)) continue;
                    final RuleGraphHelper.Cardinality cardinality = map.get(element);
                    assert (cardinality != RuleGraphHelper.Cardinality.NONE);
                    DiagramNode source = (DiagramNode)nodeMap.get(rule);
                    DiagramNode target = (DiagramNode)nodeMap.get(element);
                    if (source == null || target == null) continue;
                    this.myEdges.add((DiagramEdge<BnfRule>)new DiagramEdgeBase<BnfRule>(source, target, (DiagramRelationshipInfo)new DiagramRelationshipInfoAdapter("CONTAINS", DiagramLineType.SOLID, ""){

                        public DiagramRelationshipInfo.Label getUpperCenterLabel() {
                            return new DiagramRelationshipInfoAdapter.ColoredLabel(StringUtil.toLowerCase((String)cardinality.name()));
                        }

                        public Shape getStartArrow() {
                            return DELTA;
                        }
                    }){

                        public Object getSourceAnchor() {
                            return element;
                        }

                        public Object getTargetAnchor() {
                            return element;
                        }

                        public Color getAnchorColor() {
                            return JBColor.BLUE;
                        }

                        @NotNull
                        public String getName() {
                            return "";
                        }
                    });
                }
            }
        }

        @NotNull
        public ModificationTracker getModificationTracker() {
            return this;
        }

        public void dispose() {
        }

        public long getModificationCount() {
            return this.myFile.getModificationStamp();
        }
    }

    private record Item(BnfRule rule, RuleGraphHelper.Cardinality cardinality) {
    }
}

