/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.editor;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.FunctionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfRecursionLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof BnfRule)) continue;
            BnfRule rule = (BnfRule)psiElement;
            ProgressManager.checkCanceled();
            RuleGraphHelper helper = RuleGraphHelper.getCached((BnfFile)rule.getContainingFile());
            Map<PsiElement, RuleGraphHelper.Cardinality> map = helper.getFor(rule);
            if (!map.containsKey(rule)) continue;
            result.add(new MyMarkerInfo(rule.getId()));
        }
    }

    private static class MyMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private MyMarkerInfo(@NotNull PsiElement id) {
            super(id, id.getTextRange(), AllIcons.Gutter.RecursiveMethod, FunctionUtil.constant((Object)"Recursive rule"), null, GutterIconRenderer.Alignment.RIGHT, () -> "Recursive rule");
        }

        public GutterIconRenderer createGutterRenderer() {
            if (this.myIcon == null) {
                return null;
            }
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }
    }
}

