/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.editor;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.intellij.grammar.BnfIcons;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.java.JavaHelper;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfRuleLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        HashSet<NavigatablePsiElement> visited = forNavigation ? new HashSet<NavigatablePsiElement>() : null;
        for (PsiElement psiElement : elements) {
            BnfRule rule;
            boolean isRuleId;
            PsiElement parent = psiElement.getParent();
            boolean bl = isRuleId = parent instanceof BnfRule && (forNavigation || psiElement == ((BnfRule)parent).getId());
            if (!isRuleId && (!forNavigation || !(psiElement instanceof BnfExpression))) continue;
            ArrayList<NavigatablePsiElement> items = new ArrayList<NavigatablePsiElement>();
            NavigatablePsiElement method = BnfRuleLineMarkerProvider.getMethod(psiElement);
            if (method != null && (!forNavigation || visited.add(method))) {
                items.add(method);
            }
            boolean hasPSI = false;
            if (isRuleId && RuleGraphHelper.hasPsiClass(rule = RuleGraphHelper.getSynonymTargetOrSelf((BnfRule)parent))) {
                hasPSI = true;
                JavaHelper javaHelper = JavaHelper.getJavaHelper(rule);
                Couple<String> names = ParserGeneratorUtil.getQualifiedRuleClassName(rule);
                for (String className : new String[]{(String)names.first, (String)names.second}) {
                    NavigatablePsiElement aClass = javaHelper.findClass(className);
                    if (aClass == null || forNavigation && !visited.add(aClass)) continue;
                    items.add(aClass);
                }
            }
            if (items.isEmpty()) continue;
            AnAction action = ActionManager.getInstance().getAction("GotoRelated");
            Object tooltipAd = "";
            Object popupTitleAd = "";
            if (action != null) {
                String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                String actionText = StringUtil.isEmpty((String)shortcutText) ? "'" + action.getTemplatePresentation().getText() + "' action" : shortcutText;
                tooltipAd = "\nGo to sub-expression code via " + actionText;
                popupTitleAd = " (for sub-expressions use " + actionText + ")";
            }
            String title = "parser " + (hasPSI ? "and PSI " : "") + "code";
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)BnfIcons.RELATED_METHOD).setTargets(items).setTooltipText("Click to navigate to " + title + (String)tooltipAd).setPopupTitle(StringUtil.capitalize((String)title) + (String)popupTitleAd);
            result.add(builder.createLineMarkerInfo(psiElement));
        }
    }

    @Nullable
    private static NavigatablePsiElement getMethod(PsiElement element) {
        BnfRule rule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)element, BnfRule.class);
        if (rule == null) {
            return null;
        }
        String parserClass = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.PARSER_CLASS);
        if (StringUtil.isEmpty((String)parserClass)) {
            return null;
        }
        JavaHelper helper = JavaHelper.getJavaHelper(element);
        List<NavigatablePsiElement> methods = helper.findClassMethods(parserClass, JavaHelper.MethodType.STATIC, GrammarUtil.getMethodName(rule, element), -1, new String[0]);
        return (NavigatablePsiElement)ContainerUtil.getFirstItem(methods);
    }
}

