/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.editor;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.intellij.grammar.BnfParserDefinition;
import org.intellij.grammar.parser.BnfLexer;
import org.intellij.grammar.psi.BnfTypes;
import org.jetbrains.annotations.NotNull;

class BnfSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey ILLEGAL = TextAttributesKey.createTextAttributesKey((String)"BNF_ILLEGAL", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    public static final TextAttributesKey COMMENT = TextAttributesKey.createTextAttributesKey((String)"BNF_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"BNF_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey PATTERN = TextAttributesKey.createTextAttributesKey((String)"BNF_PATTERN", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"BNF_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"BNF_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.MARKUP_ATTRIBUTE);
    public static final TextAttributesKey TOKEN = TextAttributesKey.createTextAttributesKey((String)"BNF_TOKEN", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey RULE = TextAttributesKey.createTextAttributesKey((String)"BNF_RULE", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey META_RULE = TextAttributesKey.createTextAttributesKey((String)"BNF_META_RULE", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey META_PARAM = TextAttributesKey.createTextAttributesKey((String)"BNF_META_RULE_PARAM");
    public static final TextAttributesKey ATTRIBUTE = TextAttributesKey.createTextAttributesKey((String)"BNF_ATTRIBUTE", (TextAttributesKey)DefaultLanguageHighlighterColors.INTERFACE_NAME);
    public static final TextAttributesKey EXTERNAL = TextAttributesKey.createTextAttributesKey((String)"BNF_EXTERNAL", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_METHOD);
    public static final TextAttributesKey PARENTHS = TextAttributesKey.createTextAttributesKey((String)"BNF_PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey BRACES = TextAttributesKey.createTextAttributesKey((String)"BNF_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey BRACKETS = TextAttributesKey.createTextAttributesKey((String)"BNF_BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey ANGLES = TextAttributesKey.createTextAttributesKey((String)"BNF_ANGLES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey OP_SIGN = TextAttributesKey.createTextAttributesKey((String)"BNF_OP_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey RECOVER_MARKER = TextAttributesKey.createTextAttributesKey((String)"BNF_RECOVER_MARKER");
    public static final TextAttributesKey PIN_MARKER = TextAttributesKey.createTextAttributesKey((String)"BNF_PIN", (TextAttributes)new TextAttributes(null, null, DefaultLanguageHighlighterColors.LINE_COMMENT.getDefaultAttributes().getForegroundColor(), EffectType.BOLD_DOTTED_LINE, 0));

    BnfSyntaxHighlighter() {
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new BnfLexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType type) {
        if (type == TokenType.BAD_CHARACTER) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)ILLEGAL);
        }
        if (type == BnfParserDefinition.BNF_LINE_COMMENT || type == BnfParserDefinition.BNF_BLOCK_COMMENT) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)COMMENT);
        }
        if (type == BnfTypes.BNF_STRING) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)STRING);
        }
        if (type == BnfTypes.BNF_NUMBER) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)NUMBER);
        }
        if (type == BnfTypes.BNF_OP_ONEMORE || type == BnfTypes.BNF_OP_AND || type == BnfTypes.BNF_OP_EQ || type == BnfTypes.BNF_OP_IS || type == BnfTypes.BNF_OP_NOT || type == BnfTypes.BNF_OP_OPT || type == BnfTypes.BNF_OP_OR || type == BnfTypes.BNF_OP_ZEROMORE) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)OP_SIGN);
        }
        if (type == BnfTypes.BNF_LEFT_PAREN || type == BnfTypes.BNF_RIGHT_PAREN) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)PARENTHS);
        }
        if (type == BnfTypes.BNF_LEFT_BRACE || type == BnfTypes.BNF_RIGHT_BRACE) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)BRACES);
        }
        if (type == BnfTypes.BNF_LEFT_BRACKET || type == BnfTypes.BNF_RIGHT_BRACKET) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)BRACKETS);
        }
        if (type == BnfTypes.BNF_EXTERNAL_START || type == BnfTypes.BNF_EXTERNAL_END) {
            return BnfSyntaxHighlighter.pack((TextAttributesKey)ANGLES);
        }
        return TextAttributesKey.EMPTY_ARRAY;
    }
}

