/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.intellij.grammar.analysis.BnfFirstNextAnalyzer;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfParenExpression;
import org.intellij.grammar.psi.BnfQuantified;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionHelper {
    private final BnfFile myFile;
    private final RuleGraphHelper myRuleGraph;
    private final Consumer<String> myWarningConsumer;
    private final Map<BnfRule, ExpressionInfo> myExpressionMap = new HashMap<BnfRule, ExpressionInfo>();
    private final Map<BnfRule, BnfRule> myRootRulesMap = new HashMap<BnfRule, BnfRule>();
    private static final Key<CachedValue<ExpressionHelper>> EXPRESSION_HELPER_KEY = Key.create((String)"EXPRESSION_HELPER_KEY");
    private static final Key<List<BnfExpression>> ORIGINAL_EXPRESSIONS = Key.create((String)"ORIGINAL_EXPRESSIONS");

    public static ExpressionHelper getCached(@NotNull BnfFile file) {
        CachedValue value = (CachedValue)file.getUserData(EXPRESSION_HELPER_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)new ExpressionHelper(file, RuleGraphHelper.getCached(file), null), new Object[]{file}), false);
            file.putUserData(EXPRESSION_HELPER_KEY, value);
        }
        return (ExpressionHelper)value.getValue();
    }

    public ExpressionHelper(BnfFile file, RuleGraphHelper ruleGraph, @Nullable Consumer<String> warningConsumer) {
        this.myFile = file;
        this.myRuleGraph = ruleGraph;
        this.myWarningConsumer = warningConsumer;
        this.buildExpressionRules();
    }

    public void addWarning(String text) {
        if (this.myWarningConsumer == null) {
            return;
        }
        this.myWarningConsumer.accept(text);
    }

    public ExpressionInfo getExpressionInfo(BnfRule rule) {
        ExpressionInfo info;
        BnfRule root = this.myRootRulesMap.get(rule);
        ExpressionInfo expressionInfo = info = root == null ? null : this.myExpressionMap.get(root);
        if (info == null) {
            return null;
        }
        if (info.rootRule == rule || ParserGeneratorUtil.Rule.isPrivate(rule)) {
            return info;
        }
        return info.priorityMap.containsKey(rule) ? info : null;
    }

    private void buildExpressionRules() {
        BnfFirstNextAnalyzer analyzer = BnfFirstNextAnalyzer.createAnalyzer(false);
        for (BnfRule rule : this.myFile.getRules()) {
            Map<PsiElement, RuleGraphHelper.Cardinality> contentRules;
            if (ParserGeneratorUtil.Rule.isPrivate(rule) || ParserGeneratorUtil.Rule.isFake(rule) || this.myRootRulesMap.containsKey(rule) || !(contentRules = this.myRuleGraph.getFor(rule)).isEmpty() || !BnfFirstNextAnalyzer.asStrings(analyzer.calcFirst(rule)).contains(rule.getName())) continue;
            ExpressionInfo expressionInfo = new ExpressionInfo(rule);
            this.addToPriorityMap(rule, this.myRuleGraph.getExtendsRules(rule), expressionInfo);
            List<BnfRule> rules = ParserGeneratorUtil.topoSort(expressionInfo.priorityMap.keySet(), this.myRuleGraph);
            for (BnfRule r : rules) {
                this.buildOperatorMap(r, rule, expressionInfo);
            }
            if (!expressionInfo.priorityMap.isEmpty()) {
                this.myRootRulesMap.put(rule, rule);
                this.myExpressionMap.put(rule, expressionInfo);
            }
            block2: for (OperatorInfo info : expressionInfo.operatorMap.values()) {
                Map<PsiElement, RuleGraphHelper.Cardinality> map = this.myRuleGraph.collectMembers(info.rule, info.operator, new HashSet<Object>());
                for (RuleGraphHelper.Cardinality c : map.values()) {
                    if (c.optional()) continue;
                    continue block2;
                }
                expressionInfo.checkEmpty.add(info);
            }
        }
    }

    private void addToPriorityMap(BnfRule rule, Collection<BnfRule> rulesCluster, ExpressionInfo info) {
        JBTreeTraverser traverser = new JBTreeTraverser(o -> (Iterable)ObjectUtils.notNull(rule == o || ParserGeneratorUtil.Rule.isPrivate(o) ? this.myRuleGraph.getSubRules((BnfRule)o) : null, Collections.emptyList()));
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)((JBTreeTraverser)traverser.withRoot((Object)rule)).unique()).traverse().skip(1).typedIterator();
        while (it.hasNext()) {
            int priority;
            Integer groupPriority;
            BnfRule subRule = (BnfRule)it.next();
            if (info.priorityMap.containsKey(subRule)) {
                this.addWarning(String.format("'%s' priority is calculated twice", subRule.getName()));
                continue;
            }
            BnfRule prev = this.myRootRulesMap.put(subRule, info.rootRule);
            if (prev != null) {
                this.addWarning(String.format("''%s' is in several expression hierarchies: %s and %s", subRule.getName(), prev.getName(), info.rootRule.getName()));
            }
            if ((groupPriority = info.privateGroups.get(it.parent())) == null) {
                int n = info.nextPriority;
                v1 = n;
                info.nextPriority = n + 1;
            } else {
                v1 = priority = groupPriority.intValue();
            }
            if (rulesCluster.contains(subRule)) {
                if (ParserGeneratorUtil.Rule.isPrivate(subRule) && this.myRuleGraph.getFor(subRule).isEmpty()) continue;
                info.priorityMap.put(subRule, priority);
                continue;
            }
            if (ParserGeneratorUtil.Rule.isPrivate(subRule)) {
                info.privateGroups.put(subRule, priority);
                continue;
            }
            this.addWarning(String.format("'%s' is not an expression rule nor private priority group", subRule.getName()));
        }
    }

    private void buildOperatorMap(BnfRule rule, BnfRule rootRule, ExpressionInfo expressionInfo) {
        OperatorInfo info;
        Map<PsiElement, RuleGraphHelper.Cardinality> ruleContent = this.myRuleGraph.getFor(rule);
        RuleGraphHelper.Cardinality cardinality = ruleContent.get(rootRule);
        BnfRule rootRuleSubst = rootRule;
        if (cardinality == null) {
            Collection<BnfRule> extendsRules = this.myRuleGraph.getExtendsRules(rootRule);
            JBIterable tryOtherRules = JBIterable.from(ruleContent.keySet()).filter(BnfRule.class).filter(extendsRules::contains).append((Iterable)ParserGeneratorUtil.getSuperRules(this.myFile, rootRule).filter(Conditions.notNull()));
            for (BnfRule r : tryOtherRules) {
                cardinality = ruleContent.get(r);
                if (cardinality == null) continue;
                rootRuleSubst = r;
                break;
            }
        }
        if (ParserGeneratorUtil.Rule.isExternal(rule)) {
            BnfExpression expression = (BnfExpression)ContainerUtil.getFirstItem(ruleContent.keySet());
            expressionInfo.operatorMap.put(rule, new OperatorInfo(rule, OperatorType.ATOM, expression, null));
            return;
        }
        String rootRuleName = rootRule.getName();
        List<BnfExpression> childExpressions = ParserGeneratorUtil.getChildExpressions(rule.getExpression());
        if (cardinality == null) {
            info = new OperatorInfo(rule, OperatorType.ATOM, rule.getExpression(), null);
        } else if (childExpressions.size() < 2) {
            this.addWarning("invalid expression definition for " + rule + ": 2 or more arguments expected");
            info = new OperatorInfo(rule, OperatorType.ATOM, rule.getExpression(), null);
        } else if (cardinality == RuleGraphHelper.Cardinality.REQUIRED) {
            int index = this.indexOf(rootRuleSubst, 0, childExpressions, expressionInfo);
            BnfRule arg1 = this.substRule(childExpressions, index, rootRule);
            if (index == 0) {
                info = new OperatorInfo(rule, OperatorType.POSTFIX, ExpressionHelper.combine(childExpressions.subList(1, childExpressions.size())), null, arg1, null);
            } else if (index == -1) {
                this.addWarning(rule + ": " + rootRuleName + " reference not found, treating as ATOM");
                info = new OperatorInfo(rule, OperatorType.ATOM, rule.getExpression(), null);
            } else {
                info = new OperatorInfo(rule, OperatorType.PREFIX, ExpressionHelper.combine(childExpressions.subList(0, index)), ExpressionHelper.combine(childExpressions.subList(index + 1, childExpressions.size())), arg1, null);
            }
        } else if (cardinality == RuleGraphHelper.Cardinality.AT_LEAST_ONE) {
            int index1 = this.indexOf(rootRuleSubst, 0, childExpressions, expressionInfo);
            int index2 = this.indexOf(rootRuleSubst, 1, childExpressions, expressionInfo);
            if (index1 != 0) {
                this.addWarning(rule + ": binary or n-ary expression cannot have prefix, treating as ATOM");
                info = new OperatorInfo(rule, OperatorType.ATOM, rule.getExpression(), null);
            } else if (index2 == 1) {
                this.addWarning(rule + ": binary expression needs operator, treating as ATOM");
                info = new OperatorInfo(rule, OperatorType.ATOM, rule.getExpression(), null);
            } else {
                BnfRule arg1 = this.substRule(childExpressions, index1, rootRule);
                if (index2 == -1) {
                    BnfExpression lastExpression = childExpressions.get(1);
                    boolean badNAry = childExpressions.size() != 2 || !(lastExpression instanceof BnfQuantified) || !((BnfQuantified)lastExpression).getQuantifier().getText().equals("+") || !(((BnfQuantified)lastExpression).getExpression() instanceof BnfParenExpression);
                    List<BnfExpression> childExpressions2 = badNAry ? Collections.emptyList() : ParserGeneratorUtil.getChildExpressions(((BnfParenExpression)((BnfQuantified)lastExpression).getExpression()).getExpression());
                    int index3 = this.indexOf(rootRuleSubst, 0, childExpressions2, expressionInfo);
                    if (badNAry || index3 == -1) {
                        this.addWarning(rule + ": '" + rootRuleName + " ( <op> " + rootRuleName + ") +' expected for N-ary operator, treating as POSTFIX");
                        info = new OperatorInfo(rule, OperatorType.POSTFIX, ExpressionHelper.combine(childExpressions.subList(1, childExpressions.size())), null, arg1, null);
                    } else {
                        BnfRule arg2 = this.substRule(childExpressions2, index3, rootRule);
                        info = new OperatorInfo(rule, OperatorType.N_ARY, ExpressionHelper.combine(childExpressions2.subList(0, index3)), ExpressionHelper.combine(childExpressions2.subList(index3 + 1, childExpressions2.size())), arg1, arg2);
                    }
                } else {
                    BnfRule arg2 = this.substRule(childExpressions, index2, rootRule);
                    info = new OperatorInfo(rule, OperatorType.BINARY, ExpressionHelper.combine(childExpressions.subList(index1 + 1, index2)), ExpressionHelper.combine(childExpressions.subList(index2 + 1, childExpressions.size())), arg1, arg2);
                }
            }
        } else {
            this.addWarning(rule + ": unexpected cardinality " + cardinality + " of " + rootRuleName + ", treating as ATOM");
            info = new OperatorInfo(rule, OperatorType.ATOM, rule.getExpression(), null);
        }
        expressionInfo.operatorMap.put(rule, info);
    }

    @Nullable
    private BnfRule substRule(List<BnfExpression> list, int idx, BnfRule rootRule) {
        if (idx < 0) {
            return null;
        }
        BnfRule rule = this.myFile.getRule(list.get(idx).getText());
        return rule == rootRule ? null : rule;
    }

    private static BnfExpression combine(List<BnfExpression> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        Project project = list.get(0).getProject();
        String text = StringUtil.join(list, PsiElement::getText, (String)" ");
        BnfExpression result = BnfElementFactory.createExpressionFromText(project, text);
        result.putUserData(ORIGINAL_EXPRESSIONS, list);
        return result;
    }

    @NotNull
    public static List<BnfExpression> getOriginalExpressions(BnfExpression expression) {
        List<BnfExpression> data = (List<BnfExpression>)expression.getUserData(ORIGINAL_EXPRESSIONS);
        return data == null ? Collections.singletonList(expression) : data;
    }

    @NotNull
    public RuleGraphHelper.Cardinality fixCardinality(BnfRule rule, PsiElement tree, RuleGraphHelper.Cardinality type) {
        OperatorInfo operatorInfo;
        if (type.optional()) {
            return type;
        }
        ExpressionInfo info = this.getExpressionInfo(rule);
        OperatorInfo operatorInfo2 = operatorInfo = info == null ? null : info.operatorMap.get(rule);
        if (operatorInfo == null || operatorInfo.type == OperatorType.ATOM) {
            return type;
        }
        if ((operatorInfo.type == OperatorType.BINARY || operatorInfo.type == OperatorType.N_ARY || operatorInfo.type == OperatorType.POSTFIX) && ObjectUtils.chooseNotNull((Object)operatorInfo.arg1, (Object)info.rootRule) == tree || this.isRealAncestor(rule, operatorInfo.operator, tree)) {
            return type;
        }
        return type.and(RuleGraphHelper.Cardinality.OPTIONAL);
    }

    private boolean isRealAncestor(BnfRule rule, BnfExpression expression, PsiElement target) {
        List<BnfExpression> list = ExpressionHelper.getOriginalExpressions(expression);
        if (list.size() == 1 && PsiTreeUtil.isAncestor((PsiElement)list.get(0), (PsiElement)target, (boolean)false)) {
            return true;
        }
        for (BnfExpression expr : list) {
            Map<PsiElement, RuleGraphHelper.Cardinality> map = this.myRuleGraph.collectMembers(rule, expr, new LinkedHashSet<Object>());
            if (!map.containsKey(target)) continue;
            return true;
        }
        return false;
    }

    private int indexOf(BnfRule rootRule, int startIndex, List<BnfExpression> childExpressions, ExpressionInfo expressionInfo) {
        Collection<BnfRule> extendsRules = this.myRuleGraph.getExtendsRules(rootRule);
        int childExpressionsSize = childExpressions.size();
        for (int i = startIndex; i < childExpressionsSize; ++i) {
            BnfRule rule = this.myFile.getRule(childExpressions.get(i).getText());
            if (rootRule != rule && !extendsRules.contains(rule) && !expressionInfo.privateGroups.containsKey(rule)) continue;
            return i;
        }
        return -1;
    }

    public static class ExpressionInfo {
        public final BnfRule rootRule;
        public final Map<BnfRule, Integer> priorityMap = new LinkedHashMap<BnfRule, Integer>();
        public final Map<BnfRule, OperatorInfo> operatorMap = new LinkedHashMap<BnfRule, OperatorInfo>();
        public final Map<BnfRule, Integer> privateGroups = new HashMap<BnfRule, Integer>();
        public int nextPriority;
        public final Set<OperatorInfo> checkEmpty = new HashSet<OperatorInfo>();

        public ExpressionInfo(BnfRule rootRule) {
            this.rootRule = rootRule;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Expression root: " + this.rootRule.getName());
            sb.append("\nOperator priority table:\n");
            return this.dumpPriorityTable(sb).toString();
        }

        public StringBuilder dumpPriorityTable(StringBuilder sb) {
            return this.dumpPriorityTable(sb, (PairConsumer<? super StringBuilder, ? super OperatorInfo>)((PairConsumer)StringBuilder::append));
        }

        public StringBuilder dumpPriorityTable(StringBuilder sb, PairConsumer<? super StringBuilder, ? super OperatorInfo> printer) {
            for (int i = 0; i < this.nextPriority; ++i) {
                sb.append(i).append(":");
                int count = 0;
                for (BnfRule rule : this.priorityMap.keySet()) {
                    if (this.priorityMap.get(rule) != i) continue;
                    if (count++ % 4 == 0 && count > 1) {
                        sb.append("\n  ");
                    }
                    sb.append(" ");
                    printer.consume((Object)sb, (Object)this.operatorMap.get(rule));
                }
                sb.append("\n");
            }
            return sb;
        }

        public int getPriority(BnfRule subRule) {
            if (subRule == this.rootRule) {
                return 0;
            }
            Integer op = this.priorityMap.get(subRule);
            if (op != null) {
                return op;
            }
            Integer group = this.privateGroups.get(subRule);
            return group == null ? -1 : group;
        }
    }

    public static class OperatorInfo {
        public final BnfRule rule;
        public final OperatorType type;
        public final BnfExpression operator;
        public final BnfExpression tail;
        public final BnfRule arg1;
        public final BnfRule arg2;

        public OperatorInfo(BnfRule rule, OperatorType type, BnfExpression operator, BnfExpression tail) {
            this(rule, type, operator, tail, null, null);
        }

        public OperatorInfo(BnfRule rule, OperatorType type, BnfExpression operator, BnfExpression tail, @Nullable BnfRule arg1, @Nullable BnfRule arg2) {
            if (operator == null) {
                throw new AssertionError((Object)(rule + ": operator must not be null"));
            }
            this.rule = rule;
            this.type = type;
            this.operator = operator;
            this.tail = tail;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public String toString() {
            return this.type + "(" + this.rule.getName() + ")";
        }
    }

    public static enum OperatorType {
        ATOM,
        PREFIX,
        POSTFIX,
        BINARY,
        N_ARY;

    }
}

