/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameShortener {
    public static final String TYPE_TEXT_SEPARATORS = "<>,[]()@\" \n";
    private final String myPackage;
    private final boolean myEnabled;
    private final Set<String> myImports = new LinkedHashSet<String>();

    public NameShortener(String packageName, boolean enabled) {
        this.myPackage = packageName;
        this.myEnabled = enabled;
    }

    public Set<String> getImports() {
        return Collections.unmodifiableSet(this.myImports);
    }

    public void addImports(Collection<String> initialImports, Collection<String> includedClasses) {
        if (!this.myEnabled) {
            return;
        }
        for (String item : initialImports) {
            boolean isStatic = false;
            for (Object s : StringUtil.tokenize((String)item.replaceAll("\\s+", " "), (String)TYPE_TEXT_SEPARATORS)) {
                s = StringUtil.trimStart((String)StringUtil.trimStart((String)s, (String)"? super "), (String)"? extends ");
                boolean wasStatic = isStatic;
                isStatic = "static".equals(s);
                if (!((String)s).contains(".") || !((String)s).equals(this.shorten((String)s)) || this.myPackage.equals(StringUtil.getPackageName((String)s)) || includedClasses.contains(StringUtil.getShortName((String)s))) continue;
                if (wasStatic) {
                    s = "static " + (String)s;
                }
                this.myImports.add((String)s);
            }
        }
    }

    @NotNull
    public String shorten(String s) {
        if (!this.myEnabled) {
            return s;
        }
        boolean changed = false;
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        int offset = 0;
        int len = s.length();
        boolean vararg = s.endsWith("...");
        for (String part : StringUtil.tokenize((StringTokenizer)new StringTokenizer(StringUtil.trimEnd((String)s, (String)"..."), TYPE_TEXT_SEPARATORS, true))) {
            String pkg;
            if (TYPE_TEXT_SEPARATORS.contains(part) || "?".equals(part) || "extends".equals(part) || "super".equals(part)) {
                if ("\"".equals(part) && offset > 0 && s.indexOf(offset - 1) != 92) {
                    quoted = !quoted;
                }
                sb.append(part);
                if (",".equals(part) && offset < len && !Character.isWhitespace(s.charAt(offset + 1))) {
                    sb.append(" ");
                }
            } else if (!quoted && (this.myImports.contains(part) || "java.lang".equals(pkg = StringUtil.getPackageName((String)part)) || this.myPackage.equals(pkg) || this.myImports.contains(pkg + ".*") || part.endsWith(".") && this.myImports.contains(NameShortener.getAnnotatedFQNAt(s, offset)))) {
                sb.append(StringUtil.getShortName((String)part));
                changed = true;
            } else {
                sb.append(part);
            }
            offset += part.length();
        }
        return changed ? sb.append(vararg ? "..." : "").toString() : s;
    }

    @Nullable
    private static String getAnnotatedFQNAt(@NotNull String s, int offset) {
        Ref result = Ref.create();
        NameShortener.addTypeToImports(s.substring(offset), arg_0 -> ((Ref)result).set(arg_0), 0);
        return (String)result.get();
    }

    public static void addTypeToImports(@Nullable String type, @NotNull List<String> typeAnnotations, @NotNull Collection<String> result) {
        NameShortener.addTypeToImports(type, result::add, -1);
        for (String anno : typeAnnotations) {
            if (anno.startsWith("kotlin.")) continue;
            NameShortener.addTypeToImports(anno, result::add, -1);
        }
    }

    private static void addTypeToImports(@Nullable String s, @NotNull Consumer<String> result, int forcedOffset) {
        if (s == null) {
            return;
        }
        boolean quoted = false;
        int offset = 0;
        int parenCount = 0;
        ArrayDeque<int[]> prefixStack = null;
        for (String part : StringUtil.tokenize((StringTokenizer)new StringTokenizer(StringUtil.trimEnd((String)s, (String)"..."), TYPE_TEXT_SEPARATORS, true))) {
            int[] prefix;
            if (TYPE_TEXT_SEPARATORS.contains(part) || "?".equals(part) || "extends".equals(part) || "super".equals(part)) {
                if ("\"".equals(part) && offset > 0 && s.indexOf(offset - 1) != 92) {
                    boolean bl = quoted = !quoted;
                }
                if (!quoted && "(".equals(part)) {
                    ++parenCount;
                }
                if (!quoted && ")".equals(part)) {
                    --parenCount;
                }
            } else if (!quoted && part.endsWith(".")) {
                if (prefixStack == null) {
                    prefixStack = new ArrayDeque<int[]>();
                }
                if ((idx = s.indexOf(64, offset)) != -1 && part.equals(s.substring(offset, idx).trim())) {
                    prefixStack.push(new int[]{parenCount, offset, offset + part.length(), idx});
                }
            } else if (!quoted && prefixStack != null && !prefixStack.isEmpty() && parenCount == (prefix = (int[])prefixStack.peek())[0] && s.substring(prefix[3] + 1, offset).trim().length() > 0) {
                prefixStack.pop();
                if (forcedOffset == -1 || prefix[1] == forcedOffset) {
                    idx = part.indexOf(46);
                    result.accept(s.substring(prefix[1], prefix[2]) + (idx == -1 ? part : part.substring(0, idx)));
                    if (prefix[1] == forcedOffset) {
                        return;
                    }
                }
            } else if (!quoted && part.contains(".") && (forcedOffset == -1 || offset == forcedOffset)) {
                result.accept(part);
                if (offset == forcedOffset) {
                    return;
                }
            }
            offset += part.length();
        }
    }

    @NotNull
    public static String getRawClassName(@NotNull String name) {
        return name.indexOf("<") < name.indexOf(">") ? name.substring(0, name.indexOf("<")) : name;
    }
}

