/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import it.unimi.dsi.fastutil.Hash;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.Case;
import org.intellij.grammar.generator.NameShortener;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.java.JavaHelper;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfListEntry;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfModifier;
import org.intellij.grammar.psi.BnfParenExpression;
import org.intellij.grammar.psi.BnfParenOptExpression;
import org.intellij.grammar.psi.BnfParenthesized;
import org.intellij.grammar.psi.BnfPredicate;
import org.intellij.grammar.psi.BnfQuantified;
import org.intellij.grammar.psi.BnfQuantifier;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.BnfValueList;
import org.intellij.grammar.psi.BnfVisitor;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParserGeneratorUtil {
    private static final String RESERVED_SUFFIX = "_$";
    private static final Set<String> JAVA_RESERVED = ContainerUtil.set((Object[])new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "continue"});
    private static final Hash.Strategy<PsiElement> TEXT_STRATEGY = new Hash.Strategy<PsiElement>(){

        public int hashCode(PsiElement e) {
            return e == null ? 0 : e.getText().hashCode();
        }

        public boolean equals(PsiElement e1, PsiElement e2) {
            return e1 == null ? e2 == null : e2 != null && Objects.equals(e1.getText(), e2.getText());
        }
    };

    @NotNull
    public static <T extends Enum<T>> T enumFromString(@Nullable String value, @NotNull T def) {
        try {
            return value == null ? def : Enum.valueOf(def.getDeclaringClass(), Case.UPPER.apply(value).replace('-', '_'));
        }
        catch (Exception e) {
            return def;
        }
    }

    public static <T> T getGenerateOption(@NotNull PsiElement node, @NotNull KnownAttribute<T> attribute, @NotNull Map<String, String> genOptions, String ... genOptionKeys) {
        int value;
        String currentValue = (String)JBIterable.of((Object[])genOptionKeys).map(genOptions::get).filter(Objects::nonNull).first();
        if (attribute.getDefaultValue() instanceof Boolean) {
            if ("yes".equals(currentValue)) {
                return (T)Boolean.TRUE;
            }
            if ("no".equals(currentValue)) {
                return (T)Boolean.FALSE;
            }
        } else if (attribute.getDefaultValue() instanceof Number && (value = StringUtil.parseInt((String)currentValue, (int)-1)) != -1) {
            return (T)Integer.valueOf(value);
        }
        return ParserGeneratorUtil.getRootAttribute(node, attribute, null);
    }

    public static <T> T getRootAttribute(@NotNull PsiElement node, @NotNull KnownAttribute<T> attribute) {
        return ParserGeneratorUtil.getRootAttribute(node, attribute, null);
    }

    public static <T> T getRootAttribute(@NotNull PsiElement node, @NotNull KnownAttribute<T> attribute, @Nullable String match) {
        return ((BnfFile)node.getContainingFile()).findAttributeValue(null, attribute, match);
    }

    public static <T> T getAttribute(@NotNull BnfRule rule, @NotNull KnownAttribute<T> attribute) {
        return ParserGeneratorUtil.getAttribute(rule, attribute, null);
    }

    @Nullable
    public static <T> BnfAttr findAttribute(@NotNull BnfRule rule, @NotNull KnownAttribute<T> attribute) {
        return ((BnfFile)rule.getContainingFile()).findAttribute(rule, attribute, null);
    }

    public static <T> T getAttribute(@NotNull BnfRule rule, @NotNull KnownAttribute<T> attribute, @Nullable String match) {
        return ((BnfFile)rule.getContainingFile()).findAttributeValue(rule, attribute, match);
    }

    public static Object getAttributeValue(BnfExpression value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BnfReferenceOrToken) {
            return ParserGeneratorUtil.getTokenValue((BnfReferenceOrToken)value);
        }
        if (value instanceof BnfLiteralExpression) {
            return ParserGeneratorUtil.getLiteralValue((BnfLiteralExpression)value);
        }
        if (value instanceof BnfValueList) {
            KnownAttribute.ListValue pairs = new KnownAttribute.ListValue();
            for (BnfListEntry o : ((BnfValueList)value).getListEntryList()) {
                PsiElement id = o.getId();
                pairs.add(Pair.create((Object)(id == null ? null : id.getText()), (Object)ParserGeneratorUtil.getLiteralValue(o.getLiteralExpression())));
            }
            return pairs;
        }
        return null;
    }

    @Nullable
    public static String getLiteralValue(BnfStringLiteralExpression child) {
        return (String)ParserGeneratorUtil.getLiteralValue((BnfLiteralExpression)child);
    }

    @Nullable
    public static <T> T getLiteralValue(BnfLiteralExpression child) {
        if (child == null) {
            return null;
        }
        PsiElement literal = PsiTreeUtil.getDeepestFirst((PsiElement)child);
        String text = child.getText();
        IElementType elementType = literal.getNode().getElementType();
        if (elementType == BnfTypes.BNF_NUMBER) {
            return (T)Integer.valueOf(text);
        }
        if (elementType == BnfTypes.BNF_STRING) {
            String unquoted = GrammarUtil.unquote(text);
            String result = text.charAt(0) == '\"' ? unquoted.replaceAll("\\\\([\"'])", "$1") : unquoted;
            return (T)result;
        }
        return null;
    }

    private static Object getTokenValue(BnfReferenceOrToken child) {
        String text = child.getText();
        if (text.equals("true")) {
            return true;
        }
        if (text.equals("false")) {
            return false;
        }
        return GrammarUtil.getIdText(child);
    }

    public static boolean isTrivialNode(PsiElement element) {
        return ParserGeneratorUtil.getTrivialNodeChild(element) != null;
    }

    public static BnfExpression getNonTrivialNode(BnfExpression initialNode) {
        BnfExpression nonTrivialNode = initialNode;
        BnfExpression e = initialNode;
        BnfExpression n = ParserGeneratorUtil.getTrivialNodeChild(e);
        while (n != null) {
            nonTrivialNode = n;
            e = n;
            n = ParserGeneratorUtil.getTrivialNodeChild(e);
        }
        return nonTrivialNode;
    }

    public static BnfExpression getTrivialNodeChild(PsiElement element) {
        BnfExpression child = null;
        if (element instanceof BnfParenthesized) {
            BnfExpression e = ((BnfParenthesized)element).getExpression();
            if (element instanceof BnfParenExpression) {
                child = e;
            } else {
                BnfExpression c = e;
                while (c instanceof BnfParenthesized) {
                    c = ((BnfParenthesized)c).getExpression();
                }
                if (c.getFirstChild() == null) {
                    child = e;
                }
            }
        } else if (element.getFirstChild() == element.getLastChild() && element instanceof BnfExpression) {
            child = element.getFirstChild();
        }
        return child instanceof BnfExpression && !(child instanceof BnfLiteralExpression) && !(child instanceof BnfReferenceOrToken) ? child : null;
    }

    public static IElementType getEffectiveType(PsiElement tree) {
        if (tree instanceof BnfParenOptExpression) {
            return BnfTypes.BNF_OP_OPT;
        }
        if (tree instanceof BnfQuantified) {
            BnfQuantifier quantifier = ((BnfQuantified)tree).getQuantifier();
            return PsiTreeUtil.getDeepestFirst((PsiElement)quantifier).getNode().getElementType();
        }
        if (tree instanceof BnfPredicate) {
            return ((BnfPredicate)tree).getPredicateSign().getFirstChild().getNode().getElementType();
        }
        if (tree instanceof BnfStringLiteralExpression) {
            return BnfTypes.BNF_STRING;
        }
        if (tree instanceof BnfLiteralExpression) {
            return tree.getFirstChild().getNode().getElementType();
        }
        if (tree instanceof BnfParenExpression) {
            return BnfTypes.BNF_SEQUENCE;
        }
        return tree.getNode().getElementType();
    }

    public static List<BnfExpression> getChildExpressions(@Nullable BnfExpression node) {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)node, BnfExpression.class);
    }

    @NotNull
    private static String getBaseName(@NotNull String name) {
        return ParserGeneratorUtil.toIdentifier(name, null, Case.AS_IS);
    }

    public static String getFuncName(@NotNull BnfRule r) {
        String name = ParserGeneratorUtil.getBaseName(r.getName());
        return JAVA_RESERVED.contains(name) ? name + RESERVED_SUFFIX : name;
    }

    @NotNull
    static String getWrapperParserConstantName(@NotNull String nextName) {
        return ParserGeneratorUtil.getBaseName(nextName) + "_parser_";
    }

    @NotNull
    static String getWrapperParserMetaMethodName(@NotNull String nextName) {
        return ParserGeneratorUtil.getBaseName(nextName) + RESERVED_SUFFIX;
    }

    public static String getNextName(@NotNull String funcName, int i) {
        return StringUtil.trimEnd((String)funcName, (String)RESERVED_SUFFIX) + "_" + i;
    }

    @NotNull
    public static String getGetterName(@NotNull String text) {
        return ParserGeneratorUtil.toIdentifier(text, NameFormat.from("get"), Case.CAMEL);
    }

    @NotNull
    static String getTokenSetConstantName(@NotNull String nextName) {
        return ParserGeneratorUtil.toIdentifier(nextName, null, Case.UPPER) + "_TOKENS";
    }

    public static boolean isRollbackRequired(BnfExpression o, BnfFile file) {
        if (o instanceof BnfStringLiteralExpression) {
            return false;
        }
        if (!(o instanceof BnfReferenceOrToken)) {
            return true;
        }
        String value = GrammarUtil.stripQuotesAroundId(o.getText());
        BnfRule subRule = file.getRule(value);
        if (subRule == null) {
            return false;
        }
        if (ParserGeneratorUtil.getAttribute(subRule, KnownAttribute.RECOVER_WHILE) != null) {
            return true;
        }
        if (!ParserGeneratorUtil.getAttribute(subRule, KnownAttribute.HOOKS).isEmpty()) {
            return true;
        }
        return Rule.isExternal(subRule);
    }

    @NotNull
    public static String toIdentifier(@NotNull String text, @Nullable NameFormat format, @NotNull Case cas) {
        if (text.isEmpty()) {
            return "";
        }
        String fixed = text.replaceAll("[^:\\p{javaJavaIdentifierPart}]", "_");
        boolean allCaps = Case.UPPER.apply(fixed).equals(fixed);
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart(fixed.charAt(0)) && sb.length() == 0) {
            sb.append("_");
        }
        String[] strings = NameUtil.nameToWords((String)fixed);
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            String s = strings[i];
            if (cas == Case.CAMEL && s.startsWith("_") && i != 0 && i != len - 1) continue;
            if (cas == Case.UPPER && !s.startsWith("_") && i != 0 && !StringUtil.endsWith((CharSequence)sb, (CharSequence)"_")) {
                sb.append("_");
            }
            if (cas == Case.CAMEL && !allCaps && Case.UPPER.apply(s).equals(s)) {
                sb.append(s);
                continue;
            }
            sb.append(cas.apply(s));
        }
        return format == null ? sb.toString() : format.apply(sb.toString());
    }

    @NotNull
    public static NameFormat getPsiClassFormat(BnfFile file) {
        return NameFormat.from(ParserGeneratorUtil.getRootAttribute((PsiElement)file, KnownAttribute.PSI_CLASS_PREFIX));
    }

    @NotNull
    public static NameFormat getPsiImplClassFormat(BnfFile file) {
        String prefix = ParserGeneratorUtil.getRootAttribute((PsiElement)file, KnownAttribute.PSI_CLASS_PREFIX);
        String suffix = ParserGeneratorUtil.getRootAttribute((PsiElement)file, KnownAttribute.PSI_IMPL_CLASS_SUFFIX);
        return NameFormat.from(prefix + "/" + StringUtil.notNullize((String)suffix));
    }

    @NotNull
    public static String getRulePsiClassName(@NotNull BnfRule rule, @Nullable NameFormat format) {
        return ParserGeneratorUtil.toIdentifier(rule.getName(), format, Case.CAMEL);
    }

    public static Couple<String> getQualifiedRuleClassName(BnfRule rule) {
        BnfFile file = (BnfFile)rule.getContainingFile();
        String psiPackage = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.PSI_PACKAGE);
        String psiImplPackage = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.PSI_IMPL_PACKAGE);
        NameFormat psiFormat = ParserGeneratorUtil.getPsiClassFormat(file);
        NameFormat psiImplFormat = ParserGeneratorUtil.getPsiImplClassFormat(file);
        return Couple.of((Object)(psiPackage + "." + ParserGeneratorUtil.getRulePsiClassName(rule, psiFormat)), (Object)(psiImplPackage + "." + ParserGeneratorUtil.getRulePsiClassName(rule, psiImplFormat)));
    }

    @NotNull
    public static List<NavigatablePsiElement> findRuleImplMethods(@NotNull JavaHelper helper, @Nullable String psiImplUtilClass, @Nullable String methodName, @Nullable BnfRule rule) {
        if (rule == null) {
            return Collections.emptyList();
        }
        List<NavigatablePsiElement> methods = Collections.emptyList();
        String selectedSuperClass = null;
        block0: for (String ruleClass : ParserGeneratorUtil.getRuleClasses(rule)) {
            String utilClass = psiImplUtilClass;
            while (utilClass != null) {
                methods = helper.findClassMethods(utilClass, JavaHelper.MethodType.STATIC, methodName, -1, ruleClass);
                selectedSuperClass = ruleClass;
                if (!methods.isEmpty()) break block0;
                utilClass = helper.getSuperClassName(utilClass);
            }
        }
        return ParserGeneratorUtil.filterOutShadowedRuleImplMethods(selectedSuperClass, methods, helper);
    }

    @NotNull
    private static List<NavigatablePsiElement> filterOutShadowedRuleImplMethods(String selectedClass, List<NavigatablePsiElement> methods, @NotNull JavaHelper helper) {
        if (methods.size() <= 1) {
            return methods;
        }
        ArrayList<NavigatablePsiElement> result = new ArrayList<NavigatablePsiElement>(methods);
        LinkedHashMap<CallSite, NavigatablePsiElement> prototypes = new LinkedHashMap<CallSite, NavigatablePsiElement>();
        block0: for (NavigatablePsiElement m2 : methods) {
            String type2;
            List<String> types = helper.getMethodTypes(m2);
            String proto = m2.getName() + types.subList(3, types.size());
            NavigatablePsiElement m1 = (NavigatablePsiElement)prototypes.get(proto);
            if (m1 == null) {
                prototypes.put((CallSite)((Object)proto), m2);
                continue;
            }
            String type1 = helper.getMethodTypes(m1).get(1);
            if (Objects.equals(type1, type2 = types.get(1))) continue;
            String s = selectedClass;
            while (s != null) {
                if (Objects.equals(type1, s)) {
                    result.remove(m2);
                    continue block0;
                }
                if (Objects.equals(type2, s)) {
                    result.remove(m1);
                    continue block0;
                }
                s = helper.getSuperClassName(s);
            }
        }
        return result;
    }

    @NotNull
    public static Set<String> getRuleClasses(@NotNull BnfRule rule) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        BnfFile file = (BnfFile)rule.getContainingFile();
        BnfRule topSuper = ParserGeneratorUtil.getEffectiveSuperRule(file, rule);
        String superClassName = topSuper == null ? ParserGeneratorUtil.getRootAttribute((PsiElement)file, KnownAttribute.EXTENDS) : (topSuper == rule ? ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTENDS) : ParserGeneratorUtil.getAttribute(topSuper, KnownAttribute.PSI_PACKAGE) + "." + ParserGeneratorUtil.getRulePsiClassName(topSuper, ParserGeneratorUtil.getPsiClassFormat(file)));
        String implSuper = StringUtil.notNullize((String)ParserGeneratorUtil.getAttribute(rule, KnownAttribute.MIXIN), (String)superClassName);
        Couple<String> names = ParserGeneratorUtil.getQualifiedRuleClassName(rule);
        result.add((String)names.first);
        result.add((String)names.second);
        result.add(superClassName);
        result.add(implSuper);
        result.addAll(ParserGeneratorUtil.getSuperInterfaceNames(file, rule, ParserGeneratorUtil.getPsiClassFormat(file)));
        return result;
    }

    @NotNull
    static JBIterable<BnfRule> getSuperRules(final @NotNull BnfFile file, final @Nullable BnfRule rule) {
        JBIterable result = JBIterable.generate((Object)rule, (Function)new JBIterable.SFun<Object, Object>(){
            Set<BnfRule> visited;

            public Object fun(Object o) {
                if (o == ObjectUtils.NULL) {
                    return null;
                }
                BnfRule cur = (BnfRule)o;
                if (this.visited == null) {
                    this.visited = new HashSet<BnfRule>();
                }
                if (!this.visited.add(cur)) {
                    return ObjectUtils.NULL;
                }
                BnfRule next = RuleGraphHelper.getSynonymTargetOrSelf(cur);
                if (next != cur) {
                    return next;
                }
                if (cur != rule) {
                    return null;
                }
                String attr = ParserGeneratorUtil.getAttribute(cur, KnownAttribute.EXTENDS);
                BnfRule ext = attr != KnownAttribute.EXTENDS.getDefaultValue() ? file.getRule(attr) : null;
                return ext == null && attr != null ? null : ext;
            }
        }).map(o -> o == ObjectUtils.NULL ? null : o);
        return result;
    }

    @Nullable
    static BnfRule getEffectiveSuperRule(@NotNull BnfFile file, @Nullable BnfRule rule) {
        return (BnfRule)ParserGeneratorUtil.getSuperRules(file, rule).last();
    }

    @NotNull
    static List<String> getSuperInterfaceNames(BnfFile file, BnfRule rule, NameFormat format) {
        ArrayList<String> strings = new ArrayList<String>();
        List<Object> topRuleImplements = Collections.emptyList();
        String topRuleClass = null;
        BnfRule topSuper = ParserGeneratorUtil.getEffectiveSuperRule(file, rule);
        if (topSuper != null && topSuper != rule) {
            topRuleImplements = ParserGeneratorUtil.getAttribute(topSuper, KnownAttribute.IMPLEMENTS).asStrings();
            topRuleClass = ParserGeneratorUtil.getAttribute(topSuper, KnownAttribute.PSI_PACKAGE) + "." + ParserGeneratorUtil.getRulePsiClassName(topSuper, format);
            if (!StringUtil.isEmpty((String)topRuleClass)) {
                strings.add(topRuleClass);
            }
        }
        List<String> rootImplements = ParserGeneratorUtil.getRootAttribute((PsiElement)file, KnownAttribute.IMPLEMENTS).asStrings();
        List<String> ruleImplements = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.IMPLEMENTS).asStrings();
        for (String className : ruleImplements) {
            if (className == null) continue;
            BnfRule superIntfRule = file.getRule(className);
            if (superIntfRule != null) {
                strings.add(ParserGeneratorUtil.getAttribute(superIntfRule, KnownAttribute.PSI_PACKAGE) + "." + ParserGeneratorUtil.getRulePsiClassName(superIntfRule, format));
                continue;
            }
            if (topRuleImplements.contains(className) || topRuleClass != null && rootImplements.contains(className)) continue;
            if (strings.size() == 1 && topSuper == null) {
                strings.add(0, className);
                continue;
            }
            strings.add(className);
        }
        return strings;
    }

    @Nullable
    public static String getRuleDisplayName(BnfRule rule, boolean force) {
        String s = ParserGeneratorUtil.getRuleDisplayNameRaw(rule, force);
        return StringUtil.isEmpty((String)s) ? null : "<" + s + ">";
    }

    @Nullable
    private static String getRuleDisplayNameRaw(BnfRule rule, boolean force) {
        String name = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.NAME);
        BnfRule realRule = rule;
        if (name != null && (realRule = ((BnfFile)rule.getContainingFile()).getRule(name)) != null && realRule != rule) {
            name = ParserGeneratorUtil.getAttribute(realRule, KnownAttribute.NAME);
        }
        if (name != null || !force && realRule == rule) {
            return name;
        }
        String[] parts = NameUtil.splitNameIntoWords((String)ParserGeneratorUtil.getFuncName(realRule));
        return Case.LOWER.apply(StringUtil.join((String[])parts, (String)" "));
    }

    public static String getElementType(BnfRule rule, @NotNull Case cas) {
        String elementType = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE);
        if ("".equals(elementType)) {
            return "";
        }
        NameFormat prefix = NameFormat.from(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE_PREFIX));
        return ParserGeneratorUtil.toIdentifier(elementType != null ? elementType : rule.getName(), prefix, cas);
    }

    public static String getTokenType(BnfFile file, String token, @NotNull Case cas) {
        NameFormat format = NameFormat.from(ParserGeneratorUtil.getRootAttribute((PsiElement)file, KnownAttribute.ELEMENT_TYPE_PREFIX));
        String fixed = cas.apply(token.replaceAll("[^:\\p{javaJavaIdentifierPart}]", "_"));
        return format == null ? fixed : format.apply(fixed);
    }

    public static Collection<BnfRule> getSortedPublicRules(Set<PsiElement> accessors) {
        TreeMap<String, BnfRule> result = new TreeMap<String, BnfRule>();
        for (PsiElement tree : accessors) {
            BnfRule rule;
            if (!(tree instanceof BnfRule) || Rule.isPrivate(rule = (BnfRule)tree)) continue;
            result.put(rule.getName(), rule);
        }
        return result.values();
    }

    public static Collection<BnfExpression> getSortedTokens(Set<PsiElement> accessors) {
        TreeMap<String, BnfExpression> result = new TreeMap<String, BnfExpression>();
        for (PsiElement tree : accessors) {
            if (!(tree instanceof BnfReferenceOrToken) && !(tree instanceof BnfLiteralExpression)) continue;
            result.put(tree.getText(), (BnfExpression)tree);
        }
        return result.values();
    }

    public static Collection<LeafPsiElement> getSortedExternalRules(Set<PsiElement> accessors) {
        TreeMap<String, LeafPsiElement> result = new TreeMap<String, LeafPsiElement>();
        for (PsiElement tree : accessors) {
            if (!(tree instanceof LeafPsiElement)) continue;
            result.put(tree.getText(), (LeafPsiElement)tree);
        }
        return result.values();
    }

    public static List<BnfRule> topoSort(@NotNull Collection<BnfRule> rules, @NotNull RuleGraphHelper ruleGraph) {
        HashSet<BnfRule> rulesSet = new HashSet<BnfRule>(rules);
        return ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(rule -> JBIterable.from(ruleGraph.getSubRules((BnfRule)rule)).filter(rulesSet::contains)).withRoots((Iterable)ContainerUtil.reverse(new ArrayList<BnfRule>(rules)))).withTraversal(TreeTraversal.POST_ORDER_DFS)).unique()).toList();
    }

    public static boolean isRegexpToken(@NotNull String tokenText) {
        return tokenText.startsWith("regexp:");
    }

    public static String getRegexpTokenRegexp(@NotNull String tokenText) {
        return tokenText.substring("regexp:".length());
    }

    @Nullable
    static Collection<String> getTokenNames(@NotNull BnfFile file, @NotNull List<BnfExpression> expressions) {
        return ParserGeneratorUtil.getTokenNames(file, expressions, -1);
    }

    @Nullable
    static Collection<String> getTokenNames(@NotNull BnfFile file, @NotNull List<BnfExpression> expressions, int threshold) {
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        for (BnfExpression expression : expressions) {
            String token = ParserGeneratorUtil.getTokenName(file, expression);
            if (token == null) {
                return null;
            }
            tokens.add(token);
        }
        return tokens.size() > threshold ? tokens : null;
    }

    private static String getTokenName(@NotNull BnfFile file, @NotNull BnfExpression expression) {
        String text = expression.getText();
        if (expression instanceof BnfStringLiteralExpression) {
            return RuleGraphHelper.getTokenTextToNameMap(file).get(GrammarUtil.unquote(text));
        }
        if (expression instanceof BnfReferenceOrToken) {
            return file.getRule(text) == null ? text : null;
        }
        return null;
    }

    public static boolean isTokenSequence(@NotNull BnfRule rule, @Nullable BnfExpression node) {
        if (node == null || ConsumeType.forRule(rule) != ConsumeType.DEFAULT) {
            return false;
        }
        if (ParserGeneratorUtil.getEffectiveType(node) != BnfTypes.BNF_SEQUENCE) {
            return false;
        }
        BnfFile file = (BnfFile)rule.getContainingFile();
        return ParserGeneratorUtil.getTokenNames(file, ParserGeneratorUtil.getChildExpressions(node)) != null;
    }

    private static boolean isTokenChoice(@NotNull BnfFile file, @NotNull BnfExpression choice) {
        return choice instanceof BnfChoice && ParserGeneratorUtil.getTokenNames(file, ((BnfChoice)choice).getExpressionList(), 2) != null;
    }

    static boolean hasAtLeastOneTokenChoice(@NotNull BnfFile file, @NotNull Collection<String> ownRuleNames) {
        for (String ruleName : ownRuleNames) {
            BnfExpression expression;
            BnfRule rule = file.getRule(ruleName);
            if (rule == null || !ParserGeneratorUtil.isTokenChoice(file, expression = rule.getExpression())) continue;
            return true;
        }
        return false;
    }

    public static void appendTokenTypes(StringBuilder sb, List<String> tokenTypes) {
        int line = 0;
        int size = tokenTypes.size();
        for (int count = 0; count < size; ++count) {
            boolean newLine = line == 0 && count == 2 || line > 0 && (count - 2) % 6 == 0;
            newLine &= size - count > 2;
            if (count > 0) {
                sb.append(",").append(newLine ? "\n" : " ");
            }
            sb.append(tokenTypes.get(count));
            if (!newLine) continue;
            ++line;
        }
    }

    private static Collection<String> addNewLines(Collection<String> strings) {
        if (strings.size() < 5) {
            return strings;
        }
        ArrayList<String> result = new ArrayList<String>();
        int counter = 0;
        for (String string : strings) {
            if (counter > 0 && counter % 4 == 0) {
                result.add("\n" + string);
            } else {
                result.add(string);
            }
            ++counter;
        }
        return result;
    }

    static String tokenSetString(Collection<String> tokens) {
        String string = String.join((CharSequence)", ", ParserGeneratorUtil.addNewLines(tokens));
        if (tokens.size() < 5) {
            return string;
        }
        return "\n" + string + "\n";
    }

    public static Map<String, String> collectTokenPattern2Name(@NotNull BnfFile file, final boolean createTokenIfMissing, final @NotNull Map<String, String> map, @Nullable Set<String> usedInGrammar) {
        final LinkedHashSet usedNames = usedInGrammar != null ? usedInGrammar : new LinkedHashSet();
        final Map<String, String> origTokens = RuleGraphHelper.getTokenTextToNameMap(file);
        final Pattern pattern = ParserGeneratorUtil.getAllTokenPattern(origTokens);
        final int[] autoCount = new int[]{0};
        final Set<String> origTokenNames = RuleGraphHelper.getTokenNameToTextMap(file).keySet();
        BnfVisitor<Void> visitor = new BnfVisitor<Void>(){

            @Override
            public Void visitStringLiteralExpression(@NotNull BnfStringLiteralExpression o) {
                String text = o.getText();
                String tokenText = GrammarUtil.unquote(text);
                if (!(!createTokenIfMissing || usedNames.contains(tokenText) || StringUtil.isJavaIdentifier((String)tokenText) || pattern != null && pattern.matcher(tokenText).matches())) {
                    int n = autoCount[0];
                    autoCount[0] = n + 1;
                    String tokenName = "_AUTO_" + n;
                    usedNames.add(text);
                    map.put(tokenText, tokenName);
                } else {
                    ContainerUtil.addIfNotNull((Collection)usedNames, (Object)((String)origTokens.get(tokenText)));
                }
                return null;
            }

            @Override
            public Void visitReferenceOrToken(@NotNull BnfReferenceOrToken o) {
                if (GrammarUtil.isExternalReference(o)) {
                    return null;
                }
                BnfRule rule = o.resolveRule();
                if (rule != null) {
                    return null;
                }
                String tokenName = o.getText();
                if (usedNames.add(tokenName) && !origTokenNames.contains(tokenName)) {
                    map.put(tokenName, tokenName);
                }
                return null;
            }
        };
        for (BnfExpression o : GrammarUtil.bnfTraverserNoAttrs((PsiElement)file).filter(BnfExpression.class)) {
            o.accept(visitor);
        }
        for (String tokenText : origTokens.keySet()) {
            Object object;
            String tokenName = origTokens.get(tokenText);
            map.remove(tokenText);
            if (tokenName != null || !createTokenIfMissing) {
                object = tokenName;
            } else {
                int n = autoCount[0];
                autoCount[0] = n + 1;
                object = "_AUTO_" + n;
            }
            map.put(tokenText, (String)object);
        }
        return map;
    }

    static boolean isUsedAsArgument(@NotNull BnfRule rule) {
        return !ReferencesSearch.search((PsiElement)rule, (SearchScope)rule.getUseScope()).forEach(ref -> !ParserGeneratorUtil.isUsedAsArgument(ref));
    }

    private static boolean isUsedAsArgument(@NotNull PsiReference ref) {
        PsiElement element = ref.getElement();
        if (!(element instanceof BnfExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof BnfExternalExpression) || ((BnfExternalExpression)parent).getRefElement() != element) {
            return false;
        }
        return ParserGeneratorUtil.isArgument((BnfExpression)parent);
    }

    static boolean isArgument(@NotNull BnfExpression expr) {
        PsiElement parent = expr.getParent();
        return parent instanceof BnfExternalExpression && ((BnfExternalExpression)parent).getArguments().contains(expr);
    }

    @Nullable
    public static String quote(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return "\"" + text + "\"";
    }

    @Nullable
    public static Pattern compilePattern(String text) {
        try {
            return Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    public static boolean matchesAny(String regexp, String ... text) {
        try {
            Pattern p = Pattern.compile(regexp);
            for (String s : text) {
                if (!p.matcher(s).matches()) continue;
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    public static Pattern getAllTokenPattern(Map<String, String> tokens) {
        StringBuilder sb = new StringBuilder();
        for (String pattern : tokens.keySet()) {
            if (!ParserGeneratorUtil.isRegexpToken(pattern)) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(ParserGeneratorUtil.getRegexpTokenRegexp(pattern));
        }
        return ParserGeneratorUtil.compilePattern(sb.toString());
    }

    public static String getParametersString(List<String> paramsTypes, int offset, int mask, Function<? super String, String> substitutor, Function<? super Integer, ? extends List<String>> annoProvider, NameShortener shortener) {
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < paramsTypes.size(); i += 2) {
            if (i > offset) {
                sb.append(", ");
            }
            String type = (String)substitutor.fun((Object)paramsTypes.get(i));
            String name = paramsTypes.get(i + 1);
            String rawType = NameShortener.getRawClassName(type);
            if (rawType.endsWith("com.intellij.lang.ASTNode")) {
                name = "node";
            }
            if (rawType.endsWith("ElementType")) {
                name = "type";
            }
            if (rawType.endsWith("Stub")) {
                name = "stub";
            }
            if ((mask & 1) == 1) {
                List annos = (List)annoProvider.fun((Object)i);
                for (String s : annos) {
                    if (s.startsWith("kotlin.")) continue;
                    sb.append("@").append(shortener.shorten(s)).append(" ");
                }
                sb.append(shortener.shorten(type));
            }
            if ((mask & 3) == 3) {
                sb.append(" ");
            }
            if ((mask & 2) != 2) continue;
            sb.append(name);
        }
        return sb.toString();
    }

    @NotNull
    public static String unwrapTypeArgumentForParamList(String type) {
        if (!type.endsWith(">")) {
            return type;
        }
        int idx = type.lastIndexOf(60);
        if (idx < 0 || idx > 0 && type.charAt(idx - 1) != ' ') {
            return type;
        }
        return type.substring(0, idx) + type.substring(idx + 1, type.length() - 1);
    }

    public static String getGenericClauseString(List<JavaHelper.TypeParameterInfo> genericParameters, NameShortener shortener) {
        if (genericParameters.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('<');
        for (int i = 0; i < genericParameters.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            JavaHelper.TypeParameterInfo parameter = genericParameters.get(i);
            for (String annotation : parameter.getAnnotations()) {
                buffer.append("@").append(shortener.shorten(annotation)).append(" ");
            }
            buffer.append(parameter.getName());
            List<String> extendsList = parameter.getExtendsList();
            if (extendsList.isEmpty()) continue;
            buffer.append(" extends ");
            for (int i1 = 0; i1 < extendsList.size(); ++i1) {
                if (i1 > 0) {
                    buffer.append(" & ");
                }
                String superType = extendsList.get(i1);
                String shortened = shortener.shorten(superType);
                buffer.append(shortened);
            }
        }
        buffer.append("> ");
        return buffer.toString();
    }

    @NotNull
    public static String getThrowsString(List<String> exceptionList, NameShortener shortener) {
        if (exceptionList.isEmpty()) {
            return "";
        }
        List shortened = ContainerUtil.map(exceptionList, shortener::shorten);
        StringBuilder buffer = new StringBuilder();
        buffer.append(" throws ");
        StringUtil.join((Collection)shortened, (String)", ", (StringBuilder)buffer);
        return buffer.toString();
    }

    @NotNull
    static String staticStarImport(@NotNull String fqn) {
        return "static " + fqn + ".*";
    }

    public static <T extends PsiElement> Hash.Strategy<T> textStrategy() {
        return TEXT_STRATEGY;
    }

    @NotNull
    static <K extends Comparable<? super K>, V> Map<K, V> take(@NotNull Map<K, V> map) {
        TreeMap<K, V> result = new TreeMap<K, V>(map);
        map.clear();
        return result;
    }

    public static class NameFormat {
        static final NameFormat EMPTY = new NameFormat("");
        final String prefix;
        final String suffix;

        public static NameFormat from(@Nullable String format) {
            return StringUtil.isEmpty((String)format) ? EMPTY : new NameFormat(format);
        }

        private NameFormat(@Nullable String format) {
            JBIterable parts = JBIterable.of(format == null ? null : format.split("/"));
            this.prefix = (String)parts.get(0);
            this.suffix = StringUtil.join((Iterable)parts.skip(1), (String)"");
        }

        public String apply(String s) {
            if (this.prefix != null) {
                s = this.prefix + (String)s;
            }
            if (this.suffix != null) {
                s = (String)s + this.suffix;
            }
            return s;
        }

        public String strip(String s) {
            if (this.prefix != null && s.startsWith(this.prefix)) {
                s = s.substring(this.prefix.length());
            }
            if (this.suffix != null && s.endsWith(this.suffix)) {
                s = s.substring(0, s.length() - this.suffix.length());
            }
            return s;
        }
    }

    public static class Rule {
        public static boolean isPrivate(BnfRule node) {
            return Rule.hasModifier(node, "private");
        }

        public static boolean isExternal(BnfRule node) {
            return Rule.hasModifier(node, "external");
        }

        public static boolean isMeta(BnfRule node) {
            return Rule.hasModifier(node, "meta");
        }

        public static boolean isLeft(BnfRule node) {
            return Rule.hasModifier(node, "left");
        }

        public static boolean isInner(BnfRule node) {
            return Rule.hasModifier(node, "inner");
        }

        public static boolean isFake(BnfRule node) {
            return Rule.hasModifier(node, "fake");
        }

        public static boolean isUpper(BnfRule node) {
            return Rule.hasModifier(node, "upper");
        }

        private static boolean hasModifier(@Nullable BnfRule rule, @NotNull String s) {
            if (rule == null) {
                return false;
            }
            for (BnfModifier modifier : rule.getModifierList()) {
                if (!s.equals(modifier.getText())) continue;
                return true;
            }
            return false;
        }

        public static PsiElement firstNotTrivial(BnfRule rule) {
            BnfExpression tree = rule.getExpression();
            while (tree != null) {
                if (!ParserGeneratorUtil.isTrivialNode(tree)) {
                    return tree;
                }
                tree = PsiTreeUtil.getChildOfType((PsiElement)tree, BnfExpression.class);
            }
            return null;
        }

        public static BnfRule of(BnfExpression expr) {
            return (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)expr, BnfRule.class);
        }
    }

    static enum ConsumeType {
        FAST,
        SMART,
        DEFAULT;


        @NotNull
        public String getMethodSuffix() {
            return this == DEFAULT ? "" : StringUtil.capitalize((String)this.name().toLowerCase());
        }

        @NotNull
        public String getMethodName() {
            return KnownAttribute.CONSUME_TOKEN_METHOD.getDefaultValue() + this.getMethodSuffix();
        }

        @NotNull
        public static ConsumeType forRule(@NotNull BnfRule rule) {
            String value = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.CONSUME_TOKEN_METHOD);
            for (ConsumeType method : ConsumeType.values()) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)value, (CharSequence)method.name())) continue;
                return method;
            }
            return (ConsumeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)ConsumeType.forMethod(value)), (Object)((Object)DEFAULT)));
        }

        @Nullable
        public static ConsumeType forMethod(String value) {
            if ("consumeTokenFast".equals(value)) {
                return FAST;
            }
            if ("consumeTokenSmart".equals(value)) {
                return SMART;
            }
            if ("consumeToken".equals(value)) {
                return DEFAULT;
            }
            return null;
        }

        @Nullable
        public static ConsumeType min(@Nullable ConsumeType a, @Nullable ConsumeType b) {
            if (a == null || b == null) {
                return null;
            }
            return a.compareTo(b) < 0 ? a : b;
        }

        @Nullable
        public static ConsumeType max(@Nullable ConsumeType a, @Nullable ConsumeType b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return a.compareTo(b) < 0 ? b : a;
        }
    }

    public static class PinMatcher {
        public final BnfRule rule;
        public final String funcName;
        public final Object pinValue;
        private final int pinIndex;
        private final Pattern pinPattern;

        public PinMatcher(BnfRule rule, IElementType type, String funcName) {
            this.rule = rule;
            this.funcName = funcName;
            this.pinValue = type == BnfTypes.BNF_SEQUENCE ? ParserGeneratorUtil.getAttribute(rule, KnownAttribute.PIN, funcName) : null;
            this.pinIndex = this.pinValue instanceof Integer ? (Integer)this.pinValue : -1;
            this.pinPattern = this.pinValue instanceof String ? ParserGeneratorUtil.compilePattern((String)this.pinValue) : null;
        }

        public boolean active() {
            return this.pinIndex > -1 || this.pinPattern != null;
        }

        public boolean matches(int i, BnfExpression child) {
            return i == this.pinIndex - 1 || this.pinPattern != null && this.pinPattern.matcher(child.getText()).matches();
        }

        public boolean shouldGenerate(List<BnfExpression> children) {
            int size = children.size();
            for (int i = 0; i < size - 1; ++i) {
                if (!this.matches(i, children.get(i))) continue;
                return true;
            }
            return false;
        }
    }
}

