/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.generator;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.analysis.BnfFirstNextAnalyzer;
import org.intellij.grammar.generator.ParserGenerator;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfPredicate;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuleGraphHelper {
    private static final Hash.Strategy<PsiElement> CARDINALITY_HASHING_STRATEGY = new Hash.Strategy<PsiElement>(){

        public int hashCode(PsiElement e) {
            if (e instanceof BnfReferenceOrToken || e instanceof BnfLiteralExpression) {
                return e.getText().hashCode();
            }
            return Objects.hashCode(e);
        }

        public boolean equals(PsiElement e1, PsiElement e2) {
            if (e1 instanceof BnfReferenceOrToken && e2 instanceof BnfReferenceOrToken || e1 instanceof BnfLiteralExpression && e2 instanceof BnfLiteralExpression) {
                return e1.getText().equals(e2.getText());
            }
            return Objects.equals(e1, e2);
        }
    };
    private final BnfFile myFile;
    private final MultiMap<BnfRule, BnfRule> myRuleExtendsMap;
    private final MultiMap<BnfRule, BnfRule> myRulesGraph = RuleGraphHelper.newMultiMap();
    private final Map<BnfRule, Map<PsiElement, Cardinality>> myRuleContentsMap = new HashMap<BnfRule, Map<PsiElement, Cardinality>>();
    private final MultiMap<BnfRule, PsiElement> myRulesCollapseMap = RuleGraphHelper.newMultiMap();
    private final Set<BnfRule> myRulesWithTokens = new HashSet<BnfRule>();
    private final Map<String, PsiElement> myExternalElements = new HashMap<String, PsiElement>();
    private static final IElementType EXTERNAL_TYPE = new GrammarUtil.FakeElementType("EXTERNAL_TYPE", Language.ANY);
    private static final IElementType MARKER_TYPE = new GrammarUtil.FakeElementType("MARKER_TYPE", Language.ANY);
    private static final PsiElement LEFT_MARKER = new GrammarUtil.FakeBnfExpression(MARKER_TYPE, "LEFT_MARKER");
    private static final PsiElement NOT_EMPTY_MARKER = new GrammarUtil.FakeBnfExpression(MARKER_TYPE, "NOT_EMPTY_MARKER");
    private static final Object RECURSION_MARKER = "RECURSION_DETECTED";
    private static final Key<CachedValue<RuleGraphHelper>> RULE_GRAPH_HELPER_KEY = Key.create((String)"RULE_GRAPH_HELPER_KEY");

    public static String getCardinalityText(Cardinality cardinality) {
        if (cardinality == Cardinality.AT_LEAST_ONE) {
            return "+";
        }
        if (cardinality == Cardinality.ANY_NUMBER) {
            return "*";
        }
        if (cardinality == Cardinality.OPTIONAL) {
            return "?";
        }
        return "";
    }

    public static MultiMap<BnfRule, BnfRule> buildExtendsMap(BnfFile file) {
        MultiMap ruleExtendsMap = RuleGraphHelper.newMultiMap();
        for (BnfRule rule : file.getRules()) {
            BnfRule target;
            if (RuleGraphHelper.isPrivateOrNoType(rule)) continue;
            BnfRule superRule = file.getRule(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTENDS));
            if (superRule != null) {
                ruleExtendsMap.putValue((Object)superRule, (Object)rule);
            }
            if ((target = RuleGraphHelper.getSynonymTargetOrSelf(rule)) == rule) continue;
            ruleExtendsMap.putValue((Object)target, (Object)rule);
            if (superRule == null) continue;
            ruleExtendsMap.putValue((Object)superRule, (Object)target);
        }
        int len = ruleExtendsMap.size();
        for (int i = 0; i < len; ++i) {
            boolean changed = false;
            for (BnfRule superRule : ruleExtendsMap.keySet()) {
                Collection rules = ruleExtendsMap.get((Object)superRule);
                for (BnfRule rule : new ArrayList(rules)) {
                    changed |= rules.addAll(ruleExtendsMap.get((Object)rule));
                }
            }
            if (!changed) break;
        }
        for (BnfRule rule : ruleExtendsMap.keySet()) {
            ruleExtendsMap.putValue((Object)rule, (Object)rule);
        }
        return ruleExtendsMap;
    }

    private static <K, V> MultiMap<K, V> newMultiMap() {
        return MultiMap.createLinkedSet();
    }

    @NotNull
    public static Map<String, String> getTokenNameToTextMap(BnfFile file) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result(RuleGraphHelper.computeTokens(file).asMap(), new Object[]{file}));
    }

    @NotNull
    public static Map<String, String> getTokenTextToNameMap(BnfFile file) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result(RuleGraphHelper.computeTokens(file).asInverseMap(), new Object[]{file}));
    }

    public static KnownAttribute.ListValue computeTokens(BnfFile file) {
        return ParserGeneratorUtil.getRootAttribute((PsiElement)file, KnownAttribute.TOKENS);
    }

    public static RuleGraphHelper getCached(@NotNull BnfFile file) {
        CachedValue value = (CachedValue)file.getUserData(RULE_GRAPH_HELPER_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)new RuleGraphHelper(file), new Object[]{file}), false);
            file.putUserData(RULE_GRAPH_HELPER_KEY, value);
        }
        return (RuleGraphHelper)value.getValue();
    }

    public RuleGraphHelper(BnfFile file) {
        this(file, RuleGraphHelper.buildExtendsMap(file));
    }

    public RuleGraphHelper(BnfFile file, MultiMap<BnfRule, BnfRule> ruleExtendsMap) {
        this.myFile = file;
        this.myRuleExtendsMap = ruleExtendsMap;
        this.buildRulesGraph();
        this.buildCollapseMap();
        this.buildContentsMap();
    }

    public MultiMap<BnfRule, BnfRule> getRuleExtendsMap() {
        return this.myRuleExtendsMap;
    }

    public BnfFile getFile() {
        return this.myFile;
    }

    public boolean canCollapse(@NotNull BnfRule rule) {
        return this.myRulesCollapseMap.containsKey((Object)rule);
    }

    private void buildCollapseMap() {
        BnfFirstNextAnalyzer analyzer = BnfFirstNextAnalyzer.createAnalyzer(true, true, (Condition<PsiElement>)((Condition)o -> !(o instanceof BnfRule)));
        for (BnfRule rule : this.myFile.getRules()) {
            if (!this.myRuleExtendsMap.containsScalarValue((Object)rule)) continue;
            Set<BnfExpression> first = analyzer.calcFirst(rule);
            for (BnfExpression expression : first) {
                Map<BnfExpression, BnfExpression> map;
                BnfRule commonSuper;
                BnfRule r = expression instanceof BnfReferenceOrToken ? this.myFile.getRule(expression.getText()) : null;
                BnfRule bnfRule = commonSuper = r != null ? this.getCommonSuperRule(rule, r) : null;
                if (expression != BnfFirstNextAnalyzer.BNF_MATCHES_ANY && commonSuper == null || !(map = analyzer.calcNext(expression)).containsKey(BnfFirstNextAnalyzer.BNF_MATCHES_EOF)) continue;
                if (commonSuper != null) {
                    this.myRulesCollapseMap.putValue((Object)rule, (Object)commonSuper);
                }
                this.myRulesCollapseMap.putValue((Object)rule, (Object)((PsiElement)ObjectUtils.notNull((Object)r, (Object)rule)));
            }
            if (!this.myRulesCollapseMap.containsKey((Object)rule)) continue;
            this.myRulesCollapseMap.putValue((Object)rule, (Object)rule);
        }
    }

    private void buildContentsMap() {
        List<BnfRule> rules = ParserGeneratorUtil.topoSort(this.myFile.getRules(), this);
        LinkedHashSet<Object> visited = new LinkedHashSet<Object>();
        for (BnfRule rule : rules) {
            this.collectMembers(rule, visited);
            visited.clear();
        }
    }

    private Map<PsiElement, Cardinality> collectMembers(@NotNull BnfRule rule, Set<Object> visited) {
        Map<PsiElement, Cardinality> result = this.myRuleContentsMap.get(rule);
        if (result != null) {
            return result;
        }
        result = ParserGeneratorUtil.Rule.isExternal(rule) ? RuleGraphHelper.psiMap(this.newExternalPsi(rule.getName()), Cardinality.REQUIRED) : this.collectMembers(rule, rule.getExpression(), visited);
        if (visited.size() > 1 && visited.contains(RECURSION_MARKER) && RuleGraphHelper.isPrivateOrNoType(rule)) {
            return result;
        }
        result.remove(NOT_EMPTY_MARKER);
        this.myRuleContentsMap.put(rule, result);
        return result;
    }

    @Nullable
    private BnfRule getCommonSuperRule(BnfRule r1, BnfRule r2) {
        int count = Integer.MAX_VALUE;
        BnfRule result = null;
        for (BnfRule superRule : this.myRuleExtendsMap.keySet()) {
            Collection set = this.myRuleExtendsMap.get((Object)superRule);
            if (!set.contains(r1) || !set.contains(r2) || count <= set.size()) continue;
            count = set.size();
            result = superRule;
        }
        return result;
    }

    private void buildRulesGraph() {
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser().expand(o -> !(o instanceof BnfPredicate) && !(o instanceof BnfExternalExpression));
        for (BnfRule rule : this.myFile.getRules()) {
            for (PsiElement e : ((SyntaxTraverser)s.withRoot((Object)rule.getExpression())).filter(BnfExpression.class)) {
                BnfRule r;
                BnfReferenceOrToken ruleRef = e instanceof BnfReferenceOrToken ? (BnfReferenceOrToken)e : (e instanceof BnfExternalExpression ? (BnfReferenceOrToken)PsiTreeUtil.findChildOfType((PsiElement)e, BnfReferenceOrToken.class) : null);
                BnfRule bnfRule = r = ruleRef != null ? ruleRef.resolveRule() : null;
                if (r != null) {
                    this.myRulesGraph.putValue((Object)rule, (Object)r);
                    continue;
                }
                if (!(e instanceof BnfReferenceOrToken) && !(e instanceof BnfStringLiteralExpression)) continue;
                this.myRulesWithTokens.add(rule);
            }
        }
        for (BnfRule rule : this.myFile.getRules()) {
            if (!ParserGeneratorUtil.Rule.isLeft(rule) || RuleGraphHelper.isPrivateOrNoType(rule) || ParserGeneratorUtil.Rule.isInner(rule)) continue;
            for (BnfRule r : RuleGraphHelper.getRulesToTheLeft(rule).keySet()) {
                this.myRulesGraph.putValue((Object)rule, (Object)r);
            }
        }
    }

    public Collection<BnfRule> getExtendsRules(BnfRule rule) {
        return this.myRuleExtendsMap.get((Object)rule);
    }

    public boolean containsTokens(BnfRule rule) {
        return this.myRulesWithTokens.contains(rule);
    }

    public Collection<BnfRule> getSubRules(BnfRule rule) {
        return this.myRulesGraph.get((Object)rule);
    }

    @NotNull
    public Map<PsiElement, Cardinality> getFor(BnfRule rule) {
        Map<PsiElement, Cardinality> map = this.myRuleContentsMap.get(rule);
        return map == null ? Collections.emptyMap() : map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<PsiElement, Cardinality> collectMembers(BnfRule rule, BnfExpression tree, Set<Object> visited) {
        if (tree instanceof BnfPredicate) {
            return Collections.emptyMap();
        }
        if (tree instanceof BnfLiteralExpression) {
            return RuleGraphHelper.psiMap(tree, Cardinality.REQUIRED);
        }
        if (!visited.add(tree)) {
            visited.add(RECURSION_MARKER);
            return RuleGraphHelper.psiMap(tree, Cardinality.REQUIRED);
        }
        try {
            Map<PsiElement, Cardinality> map = this.collectMembersInner(rule, tree, visited);
            return map;
        }
        finally {
            visited.remove(tree);
        }
    }

    private Map<PsiElement, Cardinality> collectMembersInner(BnfRule rule, BnfExpression tree, Set<Object> visited) {
        Map<Object, Object> result;
        boolean tryCollapse;
        boolean firstNonTrivial = tree == ParserGeneratorUtil.Rule.firstNotTrivial(rule);
        boolean outerLeft = (firstNonTrivial || rule.getExpression() == tree) && ParserGeneratorUtil.Rule.isLeft(rule) && !RuleGraphHelper.isPrivateOrNoType(rule) && !ParserGeneratorUtil.Rule.isInner(rule);
        boolean bl = tryCollapse = firstNonTrivial && !outerLeft && !RuleGraphHelper.isPrivateOrNoType(rule) && !ParserGeneratorUtil.Rule.isFake(rule);
        if (tree instanceof BnfReferenceOrToken) {
            BnfRule targetRule = ((BnfReferenceOrToken)tree).resolveRule();
            if (targetRule != null) {
                if (ParserGeneratorUtil.Rule.isExternal(targetRule)) {
                    result = RuleGraphHelper.psiMap(this.newExternalPsi(targetRule.getName()), Cardinality.REQUIRED);
                } else if (ParserGeneratorUtil.Rule.isLeft(targetRule)) {
                    if (!ParserGeneratorUtil.Rule.isInner(targetRule) && !RuleGraphHelper.isPrivateOrNoType(targetRule)) {
                        result = RuleGraphHelper.psiMap();
                        result.put(RuleGraphHelper.getSynonymTargetOrSelf(targetRule), (Object)Cardinality.REQUIRED);
                        result.put(LEFT_MARKER, (Object)Cardinality.REQUIRED);
                    } else {
                        result = Collections.emptyMap();
                    }
                } else {
                    result = RuleGraphHelper.isPrivateOrNoType(targetRule) ? this.collectMembers(targetRule, visited) : (ParserGeneratorUtil.Rule.isUpper(targetRule) ? Collections.emptyMap() : RuleGraphHelper.psiMap(RuleGraphHelper.getSynonymTargetOrSelf(targetRule), Cardinality.REQUIRED));
                }
            } else {
                result = RuleGraphHelper.psiMap(tree, Cardinality.REQUIRED);
            }
            if (tryCollapse && this.willCollapse(rule, result)) {
                result = Collections.emptyMap();
            }
        } else if (tree instanceof BnfExternalExpression) {
            BnfExternalExpression expression = (BnfExternalExpression)tree;
            List<BnfExpression> arguments = expression.getArguments();
            if (arguments.isEmpty() && ParserGeneratorUtil.Rule.isMeta(rule)) {
                result = RuleGraphHelper.psiMap(this.newExternalPsi(tree.getText()), Cardinality.REQUIRED);
            } else {
                BnfExpression ruleRef = expression.getRefElement();
                BnfRule metaRule = ((BnfReferenceOrToken)ruleRef).resolveRule();
                if (metaRule == null) {
                    result = RuleGraphHelper.psiMap(this.newExternalPsi("#" + ruleRef.getText()), Cardinality.REQUIRED);
                } else if (RuleGraphHelper.isPrivateOrNoType(metaRule)) {
                    result = RuleGraphHelper.psiMap();
                    Map<PsiElement, Cardinality> metaResults = this.collectMembers(metaRule, visited);
                    Object params = null;
                    for (PsiElement member : metaResults.keySet()) {
                        int idx;
                        Cardinality cardinality = metaResults.get(member);
                        if (!RuleGraphHelper.isExternalPsi(member)) {
                            result.put((PsiElement)((Object)member), (Object)cardinality);
                            continue;
                        }
                        if (params == null) {
                            params = GrammarUtil.collectMetaParameters(metaRule, metaRule.getExpression());
                        }
                        if ((idx = params.indexOf(member.getText())) <= -1 || idx >= arguments.size()) continue;
                        Map<PsiElement, Cardinality> argMap = this.collectMembers(rule, arguments.get(idx), visited);
                        for (PsiElement element : argMap.keySet()) {
                            Cardinality existing = (Cardinality)((Object)ObjectUtils.notNull((Object)((Object)result.get(element)), (Object)((Object)Cardinality.NONE)));
                            result.put((PsiElement)((Object)element), (Object)existing.or(cardinality.and(argMap.get(element))));
                        }
                    }
                } else {
                    result = RuleGraphHelper.psiMap(metaRule, Cardinality.REQUIRED);
                }
            }
            if (tryCollapse && this.willCollapse(rule, result)) {
                result = Collections.emptyMap();
            }
        } else {
            ArrayList pinned = new ArrayList();
            GrammarUtil.processPinnedExpressions(rule, (Processor<? super BnfExpression>)new CommonProcessors.CollectProcessor(pinned));
            boolean pinApplied = false;
            IElementType type = ParserGeneratorUtil.getEffectiveType(tree);
            ArrayList<Map<PsiElement, Cardinality>> list = new ArrayList<Map<PsiElement, Cardinality>>();
            List<BnfExpression> childExpressions = ParserGeneratorUtil.getChildExpressions(tree);
            for (BnfExpression child : childExpressions) {
                Map<PsiElement, Cardinality> nextMap = this.collectMembers(rule, child, visited);
                if (pinApplied) {
                    nextMap = this.joinMaps(rule, false, BnfTypes.BNF_OP_OPT, Collections.singletonList(nextMap));
                }
                list.add(nextMap);
                if (pinApplied || !pinned.contains(child)) continue;
                pinApplied = true;
            }
            result = this.joinMaps(rule, tryCollapse, type, list);
            Map<Object, Cardinality> map = result = type == BnfTypes.BNF_SEQUENCE && visited.contains(RECURSION_MARKER) && result.remove(rule.getExpression()) != null ? this.joinMaps(rule, false, type, Arrays.asList(result, result)) : result;
        }
        if (outerLeft && rule.getExpression() == tree) {
            ArrayList<Map<PsiElement, Cardinality>> list = new ArrayList<Map<PsiElement, Cardinality>>();
            Map<BnfRule, Cardinality> rulesToTheLeft = RuleGraphHelper.getRulesToTheLeft(rule);
            for (BnfRule r : rulesToTheLeft.keySet()) {
                Cardinality cardinality = rulesToTheLeft.get(r);
                Map<PsiElement, Cardinality> leftMap = RuleGraphHelper.psiMap(r, Cardinality.REQUIRED);
                if (cardinality.many()) {
                    list.add(this.joinMaps(rule, false, BnfTypes.BNF_CHOICE, Arrays.asList(leftMap, RuleGraphHelper.psiMap(rule, Cardinality.REQUIRED))));
                    continue;
                }
                list.add(leftMap);
            }
            Map<PsiElement, Cardinality> combinedLeftMap = this.joinMaps(rule, false, BnfTypes.BNF_CHOICE, list);
            result = this.joinMaps(rule, true, BnfTypes.BNF_SEQUENCE, Arrays.asList(result, combinedLeftMap));
        }
        return result;
    }

    private static Map<BnfRule, Cardinality> getRulesToTheLeft(BnfRule rule) {
        LinkedHashMap<BnfRule, Cardinality> result = new LinkedHashMap<BnfRule, Cardinality>();
        Map<BnfExpression, BnfExpression> nextMap = BnfFirstNextAnalyzer.createBackwardAnalyzer(true).calcNext(rule);
        for (BnfExpression e : nextMap.keySet()) {
            BnfRule r;
            if (!(e instanceof BnfReferenceOrToken) || (r = ((BnfReferenceOrToken)e).resolveRule()) == null || RuleGraphHelper.isPrivateOrNoType(r)) continue;
            BnfExpression context = nextMap.get(e);
            Cardinality cardinality = Cardinality.REQUIRED;
            BnfExpression cur = context;
            while (!(cur instanceof BnfRule) && !PsiTreeUtil.isAncestor((PsiElement)cur, (PsiElement)e, (boolean)true)) {
                IElementType curType = ParserGeneratorUtil.getEffectiveType(cur);
                if (curType == BnfTypes.BNF_OP_OPT || curType == BnfTypes.BNF_OP_ONEMORE || curType == BnfTypes.BNF_OP_ZEROMORE) {
                    cardinality = cardinality.and(Cardinality.fromNodeType(curType));
                }
                cur = cur.getParent();
            }
            Cardinality prev = (Cardinality)((Object)result.get(r));
            result.put(r, prev == null ? cardinality : cardinality.and(prev));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<PsiElement, Cardinality> joinMaps(@NotNull BnfRule rule, boolean tryCollapse, IElementType type, List<Map<PsiElement, Cardinality>> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (type == BnfTypes.BNF_OP_OPT || type == BnfTypes.BNF_OP_ZEROMORE || type == BnfTypes.BNF_OP_ONEMORE) {
            ParserGenerator.LOG.assertTrue(list.size() == 1);
            list = this.compactInheritors(rule, list);
            Map<PsiElement, Cardinality> m = list.get(0);
            if (tryCollapse && this.willCollapse(rule, m) && type == BnfTypes.BNF_OP_OPT) {
                return Collections.emptyMap();
            }
            Map<PsiElement, Cardinality> map = RuleGraphHelper.psiMap();
            boolean leftMarker = m.containsKey(LEFT_MARKER);
            for (PsiElement t : m.keySet()) {
                void var10_23;
                Cardinality cardinality = Cardinality.fromNodeType(type).and(m.get(t));
                if (leftMarker) {
                    Cardinality cardinality2 = cardinality.single();
                }
                map.put(t, (Cardinality)var10_23);
            }
            return map;
        }
        if (type == BnfTypes.BNF_SEQUENCE || type == BnfTypes.BNF_EXPRESSION || type == BnfTypes.BNF_REFERENCE_OR_TOKEN) {
            list = new ArrayList<Map<PsiElement, Cardinality>>(this.compactInheritors(rule, list));
            list.removeIf(Map::isEmpty);
            Map<PsiElement, Cardinality> map = RuleGraphHelper.psiMap();
            for (Map<PsiElement, Cardinality> m : list) {
                Cardinality leftMarker = m.get(LEFT_MARKER);
                if (leftMarker == Cardinality.REQUIRED) {
                    map.clear();
                    leftMarker = null;
                } else if (leftMarker == Cardinality.OPTIONAL) {
                    for (PsiElement psiElement : map.keySet()) {
                        if (m.containsKey(psiElement)) continue;
                        map.put(psiElement, map.get(psiElement).and(Cardinality.OPTIONAL));
                    }
                }
                for (PsiElement psiElement : m.keySet()) {
                    if (psiElement == LEFT_MARKER && m != list.get(0)) continue;
                    Cardinality c1 = map.get(psiElement);
                    Cardinality c2 = m.get(psiElement);
                    Cardinality joinedCard = leftMarker == null ? c2.or(c1) : (c1 == null ? c2 : (c1 == Cardinality.REQUIRED ? (c2.many() ? Cardinality.AT_LEAST_ONE : Cardinality.REQUIRED) : (c1 == Cardinality.AT_LEAST_ONE ? Cardinality.ANY_NUMBER : c1)));
                    map.put(psiElement, joinedCard);
                }
            }
            if (tryCollapse && this.willCollapse(rule, map)) {
                return Collections.emptyMap();
            }
            return map;
        }
        if (type == BnfTypes.BNF_CHOICE) {
            Map<PsiElement, Cardinality> map = RuleGraphHelper.psiMap();
            list = this.compactInheritors(rule, list);
            if (tryCollapse) {
                int newListSize = list.size();
                for (int i = 0; i < newListSize; ++i) {
                    Map<PsiElement, Cardinality> m = list.get(i);
                    if (!this.willCollapse(rule, m)) continue;
                    list.set(i, Collections.emptyMap());
                }
            }
            Map<PsiElement, Cardinality> m0 = list.get(0);
            map.putAll(m0);
            for (Map<PsiElement, Cardinality> m : list) {
                map.keySet().retainAll(m.keySet());
            }
            for (PsiElement t : new ArrayList<PsiElement>(map.keySet())) {
                map.put(t, Cardinality.REQUIRED.and(m0.get(t)));
                for (Map map2 : list) {
                    if (map2 == list.get(0)) continue;
                    map.put(t, map.get(t).and((Cardinality)((Object)map2.get(t))));
                }
            }
            for (Map<PsiElement, Cardinality> m : list) {
                if (tryCollapse && this.willCollapse(rule, m)) continue;
                for (PsiElement psiElement : m.keySet()) {
                    if (map.containsKey(psiElement)) continue;
                    map.put(psiElement, Cardinality.OPTIONAL.and(m.get(psiElement)));
                }
            }
            boolean notEmpty = true;
            block10: for (Map<PsiElement, Cardinality> m : list) {
                for (Cardinality c : m.values()) {
                    if (c.optional()) continue;
                    continue block10;
                }
                notEmpty = false;
            }
            if (notEmpty) {
                map.put(NOT_EMPTY_MARKER, Cardinality.REQUIRED);
            }
            return map;
        }
        throw new AssertionError((Object)("unexpected: " + type));
    }

    private boolean canCollapseBy(BnfRule rule, PsiElement t) {
        if (this.myRulesCollapseMap.get((Object)rule).contains(t)) {
            return true;
        }
        if (rule == t || t instanceof BnfRule && this.getCommonSuperRule(rule, (BnfRule)t) != null) {
            this.myRulesCollapseMap.putValue((Object)rule, (Object)t);
            return true;
        }
        if (RuleGraphHelper.isExternalPsi(t) && this.myRuleExtendsMap.containsScalarValue((Object)rule)) {
            this.myRulesCollapseMap.putValue((Object)rule, (Object)rule);
            return true;
        }
        return false;
    }

    private static <V> Map<PsiElement, V> psiMap(PsiElement k, V v) {
        Object2ObjectOpenCustomHashMap map = new Object2ObjectOpenCustomHashMap(1, CARDINALITY_HASHING_STRATEGY);
        map.put(k, v);
        return map;
    }

    private static <V> Map<PsiElement, V> psiMap(Map<PsiElement, V> map) {
        return new Object2ObjectOpenCustomHashMap(map, CARDINALITY_HASHING_STRATEGY);
    }

    private static <V> Map<PsiElement, V> psiMap() {
        return new Object2ObjectOpenCustomHashMap(3, CARDINALITY_HASHING_STRATEGY);
    }

    private List<Map<PsiElement, Cardinality>> compactInheritors(@Nullable BnfRule forRule, @NotNull List<Map<PsiElement, Cardinality>> mapList) {
        LinkedHashMap<BnfRule, BnfRule> rulesAndAlts = new LinkedHashMap<BnfRule, BnfRule>();
        LinkedHashMap<PsiElement, BnfRule> externalMap = new LinkedHashMap<PsiElement, BnfRule>();
        for (Map<PsiElement, Cardinality> map : mapList) {
            for (PsiElement element : map.keySet()) {
                String text;
                BnfRule rule;
                BnfRule r = null;
                if (element instanceof BnfRule) {
                    r = (BnfRule)element;
                } else if (RuleGraphHelper.isExternalPsi(element) && !element.getText().startsWith("#") && !GrammarUtil.isDoubleAngles(element.getText()) && ParserGeneratorUtil.Rule.isExternal(rule = this.myFile.getRule(text = element.getText())) && (r = this.myFile.getRule(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTENDS))) != null) {
                    externalMap.put(element, r);
                }
                if (r == null) continue;
                rulesAndAlts.put(r, r);
            }
        }
        boolean hasSynonyms = this.collectSynonymsAndCollapseAlternatives(rulesAndAlts);
        if (rulesAndAlts.size() < 2) {
            return !hasSynonyms ? mapList : RuleGraphHelper.replaceRulesInMaps(mapList, rulesAndAlts, externalMap);
        }
        LinkedHashSet<Object> allRules = new LinkedHashSet<Object>();
        allRules.addAll(rulesAndAlts.keySet());
        allRules.addAll(rulesAndAlts.values());
        ArrayList<Map.Entry<BnfRule, Collection<BnfRule>>> applicableSupers = new ArrayList<Map.Entry<BnfRule, Collection<BnfRule>>>();
        for (Map.Entry e : this.myRuleExtendsMap.entrySet()) {
            int count = 0;
            for (BnfRule bnfRule : allRules) {
                if (!((Collection)e.getValue()).contains(bnfRule)) continue;
                ++count;
            }
            if (count <= true) continue;
            applicableSupers.add(e);
        }
        if (applicableSupers.isEmpty()) {
            return !hasSynonyms ? mapList : RuleGraphHelper.replaceRulesInMaps(mapList, rulesAndAlts, externalMap);
        }
        RuleGraphHelper.findTheBestReplacement(rulesAndAlts, applicableSupers);
        return RuleGraphHelper.replaceRulesInMaps(mapList, rulesAndAlts, externalMap);
    }

    private boolean collectSynonymsAndCollapseAlternatives(Map<BnfRule, BnfRule> rulesAndAlts) {
        boolean hasSynonyms = false;
        for (Map.Entry<BnfRule, BnfRule> e : new ArrayList<Map.Entry<BnfRule, BnfRule>>(rulesAndAlts.entrySet())) {
            BnfRule rule = e.getKey();
            e.setValue(RuleGraphHelper.getSynonymTargetOrSelf(rule));
            hasSynonyms |= rule != e.getValue();
            for (PsiElement r : this.myRulesCollapseMap.get((Object)rule)) {
                if (!(r instanceof BnfRule) || rulesAndAlts.containsKey(r)) continue;
                rulesAndAlts.put((BnfRule)r, (BnfRule)r);
            }
        }
        return hasSynonyms;
    }

    private boolean willCollapse(BnfRule rule, Map<PsiElement, Cardinality> map) {
        if (!this.canCollapse(rule, map)) {
            return false;
        }
        boolean requiredFound = false;
        for (PsiElement t : map.keySet()) {
            if (PsiUtilCore.getElementType((PsiElement)t) == MARKER_TYPE) continue;
            if (requiredFound || map.get(t) != Cardinality.REQUIRED) {
                return false;
            }
            if (RuleGraphHelper.isExternalPsi(t)) {
                return false;
            }
            requiredFound = true;
        }
        return requiredFound;
    }

    private boolean canCollapse(BnfRule rule, Map<PsiElement, Cardinality> map) {
        boolean result = false;
        boolean maybeCollapsed = true;
        PsiElement required = null;
        for (PsiElement psiElement : map.keySet()) {
            if (PsiUtilCore.getElementType((PsiElement)psiElement) != MARKER_TYPE && !map.get(psiElement).optional() && !(maybeCollapsed = required == null ? (required = psiElement) instanceof BnfRule || RuleGraphHelper.isExternalPsi(required) : false)) break;
        }
        if (maybeCollapsed) {
            for (PsiElement psiElement : required != null ? Collections.singleton(required) : map.keySet()) {
                result |= this.canCollapseBy(rule, psiElement);
            }
        }
        return result;
    }

    private static void findTheBestReplacement(Map<BnfRule, BnfRule> rulesAndAlts, List<Map.Entry<BnfRule, Collection<BnfRule>>> supers) {
        BitSet bits = new BitSet(rulesAndAlts.size());
        int minI = -1;
        int minC = -1;
        int minS = -1;
        int len = Math.min(16, supers.size());
        for (int i = (1 << len) - 1; i > 0; --i) {
            if (minC != -1 && Integer.bitCount(i) > minC) continue;
            int curC = 0;
            int curS = 0;
            bits.set(0, rulesAndAlts.size(), true);
            int j = 0;
            int bit = 1;
            while (j < len) {
                if ((i & bit) != 0) {
                    Collection<BnfRule> vals = supers.get(j).getValue();
                    ++curC;
                    curS += vals.size();
                    if (!bits.isEmpty()) {
                        int k = 0;
                        for (Map.Entry<BnfRule, BnfRule> e : rulesAndAlts.entrySet()) {
                            if (bits.get(k) && (vals.contains(e.getKey()) || vals.contains(e.getValue()))) {
                                bits.set(k, false);
                            }
                            ++k;
                        }
                        if (!bits.isEmpty()) {
                            curC += bits.cardinality();
                            curS += bits.cardinality();
                        }
                    }
                }
                ++j;
                bit <<= 1;
            }
            if (minC != -1 && minC <= curC && (minC != curC || minS <= curS)) continue;
            minC = curC;
            minS = curS;
            minI = i;
        }
        for (Map.Entry<BnfRule, BnfRule> e : rulesAndAlts.entrySet()) {
            int len2 = supers.size();
            int j = 0;
            int bit = 1;
            while (j < len2) {
                Collection<BnfRule> vals;
                if ((minI & bit) != 0 && ((vals = supers.get(j).getValue()).contains(e.getKey()) || vals.contains(e.getValue()))) {
                    e.setValue(supers.get(j).getKey());
                }
                ++j;
                bit <<= 1;
            }
        }
    }

    private static List<Map<PsiElement, Cardinality>> replaceRulesInMaps(List<Map<PsiElement, Cardinality>> mapList, Map<BnfRule, BnfRule> replacementMap, Map<PsiElement, BnfRule> externalMap) {
        ArrayList<Map<PsiElement, Cardinality>> result = new ArrayList<Map<PsiElement, Cardinality>>(mapList.size());
        for (Map<PsiElement, Cardinality> map : mapList) {
            Map<PsiElement, Cardinality> copy = RuleGraphHelper.psiMap(map);
            result.add(copy);
            for (PsiElement psiElement : map.keySet()) {
                BnfRule rule = RuleGraphHelper.isExternalPsi(psiElement) ? externalMap.get(psiElement) : null;
                BnfRule replacement = rule != null ? replacementMap.get(rule) : null;
                if (replacement == null) continue;
                copy.put(rule, copy.remove(psiElement));
            }
            for (Map.Entry entry : replacementMap.entrySet()) {
                Cardinality card = copy.remove(entry.getKey());
                if (card == null) continue;
                Cardinality cur = copy.get(entry.getValue());
                copy.put((PsiElement)entry.getValue(), cur == null ? card : cur.or(card));
            }
        }
        return result;
    }

    public static BnfRule getSynonymTargetOrSelf(BnfRule rule) {
        BnfRule realRule;
        String attr = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE);
        if (attr != null && (realRule = ((BnfFile)rule.getContainingFile()).getRule(attr)) != null && RuleGraphHelper.shouldGeneratePsi(realRule, false)) {
            return realRule;
        }
        return rule;
    }

    public static boolean hasPsiClass(BnfRule rule) {
        return RuleGraphHelper.shouldGeneratePsi(rule, true);
    }

    public static boolean hasElementType(BnfRule rule) {
        return RuleGraphHelper.shouldGeneratePsi(rule, false);
    }

    public static boolean isPrivateOrNoType(BnfRule rule) {
        return ParserGeneratorUtil.Rule.isPrivate(rule) || "".equals(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE));
    }

    private static boolean shouldGeneratePsi(BnfRule rule, boolean psiClasses) {
        BnfFile containingFile = (BnfFile)rule.getContainingFile();
        BnfRule grammarRoot = containingFile.getRules().get(0);
        if (grammarRoot == rule) {
            return false;
        }
        if (ParserGeneratorUtil.Rule.isPrivate(rule) || ParserGeneratorUtil.Rule.isExternal(rule)) {
            return false;
        }
        String attr = ParserGeneratorUtil.getAttribute(rule, KnownAttribute.ELEMENT_TYPE);
        if (!psiClasses) {
            return !"".equals(attr);
        }
        BnfRule thatRule = containingFile.getRule(attr);
        return thatRule == null || thatRule == grammarRoot || ParserGeneratorUtil.Rule.isPrivate(thatRule) || ParserGeneratorUtil.Rule.isExternal(thatRule);
    }

    @NotNull
    private PsiElement newExternalPsi(String name) {
        PsiElement e = this.myExternalElements.get(name);
        if (e == null) {
            e = new GrammarUtil.FakeBnfExpression(EXTERNAL_TYPE, name);
            this.myExternalElements.put(name, e);
        }
        return e;
    }

    private static boolean isExternalPsi(PsiElement t) {
        return t instanceof LeafPsiElement && ((LeafPsiElement)t).getElementType() == EXTERNAL_TYPE;
    }

    public static enum Cardinality {
        NONE,
        OPTIONAL,
        REQUIRED,
        AT_LEAST_ONE,
        ANY_NUMBER;


        public boolean optional() {
            return this == OPTIONAL || this == ANY_NUMBER || this == NONE;
        }

        public boolean many() {
            return this == AT_LEAST_ONE || this == ANY_NUMBER;
        }

        public Cardinality single() {
            return this == AT_LEAST_ONE ? REQUIRED : (this == ANY_NUMBER ? OPTIONAL : this);
        }

        public static Cardinality fromNodeType(IElementType type) {
            if (type == BnfTypes.BNF_OP_OPT) {
                return OPTIONAL;
            }
            if (type == BnfTypes.BNF_SEQUENCE || type == BnfTypes.BNF_REFERENCE_OR_TOKEN) {
                return REQUIRED;
            }
            if (type == BnfTypes.BNF_CHOICE) {
                return OPTIONAL;
            }
            if (type == BnfTypes.BNF_OP_ONEMORE) {
                return AT_LEAST_ONE;
            }
            if (type == BnfTypes.BNF_OP_ZEROMORE) {
                return ANY_NUMBER;
            }
            throw new AssertionError((Object)("unexpected: " + type));
        }

        public Cardinality and(Cardinality c) {
            if (c == null) {
                return this;
            }
            if (this == NONE || c == NONE) {
                return NONE;
            }
            if (this.optional() || c.optional()) {
                return this.many() || c.many() ? ANY_NUMBER : OPTIONAL;
            }
            return this.many() || c.many() ? AT_LEAST_ONE : REQUIRED;
        }

        public Cardinality or(Cardinality c) {
            if (c == null) {
                c = NONE;
            }
            if (this == NONE && c == NONE) {
                return NONE;
            }
            if (this == NONE) {
                return c;
            }
            if (c == NONE) {
                return this;
            }
            return this.optional() && c.optional() ? ANY_NUMBER : AT_LEAST_ONE;
        }
    }
}

