/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.LinkedHashSet;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;

public class BnfDuplicateRuleInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        BnfDuplicateRuleInspection.checkFile(file, problemsHolder);
        return problemsHolder.getResultsArray();
    }

    private static void checkFile(PsiFile file, ProblemsHolder problemsHolder) {
        if (!(file instanceof BnfFile)) {
            return;
        }
        BnfFile bnfFile = (BnfFile)file;
        LinkedHashSet<BnfRule> rules = new LinkedHashSet<BnfRule>();
        for (BnfRule r : GrammarUtil.bnfTraverser((PsiElement)bnfFile).filter(BnfRule.class)) {
            BnfRule t;
            if (r == (t = bnfFile.getRule(r.getName()))) continue;
            rules.add(t);
            rules.add(r);
        }
        for (BnfRule rule : rules) {
            problemsHolder.registerProblem(rule.getId(), "'" + rule.getName() + "' rule is defined more than once", new LocalQuickFix[0]);
        }
    }
}

