/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.grammar.inspection.BnfRemoveExpressionFix;
import org.intellij.grammar.inspection.BnfUnreachableChoiceBranchInspection;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfVisitor;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;

public class BnfIdenticalChoiceBranchesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new BnfVisitor<Void>(){
            final HashSet<BnfExpression> set = new HashSet();

            @Override
            public Void visitChoice(@NotNull BnfChoice o) {
                BnfIdenticalChoiceBranchesInspection.checkChoice(o, this.set);
                for (BnfExpression e : this.set) {
                    BnfUnreachableChoiceBranchInspection.registerProblem(o, e, "Duplicate choice branch", holder, new BnfRemoveExpressionFix());
                }
                this.set.clear();
                return null;
            }
        };
    }

    private static void checkChoice(BnfChoice choice, Set<BnfExpression> set) {
        List<BnfExpression> list = choice.getExpressionList();
        for (BnfExpression e1 : list) {
            for (BnfExpression e2 : list) {
                if (e1 == e2 || !GrammarUtil.equalsElement(e1, e2)) continue;
                set.add(e1);
                set.add(e2);
            }
        }
    }
}

