/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.regex.Matcher;
import org.intellij.grammar.BnfLanguage;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfComposite;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfInspectionSuppressor
implements InspectionSuppressor {
    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        return new SuppressQuickFix[]{new MyFix(toolId, BnfRule.class), new MyFix(toolId, BnfAttr.class), new MyFix(toolId, BnfFile.class)};
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        PsiElement parent;
        if (!(element instanceof BnfComposite)) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (BnfInspectionSuppressor.isSuppressedInComment((PsiElement)file, toolId + "ForFile")) {
            return true;
        }
        JBIterable parents = SyntaxTraverser.psiApi().parents((Object)element);
        Iterator iterator = parents.iterator();
        while (iterator.hasNext() && (parent = (PsiElement)iterator.next()) != file) {
            if (!BnfInspectionSuppressor.isSuppressedInComment(parent, toolId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSuppressedInComment(@Nullable PsiElement root, @NotNull String toolId) {
        JBIterable leaves = root instanceof PsiFile ? JBIterable.generate((Object)PsiTreeUtil.getDeepestFirst((PsiElement)root), PsiTreeUtil::nextLeaf) : JBIterable.generate((Object)root, PsiTreeUtil::prevLeaf).skip(1);
        JBIterable comments = leaves.takeWhile(e -> e instanceof PsiWhiteSpace || e instanceof PsiComment || e instanceof BnfSequence && e.getTextLength() == 0).filter(PsiComment.class);
        for (PsiComment comment : comments) {
            Matcher matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(comment.getText());
            if (!matcher.matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) continue;
            return true;
        }
        return false;
    }

    private static class MyFix
    extends SuppressByCommentFix {
        MyFix(@NotNull String toolId, @NotNull Class<? extends PsiElement> clazz) {
            super((String)(BnfFile.class.isAssignableFrom(clazz) ? toolId + "ForFile" : toolId), clazz);
        }

        @NotNull
        public String getName() {
            String target;
            Class clazz = this.mySuppressionHolderClass;
            String string = BnfRule.class.isAssignableFrom(clazz) ? "rule" : (BnfAttr.class.isAssignableFrom(clazz) ? "attribute" : (target = BnfFile.class.isAssignableFrom(clazz) ? "file" : null));
            if (target == null) {
                throw new AssertionError(clazz);
            }
            return "Suppress for " + target;
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            if (container instanceof PsiFile) {
                String text = "noinspection " + this.myID;
                PsiComment comment = SuppressionUtil.createComment((Project)project, (String)text, (Language)BnfLanguage.INSTANCE);
                container.addAfter((PsiElement)comment, null);
            } else {
                super.createSuppression(project, element, container);
            }
        }
    }
}

