/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.inspection.CreateRuleFromTokenFix;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfVisitor;
import org.intellij.grammar.psi.impl.BnfRefOrTokenImpl;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;

public class BnfSuspiciousTokenInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new BnfVisitor<Void>(){

            @Override
            public Void visitRule(@NotNull BnfRule o) {
                if (ParserGeneratorUtil.Rule.isExternal(o)) {
                    return null;
                }
                JBIterable tokens = ((SyntaxTraverser)GrammarUtil.bnfTraverser(o.getExpression()).expand(s -> !(s instanceof BnfExternalExpression))).filter(BnfRefOrTokenImpl.class);
                for (BnfRefOrTokenImpl token : tokens) {
                    PsiReference reference = token.getReference();
                    PsiElement resolve = reference == null ? null : reference.resolve();
                    String text = token.getText();
                    if (resolve != null || tokens.contains((Object)text) || !BnfSuspiciousTokenInspection.isTokenTextSuspicious(text)) continue;
                    holder.registerProblem((PsiElement)token, "'" + text + "' token looks like a reference to a missing rule", new LocalQuickFix[]{new CreateRuleFromTokenFix(text)});
                }
                return null;
            }
        };
    }

    public static boolean isTokenTextSuspicious(String text) {
        boolean isLowercase = text.equals(text.toLowerCase());
        boolean isUppercase = !isLowercase && text.equals(text.toUpperCase());
        return !isLowercase && !isUppercase || isLowercase && StringUtil.containsAnyChar((String)text, (String)"-_");
    }
}

