/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfStringLiteralExpression;
import org.intellij.grammar.psi.impl.BnfReferenceImpl;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfUnusedRuleInspection
extends LocalInspectionTool {
    public boolean runForWholeFile() {
        return true;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!(file instanceof BnfFile)) {
            return null;
        }
        if (SuppressionUtil.inspectionResultSuppressed((PsiElement)file, (LocalInspectionTool)this)) {
            return null;
        }
        BnfFile myFile = (BnfFile)file;
        JBIterable rules = JBIterable.from(myFile.getRules());
        if (rules.isEmpty()) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        HashSet<BnfRule> roots = new HashSet<BnfRule>();
        HashSet inExpr = new HashSet();
        final HashSet<BnfRule> inParsing = new HashSet<BnfRule>();
        final HashSet<BnfRule> inSuppressed = new HashSet<BnfRule>();
        HashMap<BnfRule, String> inAttrs = new HashMap<BnfRule, String>();
        GrammarUtil.bnfTraverserNoAttrs((PsiElement)myFile).traverse().filterMap(BnfUnusedRuleInspection::resolveRule).addAllTo(inExpr);
        roots.add((BnfRule)rules.first());
        for (BnfRule rule : rules) {
            if (Boolean.TRUE.equals(ParserGeneratorUtil.getAttribute(rule, KnownAttribute.EXTRA_ROOT))) {
                roots.add(rule);
            }
            if (!SuppressionUtil.inspectionResultSuppressed((PsiElement)rule, (LocalInspectionTool)this)) continue;
            inSuppressed.add(rule);
        }
        inParsing.addAll(roots);
        int size = 0;
        int prev = -1;
        while (size != prev) {
            ((SyntaxTraverser)GrammarUtil.bnfTraverserNoAttrs((PsiElement)myFile).expand((Condition)new Condition<PsiElement>(){

                public boolean value(PsiElement element) {
                    if (element instanceof BnfRule) {
                        BnfRule rule = (BnfRule)element;
                        BnfAttr recoverAttr = ParserGeneratorUtil.findAttribute(rule, KnownAttribute.RECOVER_WHILE);
                        this.value(recoverAttr == null ? null : recoverAttr.getExpression());
                        return inParsing.contains(rule) || inSuppressed.contains(rule);
                    }
                    if (element instanceof BnfReferenceOrToken) {
                        ContainerUtil.addIfNotNull((Collection)inParsing, (Object)((BnfReferenceOrToken)element).resolveRule());
                        return false;
                    }
                    return true;
                }
            })).traverse().size();
            prev = size;
            size = inParsing.size();
        }
        for (BnfAttr attr : GrammarUtil.bnfTraverser((PsiElement)myFile).filter(BnfAttr.class)) {
            BnfRule target = BnfUnusedRuleInspection.resolveRule(attr.getExpression());
            if (target == null) continue;
            inAttrs.put(target, attr.getName());
        }
        for (BnfRule r : rules.filter(o -> !roots.contains(o) && !inSuppressed.contains(o))) {
            String message = null;
            if (ParserGeneratorUtil.Rule.isFake(r)) {
                if (inExpr.contains(r)) {
                    message = "Reachable fake rule";
                } else if (!inAttrs.containsKey(r)) {
                    message = "Unused fake rule";
                }
            } else if (KnownAttribute.getCompatibleAttribute((String)inAttrs.get(r)) == KnownAttribute.RECOVER_WHILE) {
                if (!ParserGeneratorUtil.Rule.isPrivate(r)) {
                    message = "Non-private recovery rule";
                }
            } else if (!inExpr.contains(r)) {
                message = "Unused rule";
            } else if (!inParsing.contains(r)) {
                message = "Unreachable rule";
            }
            if (message == null) continue;
            holder.registerProblem(r.getId(), message, new LocalQuickFix[0]);
        }
        return holder.getResultsArray();
    }

    @Nullable
    private static BnfRule resolveRule(@Nullable PsiElement o) {
        if (!(o instanceof BnfReferenceOrToken) && !(o instanceof BnfStringLiteralExpression)) {
            return null;
        }
        PsiReference reference = (PsiReference)ContainerUtil.findInstance((Object[])o.getReferences(), BnfReferenceImpl.class);
        PsiElement target = reference != null ? reference.resolve() : null;
        return target instanceof BnfRule ? (BnfRule)target : null;
    }
}

