/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.intention;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.grammar.GrammarKitBundle;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfParenOptExpression;
import org.intellij.grammar.psi.BnfParenthesized;
import org.intellij.grammar.psi.BnfQuantified;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BnfConvertOptExpressionIntention
extends BaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return GrammarKitBundle.message("intention.convert.opt.expression.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (editor == null || file == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.getViewProvider().findElementAt(offset);
        if (BnfConvertOptExpressionIntention.getQuantifiedOptExpression(element) != null) {
            this.setText(GrammarKitBundle.message("intention.convert.opt.expression.text1", new Object[0]));
            return true;
        }
        if (BnfConvertOptExpressionIntention.getParenOptExpression(element) != null) {
            this.setText(GrammarKitBundle.message("intention.convert.opt.expression.text2", new Object[0]));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.getViewProvider().findElementAt(offset);
        BnfQuantified quantified = BnfConvertOptExpressionIntention.getQuantifiedOptExpression(element);
        if (quantified != null) {
            BnfConvertOptExpressionIntention.handleQuantifier(project, quantified);
            return;
        }
        BnfParenOptExpression parenOpt = BnfConvertOptExpressionIntention.getParenOptExpression(element);
        if (parenOpt != null) {
            BnfConvertOptExpressionIntention.handleParenOpt(project, parenOpt);
        }
    }

    @Nullable
    private static BnfQuantified getQuantifiedOptExpression(PsiElement element) {
        BnfQuantified quantified = (BnfQuantified)PsiTreeUtil.getParentOfType((PsiElement)element, BnfQuantified.class);
        return quantified != null && quantified.getQuantifier().getNode().getFirstChildNode().getElementType() == BnfTypes.BNF_OP_OPT ? quantified : null;
    }

    @Contract(value="null -> null")
    private static BnfParenOptExpression getParenOptExpression(PsiElement element) {
        return (BnfParenOptExpression)PsiTreeUtil.getParentOfType((PsiElement)element, BnfParenOptExpression.class);
    }

    private static void handleQuantifier(@NotNull Project project, @NotNull BnfQuantified expr) {
        BnfExpression operand = BnfConvertOptExpressionIntention.skipParenthesesDown(expr.getExpression());
        String newText = "[" + operand.getText() + "]";
        expr.replace(BnfElementFactory.createExpressionFromText(project, newText));
    }

    private static void handleParenOpt(@NotNull Project project, @NotNull BnfParenOptExpression expr) {
        BnfExpression operand = BnfConvertOptExpressionIntention.skipBracketsDown(expr.getExpression());
        String newText = BnfConvertOptExpressionIntention.isSimple(operand) ? operand.getText() + "?" : "(" + operand.getText() + ")?";
        expr.replace(BnfElementFactory.createExpressionFromText(project, newText));
    }

    private static BnfExpression skipParenthesesDown(BnfExpression expr) {
        while (expr instanceof BnfParenthesized) {
            expr = ((BnfParenthesized)expr).getExpression();
        }
        return expr;
    }

    private static BnfExpression skipBracketsDown(BnfExpression expr) {
        while (expr instanceof BnfParenOptExpression) {
            expr = ((BnfParenOptExpression)expr).getExpression();
        }
        return expr;
    }

    @Contract(pure=true)
    private static boolean isSimple(@NotNull BnfExpression expression) {
        return expression instanceof BnfReferenceOrToken || expression instanceof BnfLiteralExpression || expression instanceof BnfParenthesized || expression instanceof BnfExternalExpression;
    }
}

