/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.grammar.livePreview.LivePreviewHelper;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfFile;
import org.jetbrains.annotations.NotNull;

public class GrammarAtCaretPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    public static final Key<Boolean> GRAMMAR_AT_CARET_KEY = Key.create((String)"GRAMMAR_AT_CARET_KEY");

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file, final @NotNull Editor editor) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        if (editor.isOneLineMode()) {
            return null;
        }
        if (!(file instanceof BnfFile)) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !FileEditorManager.getInstance((Project)file.getProject()).isFileOpen(virtualFile)) {
            return null;
        }
        return new TextEditorHighlightingPass(file.getProject(), editor.getDocument(), false){
            final List<HighlightInfo> infos;
            {
                super(arg0, arg1, arg2);
                this.infos = new ArrayList<HighlightInfo>();
            }

            public void doCollectInformation(@NotNull ProgressIndicator progress) {
                this.infos.clear();
                LivePreviewLanguage previewLanguage = LivePreviewLanguage.findInstance(file);
                if (previewLanguage == null) {
                    return;
                }
                List<Editor> previewEditors = previewLanguage.getPreviewEditors(this.myProject);
                for (Editor e : previewEditors) {
                    if (!Boolean.TRUE.equals(GRAMMAR_AT_CARET_KEY.get((UserDataHolder)e))) continue;
                    GrammarAtCaretPassFactory.collectHighlighters(this.myProject, previewEditors.get(0), previewLanguage, this.infos);
                }
            }

            public void doApplyInformationToEditor() {
                Document document = editor.getDocument();
                UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)document, (int)0, (int)file.getTextLength(), this.infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
            }
        };
    }

    private static void collectHighlighters(@NotNull Project project, @NotNull Editor editor, @NotNull LivePreviewLanguage livePreviewLanguage, @NotNull List<HighlightInfo> result) {
        HashSet<TextRange> trueRanges = new HashSet<TextRange>();
        HashSet<TextRange> falseRanges = new HashSet<TextRange>();
        HashSet visited = new HashSet();
        LivePreviewHelper.collectExpressionsAtOffset(project, editor, livePreviewLanguage, (PairProcessor<? super BnfExpression, ? super Boolean>)((PairProcessor)(bnfExpression, result1) -> {
            PsiElement parent = bnfExpression.getParent();
            while (parent instanceof BnfExpression && visited.add((BnfExpression)parent)) {
                parent = parent.getParent();
            }
            if (visited.add(bnfExpression)) {
                (result1 != false ? trueRanges : falseRanges).add(bnfExpression.getTextRange());
            }
            return true;
        }));
        GrammarAtCaretPassFactory.createHighlights(trueRanges, falseRanges, result);
    }

    private static void createHighlights(Set<TextRange> trueRanges, Set<TextRange> falseRanges, List<HighlightInfo> result) {
        HighlightInfo info;
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes trueAttrs = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes falseAttrs = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        for (TextRange range : trueRanges) {
            info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(range).textAttributes(trueAttrs).createUnconditionally();
            result.add(info);
        }
        for (TextRange range : falseRanges) {
            info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(range).textAttributes(falseAttrs).createUnconditionally();
            result.add(info);
        }
    }
}

