/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.grammar.KnownAttribute;
import org.intellij.grammar.analysis.BnfFirstNextAnalyzer;
import org.intellij.grammar.generator.Case;
import org.intellij.grammar.generator.ExpressionGeneratorHelper;
import org.intellij.grammar.generator.ExpressionHelper;
import org.intellij.grammar.generator.GenOptions;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.generator.RuleGraphHelper;
import org.intellij.grammar.livePreview.LiveHooksHelper;
import org.intellij.grammar.livePreview.LivePreviewElementType;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.livePreview.LivePreviewLexer;
import org.intellij.grammar.parser.GeneratedParserUtilBase;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfExternalExpression;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreviewParser
implements PsiParser {
    private static final Logger LOG = Logger.getInstance(LivePreviewParser.class);
    private final BnfFile myFile;
    private final LivePreviewLanguage myLanguage;
    private final Map<String, String> mySimpleTokens = new LinkedHashMap<String, String>();
    private final Map<String, IElementType> myRuleElementTypes = new HashMap<String, IElementType>();
    private final Map<String, IElementType> myTokenElementTypes = new HashMap<String, IElementType>();
    private GenOptions G;
    private BnfRule myGrammarRoot;
    private RuleGraphHelper myGraphHelper;
    private ExpressionHelper myExpressionHelper;
    private MultiMap<BnfRule, BnfRule> myRuleExtendsMap;
    private BnfFirstNextAnalyzer myFirstNextAnalyzer;
    private String myTokenTypeText;
    private final Object2IntMap<BnfRule> myRuleNumbers = new Object2IntOpenHashMap();
    private BitSet[] myBitSets;

    public LivePreviewParser(Project project, LivePreviewLanguage language) {
        this.myLanguage = language;
        this.myFile = language.getGrammar(project);
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType type, @NotNull PsiBuilder originalBuilder) {
        this.init(originalBuilder);
        PsiBuilder builder = GeneratedParserUtilBase.adapt_builder_(type, originalBuilder, this);
        GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).altExtendsChecker = this::type_extends_;
        ArrayList braces = new ArrayList();
        ContainerUtil.addIfNotNull(braces, (Object)this.tryMakeBracePair("{", "}", true));
        ContainerUtil.addIfNotNull(braces, (Object)this.tryMakeBracePair("(", ")", false));
        ContainerUtil.addIfNotNull(braces, (Object)this.tryMakeBracePair("[", "]", false));
        ContainerUtil.addIfNotNull(braces, (Object)this.tryMakeBracePair("<", ">", false));
        GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).braces = braces.isEmpty() ? null : braces.toArray(new BracePair[0]);
        boolean result = true;
        PsiBuilder.Marker marker = GeneratedParserUtilBase.enter_section_(builder, 0, 1, null);
        if (this.myGrammarRoot != null) {
            result = this.rule(builder, 1, this.myGrammarRoot, Collections.emptyMap());
        }
        GeneratedParserUtilBase.exit_section_(builder, 0, marker, type, result, true, GeneratedParserUtilBase.TRUE_CONDITION);
        return builder.getTreeBuilt();
    }

    @Nullable
    private BracePair tryMakeBracePair(String s1, String s2, boolean structural) {
        IElementType t1 = this.getTokenElementType(this.getTokenName(s1));
        IElementType t2 = this.getTokenElementType(this.getTokenName(s2));
        return t1 != null && t2 != null ? new BracePair(t1, t2, structural) : null;
    }

    /*
     * WARNING - void declaration
     */
    private void init(PsiBuilder builder) {
        void var4_10;
        if (this.myFile == null) {
            return;
        }
        this.myGrammarRoot = (BnfRule)ContainerUtil.getFirstItem(this.myFile.getRules());
        this.G = new GenOptions(this.myFile);
        this.mySimpleTokens.putAll(LivePreviewLexer.collectTokenPattern2Name(this.myFile, null));
        this.myGraphHelper = RuleGraphHelper.getCached(this.myFile);
        this.myRuleExtendsMap = this.myGraphHelper.getRuleExtendsMap();
        this.myExpressionHelper = ExpressionHelper.getCached(this.myFile);
        this.myFirstNextAnalyzer = BnfFirstNextAnalyzer.createAnalyzer(true);
        this.myTokenTypeText = ParserGeneratorUtil.getRootAttribute((PsiElement)this.myFile, KnownAttribute.ELEMENT_TYPE_PREFIX);
        Lexer lexer = ((PsiBuilderImpl)builder).getLexer();
        if (lexer instanceof LivePreviewLexer) {
            for (LivePreviewLexer.Token token : ((LivePreviewLexer)lexer).getTokens()) {
                this.myTokenElementTypes.put(token.constantName, token.tokenType);
            }
        }
        for (BnfRule bnfRule : this.myFile.getRules()) {
            String elementType = ParserGeneratorUtil.getElementType(bnfRule, this.G.generateElementCase);
            if (StringUtil.isEmpty((String)elementType) || this.myRuleElementTypes.containsKey(elementType)) continue;
            this.myRuleElementTypes.put(elementType, new LivePreviewElementType.RuleType(elementType, bnfRule, this.myLanguage));
        }
        int count = 0;
        for (BnfRule rule : this.myFile.getRules()) {
            this.myRuleNumbers.put((Object)rule, count++);
        }
        this.myBitSets = new BitSet[builder.getOriginalText().length() + 1];
        boolean bl = false;
        while (var4_10 < this.myBitSets.length) {
            this.myBitSets[var4_10] = new BitSet(count);
            ++var4_10;
        }
    }

    private boolean rule(PsiBuilder builder, int level, BnfRule rule, Map<String, GeneratedParserUtilBase.Parser> externalArguments) {
        int ruleNumber;
        BitSet bitSet = this.myBitSets[builder.getCurrentOffset()];
        if (bitSet.get(ruleNumber = this.myRuleNumbers.getInt((Object)rule))) {
            builder.error("Endless recursion detected for '" + rule.getName() + "'");
            return false;
        }
        bitSet.set(ruleNumber);
        boolean result = this.expression(builder, level, rule, rule.getExpression(), rule.getName(), externalArguments);
        bitSet.clear(ruleNumber);
        return result;
    }

    protected boolean expression(PsiBuilder builder, int level, BnfRule rule, BnfExpression initialNode, String funcName, Map<String, GeneratedParserUtilBase.Parser> externalArguments) {
        boolean success;
        boolean sectionMaybeDropped;
        String frameName;
        List<BnfExpression> children;
        boolean isRule = initialNode.getParent() == rule;
        BnfExpression node = ParserGeneratorUtil.getNonTrivialNode(initialNode);
        IElementType type = ParserGeneratorUtil.getEffectiveType(node);
        boolean firstNonTrivial = node == ParserGeneratorUtil.Rule.firstNotTrivial(rule);
        boolean isPrivate = !isRule && !firstNonTrivial || ParserGeneratorUtil.Rule.isPrivate(rule) || this.myGrammarRoot == rule;
        boolean isLeft = firstNonTrivial && ParserGeneratorUtil.Rule.isLeft(rule);
        boolean isLeftInner = isLeft && (isPrivate || ParserGeneratorUtil.Rule.isInner(rule));
        boolean isBranch = !isPrivate && ParserGeneratorUtil.Rule.isUpper(rule);
        String recoverWhile = firstNonTrivial ? ParserGeneratorUtil.getAttribute(rule, KnownAttribute.RECOVER_WHILE) : null;
        Map hooks = firstNonTrivial ? ParserGeneratorUtil.getAttribute(rule, KnownAttribute.HOOKS).asMap() : Collections.emptyMap();
        boolean canCollapse = !isPrivate && (!isLeft || isLeftInner) && firstNonTrivial && this.myGraphHelper.canCollapse(rule);
        IElementType elementType = !isPrivate ? this.getRuleElementType(rule) : null;
        boolean isSingleNode = node instanceof BnfReferenceOrToken || node instanceof BnfLiteralExpression || node instanceof BnfExternalExpression;
        List<BnfExpression> list = children = isSingleNode ? Collections.singletonList(node) : ParserGeneratorUtil.getChildExpressions(node);
        String string = !children.isEmpty() && firstNonTrivial && !ParserGeneratorUtil.Rule.isMeta(rule) ? ParserGeneratorUtil.getRuleDisplayName(rule, !isPrivate) : (frameName = null);
        if (isSingleNode) {
            children = Collections.singletonList(node);
            if (isPrivate && !isLeftInner && recoverWhile == null && frameName == null) {
                return this.generateNodeCall(builder, level, rule, node, ParserGeneratorUtil.getNextName(funcName, 0), externalArguments);
            }
            type = BnfTypes.BNF_SEQUENCE;
        }
        if (!children.isEmpty() && !GeneratedParserUtilBase.recursion_guard_(builder, level, funcName)) {
            return false;
        }
        ParserGeneratorUtil.PinMatcher pinMatcher = new ParserGeneratorUtil.PinMatcher(rule, type, firstNonTrivial ? rule.getName() : funcName);
        boolean pinApplied = false;
        boolean alwaysTrue = type == BnfTypes.BNF_OP_OPT || type == BnfTypes.BNF_OP_ZEROMORE;
        boolean result_ = type == BnfTypes.BNF_OP_ZEROMORE || type == BnfTypes.BNF_OP_OPT || children.isEmpty();
        boolean pinned = pinMatcher.active();
        boolean pinned_ = false;
        int modifiers = 0;
        if (canCollapse) {
            modifiers |= 1;
        }
        if (isLeftInner) {
            modifiers |= 4;
        } else if (isLeft) {
            modifiers |= 2;
        }
        if (type == BnfTypes.BNF_OP_AND) {
            modifiers |= 8;
        } else if (type == BnfTypes.BNF_OP_NOT) {
            modifiers |= 0x10;
        }
        if (isBranch) {
            modifiers |= 0x20;
        }
        PsiBuilder.Marker marker_ = null;
        boolean sectionRequired = !alwaysTrue || !isPrivate || isLeft || recoverWhile != null;
        boolean sectionRequiredSimple = sectionRequired && modifiers == 0 && recoverWhile == null && !pinned && frameName == null;
        boolean bl = sectionMaybeDropped = sectionRequiredSimple && type == BnfTypes.BNF_CHOICE && elementType == null && !ContainerUtil.exists(children, o -> ParserGeneratorUtil.isRollbackRequired(o, this.myFile));
        if (sectionRequiredSimple) {
            if (!sectionMaybeDropped) {
                marker_ = GeneratedParserUtilBase.enter_section_(builder);
            }
        } else if (sectionRequired) {
            marker_ = GeneratedParserUtilBase.enter_section_(builder, level, modifiers, elementType, frameName);
        }
        int[] skip = new int[]{0};
        int p = 0;
        int childrenSize = children.size();
        for (int i = 0; i < childrenSize; ++i) {
            BnfExpression child = children.get(i);
            if (type == BnfTypes.BNF_CHOICE) {
                if (i == 0) {
                    result_ = this.generateNodeCall(builder, level, rule, child, ParserGeneratorUtil.getNextName(funcName, i), externalArguments);
                    continue;
                }
                if (result_) continue;
                result_ = this.generateNodeCall(builder, level, rule, child, ParserGeneratorUtil.getNextName(funcName, i), externalArguments);
                continue;
            }
            if (type == BnfTypes.BNF_SEQUENCE) {
                if (skip[0] == 0) {
                    result_ = i == 0 ? this.generateTokenSequenceCall(builder, level, rule, children, funcName, i, pinMatcher, pinApplied, skip, externalArguments) : (pinApplied && this.G.generateExtendedPin ? (i == childrenSize - 1 ? (i == p + 1 ? result_ && this.generateTokenSequenceCall(builder, level, rule, children, funcName, i, pinMatcher, pinApplied, skip, externalArguments) : pinned_ && this.generateTokenSequenceCall(builder, level, rule, children, funcName, i, pinMatcher, pinApplied, skip, externalArguments) && result_) : (i == p + 1 ? result_ && GeneratedParserUtilBase.report_error_(builder, this.generateTokenSequenceCall(builder, level, rule, children, funcName, i, pinMatcher, pinApplied, skip, externalArguments)) : pinned_ && GeneratedParserUtilBase.report_error_(builder, this.generateTokenSequenceCall(builder, level, rule, children, funcName, i, pinMatcher, pinApplied, skip, externalArguments)) && result_)) : result_ && this.generateTokenSequenceCall(builder, level, rule, children, funcName, i, pinMatcher, pinApplied, skip, externalArguments));
                } else {
                    skip[0] = skip[0] - 1;
                    if (pinApplied && i == p + 1) {
                        ++p;
                    }
                }
                if (pinApplied || !pinMatcher.matches(i, child)) continue;
                pinApplied = true;
                p = i;
                pinned_ = result_;
                continue;
            }
            if (type == BnfTypes.BNF_OP_OPT) {
                this.generateNodeCall(builder, level, rule, child, ParserGeneratorUtil.getNextName(funcName, i), externalArguments);
                continue;
            }
            if (type == BnfTypes.BNF_OP_ONEMORE || type == BnfTypes.BNF_OP_ZEROMORE) {
                if (type == BnfTypes.BNF_OP_ONEMORE) {
                    result_ = this.generateNodeCall(builder, level, rule, child, ParserGeneratorUtil.getNextName(funcName, i), externalArguments);
                }
                int pos = GeneratedParserUtilBase.current_position_(builder);
                while ((alwaysTrue || result_) && this.generateNodeCall(builder, level, rule, child, ParserGeneratorUtil.getNextName(funcName, i), externalArguments) && GeneratedParserUtilBase.empty_element_parsed_guard_(builder, funcName, pos)) {
                    pos = GeneratedParserUtilBase.current_position_(builder);
                }
                continue;
            }
            if (type == BnfTypes.BNF_OP_AND) {
                result_ = this.generateNodeCall(builder, level, rule, child, ParserGeneratorUtil.getNextName(funcName, i), externalArguments);
                continue;
            }
            if (type == BnfTypes.BNF_OP_NOT) {
                result_ = !this.generateNodeCall(builder, level, rule, child, ParserGeneratorUtil.getNextName(funcName, i), externalArguments);
                continue;
            }
            LOG.warn("unexpected: " + type);
        }
        boolean bl2 = success = alwaysTrue || result_ || pinned_;
        if (!hooks.isEmpty()) {
            for (Map.Entry entry : hooks.entrySet()) {
                if (entry.getValue() == null) continue;
                String name = ParserGeneratorUtil.toIdentifier((String)entry.getKey(), null, Case.UPPER);
                LiveHooksHelper.registerHook(builder, name, (String)entry.getValue());
            }
        }
        if (sectionRequiredSimple) {
            if (!sectionMaybeDropped) {
                GeneratedParserUtilBase.exit_section_(builder, marker_, elementType, alwaysTrue || result_);
            }
        } else if (sectionRequired) {
            GeneratedParserUtilBase.Parser recoverPredicate;
            BnfRule recoverRule;
            BnfRule bnfRule = recoverRule = recoverWhile != null ? this.myFile.getRule(recoverWhile) : null;
            if ("#auto".equals(recoverWhile)) {
                IElementType[] nextTokens = this.generateAutoRecoverCall(rule);
                recoverPredicate = (builder12, level12) -> !GeneratedParserUtilBase.nextTokenIsFast(builder12, nextTokens);
            } else {
                recoverPredicate = ParserGeneratorUtil.Rule.isMeta(rule) && GrammarUtil.isDoubleAngles(recoverWhile) ? externalArguments.get(recoverWhile.substring(2, recoverWhile.length() - 2)) : (recoverRule == null ? null : (builder1, level1) -> this.rule(builder1, level1, recoverRule, Collections.emptyMap()));
            }
            GeneratedParserUtilBase.exit_section_(builder, level, marker_, alwaysTrue || result_, pinned_, recoverPredicate);
        }
        return success;
    }

    private boolean type_extends_(IElementType elementType1, IElementType elementType2) {
        if (elementType1 == elementType2) {
            return true;
        }
        if (!(elementType1 instanceof LivePreviewElementType.RuleType)) {
            return false;
        }
        if (!(elementType2 instanceof LivePreviewElementType.RuleType)) {
            return false;
        }
        for (BnfRule baseRule : this.myRuleExtendsMap.keySet()) {
            Collection ruleClass = this.myRuleExtendsMap.get((Object)baseRule);
            BnfRule r1 = this.myFile.getRule(((LivePreviewElementType.RuleType)elementType1).ruleName);
            BnfRule r2 = this.myFile.getRule(((LivePreviewElementType.RuleType)elementType2).ruleName);
            if (!ruleClass.contains(r1) || !ruleClass.contains(r2)) continue;
            return true;
        }
        return false;
    }

    protected boolean generateNodeCall(PsiBuilder builder, int level, BnfRule rule, @Nullable BnfExpression node, String nextName, Map<String, GeneratedParserUtilBase.Parser> externalArguments) {
        String text;
        IElementType type = node == null ? BnfTypes.BNF_REFERENCE_OR_TOKEN : ParserGeneratorUtil.getEffectiveType(node);
        String string = text = node == null ? nextName : node.getText();
        if (type == BnfTypes.BNF_STRING) {
            String value = GrammarUtil.unquote(text);
            String attributeName = this.getTokenName(value);
            if (attributeName != null) {
                return this.generateConsumeToken(builder, attributeName);
            }
            return this.generateConsumeTextToken(builder, value);
        }
        if (type == BnfTypes.BNF_NUMBER) {
            return this.generateConsumeTextToken(builder, text);
        }
        if (type == BnfTypes.BNF_REFERENCE_OR_TOKEN) {
            BnfRule subRule = this.myFile.getRule(text);
            if (subRule != null) {
                int arg1Priority;
                if (ParserGeneratorUtil.Rule.isExternal(subRule)) {
                    return false;
                }
                ExpressionHelper.ExpressionInfo info = ExpressionGeneratorHelper.getInfoForExpressionParsing(this.myExpressionHelper, subRule);
                if (info == null) {
                    return this.rule(builder, level + 1, subRule, externalArguments);
                }
                int priority = info.getPriority(rule);
                int n = arg1Priority = subRule == info.rootRule ? -1 : info.getPriority(subRule);
                int argPriority = arg1Priority == -1 ? (priority == info.nextPriority - 1 ? -1 : priority) : arg1Priority - 1;
                return this.generateExpressionRoot(builder, level, info, argPriority);
            }
            return this.generateConsumeToken(builder, text);
        }
        if (type == BnfTypes.BNF_EXTERNAL_EXPRESSION) {
            List<BnfExpression> expressions = ((BnfExternalExpression)node).getExpressionList();
            if (expressions.size() == 1 && ParserGeneratorUtil.Rule.isMeta(rule)) {
                GeneratedParserUtilBase.Parser parser = externalArguments.get(node.getText());
                return parser != null && parser.parse(builder, level);
            }
            return this.generateExternalCall(builder, level, rule, expressions, nextName, externalArguments);
        }
        return this.expression(builder, level, rule, node, nextName, externalArguments);
    }

    private boolean generateTokenSequenceCall(PsiBuilder builder, int level, BnfRule rule, List<BnfExpression> children, String funcName, int startIndex, ParserGeneratorUtil.PinMatcher pinMatcher, boolean pinApplied, int[] skip, Map<String, GeneratedParserUtilBase.Parser> externalArguments) {
        BnfExpression nextChild = children.get(startIndex);
        if (startIndex == children.size() - 1 || !this.isTokenExpression(nextChild)) {
            return this.generateNodeCall(builder, level, rule, nextChild, funcName, externalArguments);
        }
        ArrayList<IElementType> list = new ArrayList<IElementType>();
        int pin = pinApplied ? -1 : 0;
        int len = children.size();
        for (int i = startIndex; i < len; ++i) {
            String tokenName;
            BnfExpression child = children.get(i);
            IElementType type = child.getNode().getElementType();
            String text = child.getText();
            if (type == BnfTypes.BNF_STRING && text.charAt(0) != '\"') {
                tokenName = this.getTokenName(GrammarUtil.unquote(text));
            } else {
                if (type != BnfTypes.BNF_REFERENCE_OR_TOKEN || this.myFile.getRule(text) != null) break;
                tokenName = text;
            }
            list.add(this.getTokenElementType(tokenName));
            if (pinApplied || !pinMatcher.matches(i, child)) continue;
            pin = i - startIndex + 1;
        }
        if (list.size() < 2) {
            return this.generateNodeCall(builder, level, rule, nextChild, funcName, externalArguments);
        }
        skip[0] = list.size() - 1;
        return GeneratedParserUtilBase.consumeTokens(builder, pin, list.toArray(IElementType.EMPTY_ARRAY));
    }

    private boolean generateExternalCall(PsiBuilder builder, int level, BnfRule rule, List<BnfExpression> expressions, String nextName, Map<String, GeneratedParserUtilBase.Parser> externalArguments) {
        List<String> metaParameterNames;
        BnfRule targetRule;
        List callParameters = expressions;
        String method = expressions.size() > 0 ? expressions.get(0).getText() : null;
        BnfRule bnfRule = targetRule = method == null ? null : this.myFile.getRule(method);
        if (targetRule != null) {
            metaParameterNames = GrammarUtil.collectMetaParameters(targetRule, targetRule.getExpression());
            if (ParserGeneratorUtil.Rule.isExternal(targetRule)) {
                callParameters = GrammarUtil.getExternalRuleExpressions(targetRule);
                method = callParameters.get(0).getText();
                if (metaParameterNames.size() < expressions.size() - 1) {
                    callParameters = ContainerUtil.concat(callParameters, expressions.subList(metaParameterNames.size() + 1, expressions.size()));
                }
                if (this.myFile.getRule(method) == null) {
                    return false;
                }
            }
        } else {
            if ("eof".equals(method) && expressions.size() == 1) {
                return GeneratedParserUtilBase.eof(builder, level);
            }
            if ("anything".equals(method) && expressions.size() == 2) {
                BnfExpression finalNested = expressions.get(1);
                GeneratedParserUtilBase.parseAsTree(GeneratedParserUtilBase.ErrorState.get(builder), builder, level + 1, GeneratedParserUtilBase.DUMMY_BLOCK, true, GeneratedParserUtilBase.TOKEN_ADVANCER, (builder14, level14) -> this.generateNodeCall(builder14, level14, rule, finalNested, ParserGeneratorUtil.getNextName(nextName, 0), Collections.emptyMap()));
                return true;
            }
            return false;
        }
        if (callParameters.size() <= 1) {
            return this.rule(builder, level, targetRule, externalArguments);
        }
        HashMap<String, GeneratedParserUtilBase.Parser> argumentMap = new HashMap<String, GeneratedParserUtilBase.Parser>();
        int len = Math.min(callParameters.size(), metaParameterNames.size() + 1);
        for (int i = 1; i < len; ++i) {
            String argNextName;
            int metaIdx;
            BnfExpression nested = callParameters.get(i);
            String argument = nested.getText();
            String argName = metaParameterNames.get(i - 1);
            if (argument.startsWith("<<") && (metaIdx = metaParameterNames.indexOf(argument)) > -1) {
                nested = (BnfExpression)expressions.get(metaIdx + 1);
                argNextName = ParserGeneratorUtil.getNextName(nextName, metaIdx);
            } else {
                argNextName = ParserGeneratorUtil.getNextName(nextName, i - 1);
            }
            BnfExpression finalNested = nested;
            if (nested instanceof BnfReferenceOrToken || nested instanceof BnfLiteralExpression) {
                BnfRule argRule = nested instanceof BnfReferenceOrToken ? this.myFile.getRule(nested.getText()) : null;
                argumentMap.put(argName, (builder13, level13) -> {
                    if (argRule != null) {
                        return this.rule(builder13, level13, argRule, Collections.emptyMap());
                    }
                    return this.generateNodeCall(builder13, level13, rule, finalNested, nextName, Collections.emptyMap());
                });
                continue;
            }
            if (nested instanceof BnfExternalExpression) {
                boolean metaRule;
                List<BnfExpression> expressionList = ((BnfExternalExpression)nested).getExpressionList();
                boolean bl = metaRule = ParserGeneratorUtil.Rule.isMeta(rule) || ParserGeneratorUtil.Rule.isExternal(rule);
                if (metaRule && expressionList.size() == 1) {
                    argumentMap.put(argName, externalArguments.get("<<" + expressionList.get(0).getText() + ">>"));
                    continue;
                }
                argumentMap.put(argName, (builder12, level12) -> this.generateNodeCall(builder12, level12, targetRule, finalNested, argNextName, externalArguments));
                continue;
            }
            argumentMap.put(argName, (builder1, level1) -> this.generateNodeCall(builder1, level1, targetRule, finalNested, argNextName, externalArguments));
        }
        if (ParserGeneratorUtil.Rule.isExternal(targetRule)) {
            return this.generateExternalCall(builder, level, targetRule, callParameters, targetRule.getName(), argumentMap);
        }
        return this.rule(builder, level, targetRule, argumentMap);
    }

    private String getTokenName(String value) {
        return this.mySimpleTokens.get(value);
    }

    @Nullable
    private IElementType getRuleElementType(BnfRule rule) {
        String elementType = ParserGeneratorUtil.getElementType(rule, this.G.generateElementCase);
        return StringUtil.isEmpty((String)elementType) ? null : this.myRuleElementTypes.get(elementType);
    }

    private IElementType getTokenElementType(String token) {
        return token == null ? null : this.myTokenElementTypes.get(this.myTokenTypeText + token.toUpperCase());
    }

    private boolean generateConsumeToken(PsiBuilder builder, String tokenName) {
        IElementType tokenType = this.getTokenElementType(tokenName);
        return tokenType != null && this.generateConsumeToken(builder, tokenType);
    }

    protected boolean generateConsumeToken(PsiBuilder builder, @NotNull IElementType tokenType) {
        return GeneratedParserUtilBase.consumeToken(builder, tokenType);
    }

    protected boolean generateConsumeTextToken(PsiBuilder builder, @NotNull String tokenText) {
        return GeneratedParserUtilBase.consumeToken(builder, tokenText);
    }

    protected boolean isTokenExpression(BnfExpression node) {
        return node instanceof BnfLiteralExpression || node instanceof BnfReferenceOrToken && this.myFile.getRule(node.getText()) == null;
    }

    private boolean generateExpressionRoot(PsiBuilder builder, int level, ExpressionHelper.ExpressionInfo info, int priority_) {
        LinkedHashMap<String, List<ExpressionHelper.OperatorInfo>> opCalls = new LinkedHashMap<String, List<ExpressionHelper.OperatorInfo>>();
        for (BnfRule rule : info.priorityMap.keySet()) {
            ExpressionHelper.OperatorInfo operator = info.operatorMap.get(rule);
            String opCall = ParserGeneratorUtil.getNextName(operator.rule.getName(), 0);
            ArrayList<ExpressionHelper.OperatorInfo> list = (ArrayList<ExpressionHelper.OperatorInfo>)opCalls.get(opCall);
            if (list == null) {
                list = new ArrayList<ExpressionHelper.OperatorInfo>(2);
                opCalls.put(opCall, list);
            }
            list.add(operator);
        }
        String methodName = info.rootRule.getName();
        String kernelMethodName = ParserGeneratorUtil.getNextName(methodName, 0);
        String frameName = ParserGeneratorUtil.getRuleDisplayName(info.rootRule, true);
        if (!GeneratedParserUtilBase.recursion_guard_(builder, level, methodName)) {
            return false;
        }
        if (frameName != null) {
            GeneratedParserUtilBase.addVariant(builder, frameName);
        }
        boolean result_ = false;
        PsiBuilder.Marker marker_ = GeneratedParserUtilBase.enter_section_(builder, level, 0, frameName);
        boolean first = true;
        for (ExpressionHelper.OperatorInfo operator : LivePreviewParser.filter(opCalls, ExpressionHelper.OperatorType.ATOM, ExpressionHelper.OperatorType.PREFIX)) {
            if (first || !result_) {
                result_ = this.generateNodeCall(builder, level, operator.rule, null, operator.rule.getName(), Collections.emptyMap());
            }
            first = false;
        }
        boolean pinned_ = result_;
        result_ = result_ && this.generateKernelMethod(builder, level + 1, kernelMethodName, info, opCalls, priority_);
        GeneratedParserUtilBase.exit_section_(builder, level, marker_, null, result_, pinned_, null);
        return result_ || pinned_;
    }

    private boolean generateKernelMethod(PsiBuilder builder, int level, String methodName, ExpressionHelper.ExpressionInfo info, Map<String, List<ExpressionHelper.OperatorInfo>> opCalls, int priority_) {
        if (!GeneratedParserUtilBase.recursion_guard_(builder, level, methodName)) {
            return false;
        }
        PsiBuilder.Marker marker_ = null;
        boolean result_ = true;
        int pos = GeneratedParserUtilBase.current_position_(builder);
        block0: while (true) {
            PsiBuilder.Marker left_marker_;
            if (!GeneratedParserUtilBase.invalid_left_marker_guard_(builder, left_marker_ = (PsiBuilder.Marker)builder.getLatestDoneMarker(), methodName)) {
                return false;
            }
            for (ExpressionHelper.OperatorInfo operator : LivePreviewParser.filter(opCalls, ExpressionHelper.OperatorType.BINARY, ExpressionHelper.OperatorType.N_ARY, ExpressionHelper.OperatorType.POSTFIX)) {
                int argPriority;
                int priority = info.getPriority(operator.rule);
                int arg2Priority = operator.arg2 == null ? -1 : info.getPriority(operator.arg2);
                int n = argPriority = arg2Priority == -1 ? priority : arg2Priority - 1;
                if (marker_ == null) {
                    marker_ = builder.mark();
                }
                if (priority_ >= priority || operator.arg1 != null && ((LighterASTNode)left_marker_).getTokenType() != this.getRuleElementType(operator.arg1) || !this.generateNodeCall(builder, level, info.rootRule, operator.operator, ParserGeneratorUtil.getNextName(operator.rule.getName(), 0), Collections.emptyMap())) continue;
                IElementType elementType = this.getRuleElementType(operator.rule);
                boolean rightAssociative = ParserGeneratorUtil.getAttribute(operator.rule, KnownAttribute.RIGHT_ASSOCIATIVE);
                if (operator.type == ExpressionHelper.OperatorType.BINARY) {
                    result_ = GeneratedParserUtilBase.report_error_(builder, this.generateExpressionRoot(builder, level, info, rightAssociative ? argPriority - 1 : argPriority));
                    if (operator.tail != null) {
                        result_ = GeneratedParserUtilBase.report_error_(builder, this.generateNodeCall(builder, level, operator.rule, operator.tail, ParserGeneratorUtil.getNextName(operator.rule.getName(), 1), Collections.emptyMap())) && result_;
                    }
                } else if (operator.type == ExpressionHelper.OperatorType.N_ARY) {
                    int nary_pos = GeneratedParserUtilBase.current_position_(builder);
                    while (true) {
                        result_ = GeneratedParserUtilBase.report_error_(builder, this.generateExpressionRoot(builder, level, info, argPriority));
                        if (operator.tail != null) {
                            boolean bl = result_ = GeneratedParserUtilBase.report_error_(builder, this.generateNodeCall(builder, level, operator.rule, operator.tail, ParserGeneratorUtil.getNextName(operator.rule.getName(), 1), Collections.emptyMap())) && result_;
                        }
                        if (result_ && this.generateNodeCall(builder, level, info.rootRule, operator.operator, ParserGeneratorUtil.getNextName(operator.rule.getName(), 0), Collections.emptyMap()) && GeneratedParserUtilBase.empty_element_parsed_guard_(builder, operator.operator.getText(), nary_pos)) {
                            nary_pos = GeneratedParserUtilBase.current_position_(builder);
                            continue;
                        }
                        break;
                    }
                } else if (operator.type == ExpressionHelper.OperatorType.POSTFIX) {
                    result_ = true;
                }
                marker_.drop();
                left_marker_.precede().done(elementType);
                marker_ = null;
                if (!GeneratedParserUtilBase.empty_element_parsed_guard_(builder, info.rootRule.getName(), pos)) break block0;
                pos = GeneratedParserUtilBase.current_position_(builder);
                continue block0;
            }
            break;
        }
        GeneratedParserUtilBase.exit_section_(builder, marker_, null, false);
        return result_;
    }

    private static Iterable<ExpressionHelper.OperatorInfo> filter(Map<String, List<ExpressionHelper.OperatorInfo>> opCalls, ExpressionHelper.OperatorType ... operatorTypes) {
        return ContainerUtil.mapNotNull(opCalls.keySet(), opCall -> (ExpressionHelper.OperatorInfo)ContainerUtil.getFirstItem(ExpressionGeneratorHelper.findOperators((Collection)opCalls.get(opCall), operatorTypes)));
    }

    private IElementType[] generateAutoRecoverCall(BnfRule rule) {
        Set<BnfExpression> nextExprSet = this.myFirstNextAnalyzer.calcNext(rule).keySet();
        Set<String> nextSet = BnfFirstNextAnalyzer.asStrings(nextExprSet);
        ArrayList<IElementType> tokenTypes = new ArrayList<IElementType>(nextSet.size());
        for (String s : nextSet) {
            IElementType t;
            if (this.myFile.getRule(s) != null || s == "-eof-" || s == "-never-matches-") continue;
            boolean unknown = s == "-any-";
            IElementType iElementType = t = unknown ? null : this.getTokenElementType(this.getTokenName(GrammarUtil.unquote(s)));
            if (t != null) {
                tokenTypes.add(t);
                continue;
            }
            tokenTypes.clear();
            break;
        }
        return tokenTypes.toArray(IElementType.EMPTY_ARRAY);
    }
}

