/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.grammar.livePreview.LivePreviewFileType;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.livePreview.LivePreviewLexer;
import org.intellij.grammar.livePreview.LivePreviewParser;
import org.jetbrains.annotations.NotNull;

public class LivePreviewParserDefinition
implements ParserDefinition {
    public static final IElementType COMMENT = new IElementType("COMMENT", LivePreviewLanguage.BASE_INSTANCE);
    public static final IElementType STRING = new IElementType("STRING", LivePreviewLanguage.BASE_INSTANCE);
    public static final IElementType NUMBER = new IElementType("NUMBER", LivePreviewLanguage.BASE_INSTANCE);
    public static final IElementType KEYWORD = new IElementType("KEYWORD", LivePreviewLanguage.BASE_INSTANCE);
    private static final TokenSet ourWhiteSpaceTokens = TokenSet.WHITE_SPACE;
    private static final TokenSet ourCommentTokens = TokenSet.create((IElementType[])new IElementType[]{COMMENT});
    private static final TokenSet ourStringLiteralElements = TokenSet.create((IElementType[])new IElementType[]{STRING});
    private final LivePreviewLanguage myLanguage;
    private final IFileElementType myFileElementType;

    public LivePreviewParserDefinition(LivePreviewLanguage language) {
        this.myLanguage = language;
        this.myFileElementType = new IFileElementType((Language)this.myLanguage);
    }

    @NotNull
    public Lexer createLexer(Project project) {
        return new LivePreviewLexer(project, this.myLanguage);
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new LivePreviewParser(project, this.myLanguage);
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return this.myFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return ourWhiteSpaceTokens;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return ourCommentTokens;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return ourStringLiteralElements;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        return new PsiFileBase(viewProvider, this.myLanguage){

            @NotNull
            public FileType getFileType() {
                return LivePreviewFileType.INSTANCE;
            }
        };
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

