/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.intellij.grammar.BnfIcons;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.livePreview.LivePreviewElementType;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreviewStructureViewFactory
implements PsiStructureViewFactory {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (!(psiFile.getLanguage() instanceof LivePreviewLanguage)) {
            return null;
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new MyModel(psiFile);
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    private static class MyElement
    extends PsiTreeElementBase<PsiElement>
    implements SortableTreeElement,
    ColoredItemPresentation {
        MyElement(PsiElement element) {
            super(element);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            PsiElement element = this.getElement();
            if (element == null || element instanceof LeafPsiElement) {
                return Collections.emptyList();
            }
            ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
            for (PsiElement e = element.getFirstChild(); e != null; e = e.getNextSibling()) {
                if (e instanceof PsiWhiteSpace) continue;
                result.add((StructureViewTreeElement)new MyElement(e));
            }
            return result;
        }

        @NotNull
        public String getAlphaSortKey() {
            return this.getPresentableText();
        }

        @NotNull
        public String getPresentableText() {
            BnfRule rule;
            IElementType elementType;
            PsiElement element = this.getElement();
            ASTNode node = element != null ? element.getNode() : null;
            IElementType iElementType = elementType = node != null ? node.getElementType() : null;
            if (element instanceof LeafPsiElement) {
                return elementType + ": '" + element.getText() + "'";
            }
            if (element instanceof PsiErrorElement) {
                return "PsiErrorElement: '" + ((PsiErrorElement)element).getErrorDescription() + "'";
            }
            if (elementType instanceof LivePreviewElementType.RuleType && (rule = ((LivePreviewElementType.RuleType)elementType).getRule(element.getProject())) != null) {
                BnfFile file = (BnfFile)rule.getContainingFile();
                String className = ParserGeneratorUtil.getRulePsiClassName(rule, ParserGeneratorUtil.getPsiClassFormat(file));
                return className + ": '" + StringUtil.first((String)element.getText(), (int)30, (boolean)true) + "'";
            }
            return String.valueOf(elementType);
        }

        @Nullable
        public String getLocationString() {
            return null;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            IElementType elementType;
            PsiElement element = this.getElement();
            if (element instanceof PsiErrorElement) {
                return null;
            }
            if (element instanceof LeafPsiElement) {
                return null;
            }
            ASTNode node = element != null ? element.getNode() : null;
            IElementType iElementType = elementType = node != null ? node.getElementType() : null;
            if (elementType instanceof LivePreviewElementType.RuleType) {
                return BnfIcons.RULE;
            }
            return null;
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            return this.getElement() instanceof PsiErrorElement ? CodeInsightColors.ERRORS_ATTRIBUTES : null;
        }
    }

    private static class MyModel
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        protected MyModel(@NotNull PsiFile psiFile) {
            super(psiFile, (StructureViewTreeElement)new MyElement((PsiElement)psiFile));
            this.withSuitableClasses(new Class[]{PsiElement.class});
        }

        public boolean shouldEnterElement(Object element) {
            return true;
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element) {
            return element.getValue() instanceof LeafPsiElement;
        }
    }
}

