/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.livePreview;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import org.intellij.grammar.livePreview.LivePreviewElementType;
import org.intellij.grammar.livePreview.LivePreviewLanguage;
import org.intellij.grammar.livePreview.LivePreviewLexer;
import org.intellij.grammar.livePreview.LivePreviewParserDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivePreviewSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(final @Nullable Project project, @Nullable VirtualFile virtualFile) {
        Language language;
        Language language2 = language = virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)virtualFile).getLanguage() : null;
        if (!(language instanceof LivePreviewLanguage)) {
            return new PlainSyntaxHighlighter();
        }
        return new SyntaxHighlighterBase(){

            @NotNull
            public Lexer getHighlightingLexer() {
                return new LivePreviewLexer(project, (LivePreviewLanguage)language){

                    @Override
                    @Nullable
                    public IElementType getTokenType() {
                        IElementType tokenType = super.getTokenType();
                        return tokenType instanceof LivePreviewElementType.TokenType ? ((LivePreviewElementType.TokenType)tokenType).delegate : tokenType;
                    }
                };
            }

            public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
                if (tokenType == LivePreviewParserDefinition.COMMENT) {
                    return 1.pack((TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
                }
                if (tokenType == LivePreviewParserDefinition.STRING) {
                    return 1.pack((TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
                }
                if (tokenType == LivePreviewParserDefinition.NUMBER) {
                    return 1.pack((TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
                }
                if (tokenType == LivePreviewParserDefinition.KEYWORD) {
                    return 1.pack((TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
                }
                if (tokenType == TokenType.BAD_CHARACTER) {
                    return 1.pack((TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
                }
                return TextAttributesKey.EMPTY_ARRAY;
            }
        };
    }
}

