/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.intellij.grammar.BnfLanguage;
import org.intellij.grammar.psi.BnfAttr;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfRule;

public class BnfElementFactory {
    private static final Logger LOG = Logger.getInstance(BnfElementFactory.class);

    private BnfElementFactory() {
    }

    private static PsiFile createFile(Project project, String text) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("a.bnf", (Language)BnfLanguage.INSTANCE, (CharSequence)text, false, false);
    }

    public static PsiElement createLeafFromText(Project project, String text) {
        return PsiTreeUtil.getDeepestFirst((PsiElement)BnfElementFactory.createFile(project, text));
    }

    public static BnfExpression createExpressionFromText(Project project, String text) {
        return BnfElementFactory.createRuleFromText(project, "a ::= " + text).getExpression();
    }

    public static BnfRule createRuleFromText(Project project, String text) {
        PsiElement firstChild = BnfElementFactory.createFile(project, text).getFirstChild();
        LOG.assertTrue(firstChild instanceof BnfRule, (Object)text);
        return (BnfRule)firstChild;
    }

    public static BnfAttr createAttributeFromText(Project project, String text) {
        PsiElement firstChild = BnfElementFactory.createFile(project, "{\n  " + text + "\n}").getFirstChild();
        LOG.assertTrue(firstChild instanceof BnfAttrs, (Object)text);
        List<BnfAttr> attrList = ((BnfAttrs)firstChild).getAttrList();
        LOG.assertTrue(attrList.size() == 1, (Object)text);
        return attrList.get(0);
    }
}

