/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.grammar.psi.BnfFile;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.intellij.grammar.psi.impl.BnfExpressionImpl;
import org.intellij.grammar.psi.impl.BnfReferenceImpl;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BnfRefOrTokenImpl
extends BnfExpressionImpl
implements BnfReferenceOrToken {
    public BnfRefOrTokenImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    @Nullable
    public BnfRule resolveRule() {
        PsiFile file = this.getContainingFile();
        return file instanceof BnfFile ? ((BnfFile)file).getRule(GrammarUtil.getIdText(this.getId())) : null;
    }

    public PsiReference getReference() {
        int delta = GrammarUtil.isIdQuoted(this.getId().getText()) ? 1 : 0;
        TextRange range = TextRange.create((int)delta, (int)(this.getTextLength() - delta));
        return new BnfReferenceImpl<BnfReferenceOrToken>((BnfReferenceOrToken)this, range){

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                ((BnfReferenceOrToken)this.myElement).getId().replace(BnfElementFactory.createLeafFromText(((BnfReferenceOrToken)this.getElement()).getProject(), newElementName));
                return this.myElement;
            }
        };
    }
}

