/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfLiteralExpression;
import org.intellij.grammar.psi.BnfParenExpression;
import org.intellij.grammar.psi.BnfParenOptExpression;
import org.intellij.grammar.psi.BnfParenthesized;
import org.intellij.grammar.psi.BnfQuantified;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.jetbrains.annotations.NotNull;

public class BnfExpressionOptimizer {
    public static void optimize(@NotNull Project project, @NotNull PsiElement element) {
        LinkedList<PsiElement> list = new LinkedList<PsiElement>();
        list.add(element.getParent());
        list.add(element);
        while (!list.isEmpty()) {
            IElementType type2;
            BnfExpression child;
            PsiElement cur = (PsiElement)list.removeLast();
            PsiElement parent = cur.getParent();
            if (BnfExpressionOptimizer.isTrivial(cur)) {
                BnfExpressionOptimizer.mergeChildrenTo(parent, cur, list);
                continue;
            }
            if (cur instanceof BnfParenOptExpression && BnfExpressionOptimizer.isTrivialOrSingular(((BnfParenOptExpression)cur).getExpression())) {
                String replacement;
                child = ((BnfParenOptExpression)cur).getExpression();
                IElementType type = ParserGeneratorUtil.getEffectiveType(child);
                if (type == BnfTypes.BNF_OP_OPT || type == BnfTypes.BNF_OP_ZEROMORE) {
                    list.add(cur.replace((PsiElement)child));
                    continue;
                }
                if (type == BnfTypes.BNF_OP_ONEMORE) {
                    replacement = ((BnfQuantified)child).getExpression().getText() + "*";
                    list.add(cur.replace((PsiElement)BnfElementFactory.createExpressionFromText(project, replacement)));
                    continue;
                }
                replacement = child.getText() + "?";
                list.add(cur.replace((PsiElement)BnfElementFactory.createExpressionFromText(project, replacement)));
                continue;
            }
            if (cur instanceof BnfChoice && !(parent instanceof BnfParenthesized) && (parent instanceof BnfSequence || parent instanceof BnfQuantified)) {
                String replacement = "(" + cur.getText() + ")";
                cur.replace((PsiElement)BnfElementFactory.createExpressionFromText(project, replacement));
                continue;
            }
            if (!BnfExpressionOptimizer.isOptMany(cur) || !BnfExpressionOptimizer.isOptMany(PsiTreeUtil.getChildOfType((PsiElement)cur, BnfExpression.class))) continue;
            child = (BnfExpression)PsiTreeUtil.getChildOfType((PsiElement)cur, BnfExpression.class);
            IElementType type1 = ParserGeneratorUtil.getEffectiveType(cur);
            if (type1 == (type2 = ParserGeneratorUtil.getEffectiveType(child))) {
                list.add(cur.replace((PsiElement)child));
                continue;
            }
            if (!(type1 == BnfTypes.BNF_OP_OPT && type2 == BnfTypes.BNF_OP_ONEMORE || type2 == BnfTypes.BNF_OP_OPT && type1 == BnfTypes.BNF_OP_ONEMORE || type1 == BnfTypes.BNF_OP_ZEROMORE) && type2 != BnfTypes.BNF_OP_ZEROMORE) continue;
            BnfExpression childOfChild = (BnfExpression)PsiTreeUtil.getChildOfType((PsiElement)child, BnfExpression.class);
            String childText = childOfChild == null ? "" : childOfChild.getText();
            String replacement = (String)(child instanceof BnfParenthesized ? "(" + childText + ")" : childText) + "*";
            cur.replace((PsiElement)BnfElementFactory.createExpressionFromText(project, replacement));
        }
    }

    private static boolean isOptMany(PsiElement cur) {
        return cur instanceof BnfQuantified || cur instanceof BnfParenOptExpression;
    }

    private static boolean canBeMergedInto(PsiElement cur, PsiElement parent) {
        if (cur instanceof BnfSequence) {
            if (parent instanceof BnfChoice) {
                return true;
            }
            if (parent instanceof BnfSequence) {
                List<BnfExpression> list = ((BnfSequence)parent).getExpressionList();
                return list.isEmpty() || !GrammarUtil.isExternalReference(list.get(0));
            }
        }
        return cur instanceof BnfChoice && parent instanceof BnfChoice;
    }

    private static void mergeChildrenTo(PsiElement parent, PsiElement cur, List<PsiElement> list) {
        boolean skipParens = cur instanceof BnfParenthesized;
        PsiElement last = cur.getLastChild();
        PsiElement first = cur.getFirstChild();
        if (skipParens) {
            last = last.getPrevSibling();
            first = first.getNextSibling();
        }
        for (cur = BnfExpressionOptimizer.unwrap(parent, first, last, cur); cur != null; cur = cur.getNextSibling()) {
            if (cur instanceof BnfExpression) {
                list.add(cur);
            }
            if (cur == last) break;
        }
    }

    private static PsiElement unwrap(PsiElement parent, PsiElement first, PsiElement last, PsiElement from) {
        while (first != last && first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        while (last != first && last instanceof PsiWhiteSpace) {
            last = last.getPrevSibling();
        }
        if (first == null || last == null || first == last && last instanceof PsiWhiteSpace) {
            return null;
        }
        PsiElement result = parent.addRangeBefore(first, last, from);
        from.delete();
        return result;
    }

    private static boolean isTrivial(PsiElement element) {
        PsiElement parent = element.getParent();
        if (element instanceof BnfParenthesized && parent instanceof BnfRule && !BnfExpressionOptimizer.isOptMany(element) && !(element instanceof BnfChoice)) {
            return true;
        }
        if (element instanceof BnfParenExpression && (BnfExpressionOptimizer.canBeMergedInto(((BnfParenExpression)element).getExpression(), parent) || parent instanceof BnfParenthesized || BnfExpressionOptimizer.isTrivialOrSingular(((BnfParenExpression)element).getExpression()))) {
            return true;
        }
        if (element instanceof BnfSequence && (((BnfSequence)element).getExpressionList().size() == 1 || parent instanceof BnfSequence)) {
            return true;
        }
        return element instanceof BnfChoice && (((BnfChoice)element).getExpressionList().size() == 1 || parent instanceof BnfChoice);
    }

    private static boolean isTrivialOrSingular(PsiElement element) {
        return element instanceof BnfReferenceOrToken || element instanceof BnfLiteralExpression || element instanceof BnfParenthesized || element instanceof BnfQuantified || BnfExpressionOptimizer.isTrivial(element);
    }
}

