/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;
import org.intellij.grammar.BnfLanguage;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.intellij.grammar.refactor.InlineRuleDialog;

public class BnfInlineRuleActionHandler
extends InlineActionHandler {
    public boolean isEnabledForLanguage(Language language) {
        return language == BnfLanguage.INSTANCE;
    }

    public boolean canInlineElement(PsiElement psiElement) {
        return psiElement instanceof BnfRule;
    }

    public void inlineElement(Project project, Editor editor, PsiElement psiElement) {
        PsiReference reference;
        BnfRule rule = (BnfRule)psiElement;
        BnfAttrs attrs = rule.getAttrs();
        if (PsiTreeUtil.hasErrorElements((PsiElement)rule)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Rule has errors", (String)"Inline Rule", null);
            return;
        }
        if (attrs != null && !attrs.getAttrList().isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Rule has attributes", (String)"Inline Rule", null);
            return;
        }
        Collection allReferences = ReferencesSearch.search((PsiElement)psiElement).findAll();
        if (allReferences.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Rule is never used", (String)"Inline Rule", null);
            return;
        }
        boolean hasNonAttributeRefs = false;
        for (PsiReference ref : allReferences) {
            if (GrammarUtil.isInAttributesReference(ref.getElement())) continue;
            hasNonAttributeRefs = true;
            break;
        }
        if (!hasNonAttributeRefs) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Rule is referenced only in attributes", (String)"Inline Rule", null);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)rule)) {
            return;
        }
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        if (reference != null && !rule.equals(reference.resolve())) {
            reference = null;
        }
        InlineRuleDialog dialog = new InlineRuleDialog(project, rule, reference);
        dialog.show();
    }
}

