/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.grammar.refactor;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.intellij.grammar.generator.ParserGeneratorUtil;
import org.intellij.grammar.psi.BnfAttrs;
import org.intellij.grammar.psi.BnfChoice;
import org.intellij.grammar.psi.BnfExpression;
import org.intellij.grammar.psi.BnfReferenceOrToken;
import org.intellij.grammar.psi.BnfRule;
import org.intellij.grammar.psi.BnfSequence;
import org.intellij.grammar.psi.BnfTypes;
import org.intellij.grammar.psi.impl.BnfElementFactory;
import org.intellij.grammar.psi.impl.BnfFileImpl;
import org.intellij.grammar.psi.impl.GrammarUtil;
import org.intellij.grammar.refactor.BnfExpressionOptimizer;
import org.intellij.grammar.refactor.BnfIntroduceRulePopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class BnfIntroduceRuleHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = "Extract Rule";
    public static final Function<BnfExpression, String> RENDER_FUNCTION = bnfExpression -> bnfExpression.getText().replaceAll("\\s+", " ");
    @Nullable
    private final Function<? super List<BnfExpression>, ? extends BnfExpression> myPopupVariantsHandler;

    public BnfIntroduceRuleHandler() {
        this.myPopupVariantsHandler = null;
    }

    @TestOnly
    public BnfIntroduceRuleHandler(@Nullable Function<? super List<BnfExpression>, ? extends BnfExpression> popupVariantsHandler) {
        this.myPopupVariantsHandler = popupVariantsHandler;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, @Nullable DataContext dataContext) {
        BnfExpression parentExpression;
        if (!(file instanceof BnfFileImpl)) {
            return;
        }
        BnfFileImpl bnfFile = (BnfFileImpl)file;
        SelectionModel selectionModel = editor.getSelectionModel();
        int[] starts = selectionModel.getBlockSelectionStarts();
        int[] ends = selectionModel.getBlockSelectionEnds();
        if (starts.length == 0) {
            return;
        }
        int startOffset = starts[0];
        int endOffset = ends[ends.length - 1];
        final BnfRule currentRule = (BnfRule)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), BnfRule.class);
        BnfExpression bnfExpression = parentExpression = currentRule != null ? BnfIntroduceRuleHandler.findParentExpression(bnfFile, startOffset, endOffset) : null;
        if (parentExpression == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"refactoring.introduce.context.error"), (String)"Error", null);
            return;
        }
        if (!selectionModel.hasSelection()) {
            ArrayList<BnfExpression> expressions = new ArrayList<BnfExpression>();
            while (parentExpression != null) {
                expressions.add(parentExpression);
                parentExpression = (BnfExpression)PsiTreeUtil.getParentOfType((PsiElement)parentExpression, BnfExpression.class);
            }
            if (expressions.size() == 1) {
                BnfIntroduceRuleHandler.invokeIntroduce(project, editor, file, currentRule, expressions);
            } else if (this.myPopupVariantsHandler != null) {
                BnfIntroduceRuleHandler.invokeIntroduce(project, editor, file, currentRule, Collections.singletonList((BnfExpression)this.myPopupVariantsHandler.fun(expressions)));
            } else {
                IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<BnfExpression>(){

                    public void pass(BnfExpression bnfExpression) {
                        BnfIntroduceRuleHandler.invokeIntroduce(project, editor, file, currentRule, Collections.singletonList(bnfExpression));
                    }
                }, RENDER_FUNCTION, (String)"Expressions");
            }
        } else {
            List<BnfExpression> selectedExpression = BnfIntroduceRuleHandler.findSelectedExpressionsInRange(parentExpression, new TextRange(startOffset, endOffset));
            if (selectedExpression.isEmpty()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"refactoring.introduce.selection.error"), (String)"Error", null);
                return;
            }
            BnfIntroduceRuleHandler.invokeIntroduce(project, editor, file, currentRule, selectedExpression);
        }
    }

    private static void invokeIntroduce(final Project project, final Editor editor, final PsiFile file, final BnfRule currentRule, final List<BnfExpression> selectedExpression) {
        BnfExpression firstExpression = Objects.requireNonNull((BnfExpression)ContainerUtil.getFirstItem(selectedExpression));
        BnfExpression lastExpression = Objects.requireNonNull((BnfExpression)ContainerUtil.getLastItem(selectedExpression));
        TextRange fixedRange = new TextRange(firstExpression.getTextRange().getStartOffset(), lastExpression.getTextRange().getEndOffset());
        final BnfRule ruleFromText = BnfElementFactory.createRuleFromText(project, "a ::= " + fixedRange.substring(file.getText()));
        BnfExpressionOptimizer.optimize(project, ruleFromText.getExpression());
        final LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<Object>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<Object>>();
        occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(selectedExpression.toArray(GrammarUtil.EMPTY_EXPRESSIONS_ARRAY)));
        occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, new ArrayList());
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof BnfExpression) {
                    BnfIntroduceRuleHandler.findOccurrences((BnfExpression)element, selectedExpression, occurrencesMap);
                } else if (element instanceof BnfAttrs) {
                    return;
                }
                super.visitElement(element);
            }
        });
        if (((List)occurrencesMap.get(OccurrencesChooser.ReplaceChoice.ALL)).size() <= 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            occurrencesMap.remove(OccurrencesChooser.ReplaceChoice.ALL);
        }
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)BnfIntroduceRuleHandler.REFACTORING_NAME, null, () -> {
                    PsiFile containingFile = currentRule.getContainingFile();
                    String newRuleName = BnfIntroduceRuleHandler.choseRuleName(containingFile);
                    String newRuleText = "private " + newRuleName + " ::= " + ruleFromText.getExpression().getText();
                    BnfRule addedRule = BnfIntroduceRuleHandler.addNextRule(project, currentRule, newRuleText);
                    if (choice == OccurrencesChooser.ReplaceChoice.ALL) {
                        exprToReplace = (List)occurrencesMap.get(OccurrencesChooser.ReplaceChoice.ALL);
                        BnfIntroduceRuleHandler.replaceUsages(project, exprToReplace, addedRule.getId());
                    } else {
                        exprToReplace = (List)occurrencesMap.get(OccurrencesChooser.ReplaceChoice.NO);
                        BnfIntroduceRuleHandler.replaceUsages(project, exprToReplace, addedRule.getId());
                    }
                    BnfIntroduceRulePopup popup = new BnfIntroduceRulePopup(project, editor, addedRule, addedRule.getExpression());
                    editor.getCaretModel().moveToOffset(addedRule.getTextOffset());
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    popup.performInplaceRefactoring(null);
                }, (PsiFile[])new PsiFile[]{file});
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            callback.pass((Object)OccurrencesChooser.ReplaceChoice.ALL);
        } else {
            new OccurrencesChooser<BnfExpression[]>(editor){

                protected TextRange getOccurrenceRange(BnfExpression[] occurrence) {
                    return new TextRange(occurrence[0].getTextRange().getStartOffset(), occurrence[occurrence.length - 1].getTextRange().getEndOffset());
                }
            }.showChooser((Pass)callback, occurrencesMap);
        }
    }

    public static BnfRule addNextRule(Project project, BnfRule currentRule, String newRuleText) {
        BnfRule addedRule = (BnfRule)currentRule.getParent().addAfter((PsiElement)BnfElementFactory.createRuleFromText(project, newRuleText), (PsiElement)currentRule);
        currentRule.getParent().addBefore(BnfElementFactory.createLeafFromText(project, "\n"), (PsiElement)addedRule);
        if (BnfIntroduceRuleHandler.endsWithSemicolon(currentRule)) {
            addedRule.addBefore(BnfElementFactory.createLeafFromText(project, ";"), null);
            if (currentRule.getNextSibling() instanceof PsiWhiteSpace) {
                currentRule.getParent().addAfter(BnfElementFactory.createLeafFromText(project, "\n"), (PsiElement)addedRule);
            }
        }
        return addedRule;
    }

    public static boolean endsWithSemicolon(BnfRule rule) {
        return rule.getLastChild().getNode().getElementType() == BnfTypes.BNF_SEMICOLON;
    }

    private static List<BnfExpression> findSelectedExpressionsInRange(BnfExpression parentExpression, TextRange range) {
        if (parentExpression.getTextRange().equals((Object)range)) {
            if (parentExpression instanceof BnfSequence) {
                return ((BnfSequence)parentExpression).getExpressionList();
            }
            if (parentExpression instanceof BnfChoice) {
                return ((BnfChoice)parentExpression).getExpressionList();
            }
            return Collections.singletonList(parentExpression);
        }
        ArrayList<BnfExpression> list = new ArrayList<BnfExpression>();
        for (PsiElement c = parentExpression.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (c instanceof PsiWhiteSpace || !c.getTextRange().intersectsStrict(range)) continue;
            if (c instanceof BnfExpression) {
                list.add((BnfExpression)c);
                continue;
            }
            if (c != parentExpression.getFirstChild() && c != parentExpression.getLastChild()) continue;
            return Collections.singletonList(parentExpression);
        }
        return list;
    }

    private static void replaceUsages(Project project, List<BnfExpression[]> exprToReplace, PsiElement id) {
        for (BnfExpression[] expression : exprToReplace) {
            BnfIntroduceRuleHandler.replaceExpression(project, expression, id);
        }
    }

    private static void replaceExpression(Project project, BnfExpression[] oldExpression, PsiElement id) {
        PsiElement parent = oldExpression[0].getParent();
        parent.addBefore((PsiElement)BnfElementFactory.createRuleFromText(project, "a::=" + id.getText()).getExpression(), (PsiElement)oldExpression[0]);
        parent.deleteChildRange((PsiElement)oldExpression[0], (PsiElement)oldExpression[oldExpression.length - 1]);
    }

    private static void findOccurrences(BnfExpression expression, List<BnfExpression> selectedExpressions, Map<OccurrencesChooser.ReplaceChoice, List<BnfExpression[]>> occurrencesMap) {
        if (selectedExpressions.size() == 1) {
            if (GrammarUtil.equalsElement(expression, selectedExpressions.get(0))) {
                BnfIntroduceRuleHandler.addOccurrence(OccurrencesChooser.ReplaceChoice.ALL, occurrencesMap, expression);
            }
        } else if (!GrammarUtil.isOneTokenExpression(expression)) {
            PsiElement selectedParent = selectedExpressions.get(0).getParent();
            if (ParserGeneratorUtil.getEffectiveType(expression) != ParserGeneratorUtil.getEffectiveType(selectedParent)) {
                return;
            }
            int pos = 0;
            BnfExpression[] result = new BnfExpression[selectedExpressions.size()];
            PsiElement s = null;
            for (PsiElement c = expression.getFirstChild(); c != null; c = c.getNextSibling()) {
                if (!(c instanceof BnfExpression)) continue;
                if (GrammarUtil.equalsElement((BnfExpression)c, selectedExpressions.get(pos))) {
                    if (pos == 0) {
                        s = c;
                    }
                    result[pos] = (BnfExpression)c;
                    if (++pos != result.length) continue;
                    BnfIntroduceRuleHandler.addOccurrence(OccurrencesChooser.ReplaceChoice.ALL, occurrencesMap, (BnfExpression[])result.clone());
                    pos = 0;
                    continue;
                }
                if (s == null) continue;
                c = s;
                pos = 0;
                s = null;
            }
        }
    }

    private static void addOccurrence(OccurrencesChooser.ReplaceChoice choice, Map<OccurrencesChooser.ReplaceChoice, List<BnfExpression[]>> occurrencesMap, BnfExpression ... expressions) {
        List<BnfExpression[]> list = occurrencesMap.get(choice);
        if (list == null) {
            list = new LinkedList<BnfExpression[]>();
            occurrencesMap.put(choice, list);
        }
        list.add(expressions);
    }

    private static String choseRuleName(PsiFile containingFile) {
        final HashSet existingNames = new HashSet();
        containingFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof BnfAttrs) {
                    return;
                }
                if (element instanceof BnfReferenceOrToken) {
                    existingNames.add(((BnfReferenceOrToken)element).getId().getText());
                } else if (element instanceof BnfRule) {
                    existingNames.add(((BnfRule)element).getName());
                }
                super.visitElement(element);
            }
        });
        Object name = "rule";
        int i = 1;
        while (existingNames.contains(name)) {
            name = "rule" + i;
            ++i;
        }
        return name;
    }

    @Nullable
    private static BnfExpression findParentExpression(PsiFile file, int startOffset, int endOffset) {
        if (endOffset > startOffset) {
            --endOffset;
        }
        PsiElement startElement = file.findElementAt(startOffset);
        PsiElement endElement = file.findElementAt(endOffset);
        if (startElement == null || endElement == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
        return (BnfExpression)PsiTreeUtil.getParentOfType((PsiElement)commonParent, BnfExpression.class, (boolean)false);
    }
}

